/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.handlers.ClientHandler;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.VertexTranslation;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    @Nonnull
    public static final Vector4f DEFAULT_TEXT_SHADOW_COL = new Vector4f(0.33f, 0.33f, 0.33f, 0.33f);
    @Nonnull
    public static final Vector4f DEFAULT_TXT_COL = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    @Nonnull
    public static final Vector4f DEFAULT_TEXT_BG_COL = new Vector4f(0.275f, 0.08f, 0.4f, 0.75f);
    @Nonnull
    public static final Vector3d UP_V = new Vector3d(0.0, 1.0, 0.0);
    @Nonnull
    public static final Vector3d ZERO_V = new Vector3d(0.0, 0.0, 0.0);
    @Nonnull
    private static final FloatBuffer MATRIX_BUFFER = GLAllocation.func_74529_h((int)16);
    @Nonnull
    public static final ResourceLocation BLOCK_TEX = TextureMap.field_110575_b;
    @Nonnull
    public static final ResourceLocation GLINT_TEX = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static int BRIGHTNESS_MAX = 0xF000F0;

    public static void loadMatrix(@Nonnull Matrix4d mat) {
        MATRIX_BUFFER.rewind();
        MATRIX_BUFFER.put((float)mat.m00);
        MATRIX_BUFFER.put((float)mat.m01);
        MATRIX_BUFFER.put((float)mat.m02);
        MATRIX_BUFFER.put((float)mat.m03);
        MATRIX_BUFFER.put((float)mat.m10);
        MATRIX_BUFFER.put((float)mat.m11);
        MATRIX_BUFFER.put((float)mat.m12);
        MATRIX_BUFFER.put((float)mat.m13);
        MATRIX_BUFFER.put((float)mat.m20);
        MATRIX_BUFFER.put((float)mat.m21);
        MATRIX_BUFFER.put((float)mat.m22);
        MATRIX_BUFFER.put((float)mat.m23);
        MATRIX_BUFFER.put((float)mat.m30);
        MATRIX_BUFFER.put((float)mat.m31);
        MATRIX_BUFFER.put((float)mat.m32);
        MATRIX_BUFFER.put((float)mat.m33);
        MATRIX_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)MATRIX_BUFFER);
    }

    @Nonnull
    public static TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static void bindBlockTexture() {
        RenderUtil.engine().func_110577_a(BLOCK_TEX);
    }

    public static void bindGlintTexture() {
        RenderUtil.engine().func_110577_a(GLINT_TEX);
    }

    public static void bindTexture(@Nonnull String string) {
        RenderUtil.engine().func_110577_a(new ResourceLocation(string));
    }

    public static void bindTexture(@Nonnull ResourceLocation tex) {
        RenderUtil.engine().func_110577_a(tex);
    }

    @Nonnull
    public static FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Nonnull
    public static float[] getDefaultPerSideBrightness() {
        float[] brightnessPerSide = new float[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            brightnessPerSide[dir.ordinal()] = RenderUtil.getColorMultiplierForFace(dir);
        }
        return brightnessPerSide;
    }

    public static float claculateTotalBrightnessForLocation(@Nonnull World worldObj, @Nonnull BlockPos pos) {
        int i = worldObj.func_175705_a(EnumSkyBlock.SKY, pos);
        int j = i % 65536;
        int k = i / 65536;
        float sunBrightness = worldObj.func_72971_b(1.0f);
        float percentRecievedFromSun = (float)k / 255.0f;
        float fromLights = (float)j / 255.0f;
        float highestValue = Math.max(fromLights, percentRecievedFromSun * sunBrightness);
        return Math.max(0.2f, highestValue);
    }

    public static float getColorMultiplierForFace(@Nonnull EnumFacing face) {
        if (face == EnumFacing.UP) {
            return 1.0f;
        }
        if (face == EnumFacing.DOWN) {
            return 0.5f;
        }
        if (face.func_82601_c() != 0) {
            return 0.6f;
        }
        return 0.8f;
    }

    public static void renderQuad2D(double x, double y, double z, double width, double height, int colorRGB) {
        GlStateManager.func_179090_x();
        Vector3f col = ColorUtil.toFloat(colorRGB);
        GlStateManager.func_179124_c((float)col.x, (float)col.y, (float)col.z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tes.func_181662_b(x, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y, z).func_181675_d();
        tes.func_181662_b(x, y, z).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void renderQuad2D(double x, double y, double z, double width, double height, @Nonnull Vector4f colorRGBA) {
        GlStateManager.func_179131_c((float)colorRGBA.x, (float)colorRGBA.y, (float)colorRGBA.z, (float)colorRGBA.w);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tes.func_181662_b(x, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y, z).func_181675_d();
        tes.func_181662_b(x, y, z).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static Matrix4d createBillboardMatrix(@Nonnull TileEntity te, @Nonnull EntityLivingBase entityPlayer) {
        BlockPos p = te.func_174877_v();
        return RenderUtil.createBillboardMatrix(new Vector3d((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5), entityPlayer);
    }

    public static Matrix4d createBillboardMatrix(@Nonnull Vector3d lookAt, @Nonnull EntityLivingBase entityPlayer) {
        Vector3d playerEye = new Vector3d(entityPlayer.field_70165_t, entityPlayer.field_70163_u + 1.62 - entityPlayer.func_70033_W(), entityPlayer.field_70161_v);
        Vector3d blockOrigin = new Vector3d(lookAt.x, lookAt.y, lookAt.z);
        Matrix4d lookMat = VecmathUtil.createMatrixAsLookAt(blockOrigin, playerEye, UP_V);
        lookMat.setTranslation(new Vector3d());
        lookMat.invert();
        return lookMat;
    }

    public static void renderBillboard(@Nonnull Matrix4d lookMat, float minU, float maxU, float minV, float maxV, double size, int brightness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double s = size / 2.0;
        Vector3d v = new Vector3d();
        v.set(-s, s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)minU, (double)maxV).func_181675_d();
        v.set(s, s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        v.set(s, -s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)maxU, (double)minV).func_181675_d();
        v.set(-s, -s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static List<EnumFacing> getEdgesForFace(@Nonnull EnumFacing face) {
        ArrayList<EnumFacing> result = new ArrayList<EnumFacing>(4);
        if (face.func_96559_d() != 0) {
            result.add(EnumFacing.NORTH);
            result.add(EnumFacing.EAST);
            result.add(EnumFacing.SOUTH);
            result.add(EnumFacing.WEST);
        } else if (face.func_82601_c() != 0) {
            result.add(EnumFacing.DOWN);
            result.add(EnumFacing.SOUTH);
            result.add(EnumFacing.UP);
            result.add(EnumFacing.NORTH);
        } else {
            result.add(EnumFacing.DOWN);
            result.add(EnumFacing.WEST);
            result.add(EnumFacing.UP);
            result.add(EnumFacing.EAST);
        }
        return result;
    }

    public static void addVerticesToTessellator(@Nullable List<Vertex> vertices, @Nonnull VertexFormat format, boolean doBegin) {
        RenderUtil.addVerticesToTessellator(vertices, null, format, doBegin);
    }

    public static void addVerticesToTessellator(@Nullable List<Vertex> vertices, VertexTranslation xForm, @Nonnull VertexFormat format, boolean doBegin) {
        List<Vertex> newV;
        if (vertices == null || vertices.isEmpty()) {
            return;
        }
        if (xForm != null) {
            newV = new ArrayList<Vertex>(vertices.size());
            for (Vertex v : vertices) {
                Vertex xv = new Vertex(v);
                xForm.apply(xv);
                newV.add(xv);
            }
        } else {
            newV = vertices;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder tes = tessellator.func_178180_c();
        if (doBegin) {
            tes.func_181668_a(7, format);
        }
        for (Vertex v : vertices) {
            for (VertexFormatElement el : format.func_177343_g()) {
                switch (el.func_177375_c()) {
                    case COLOR: {
                        if (el.func_177367_b() != VertexFormatElement.EnumType.FLOAT) break;
                        tes.func_181666_a(v.r(), v.g(), v.b(), v.a());
                        break;
                    }
                    case NORMAL: {
                        tes.func_181663_c(v.nx(), v.ny(), v.nz());
                        break;
                    }
                    case POSITION: {
                        tes.func_181662_b(v.x(), v.y(), v.z());
                        break;
                    }
                    case UV: {
                        if (el.func_177367_b() != VertexFormatElement.EnumType.FLOAT || v.uv == null) break;
                        tes.func_187315_a((double)v.u(), (double)v.v());
                        break;
                    }
                    case GENERIC: {
                        break;
                    }
                    case PADDING: {
                        break;
                    }
                }
            }
            tes.func_181675_d();
        }
    }

    public static void getUvForCorner(@Nonnull Vector2f uv, @Nonnull Vector3d corner, int x, int y, int z, @Nonnull EnumFacing face, @Nonnull TextureAtlasSprite icon) {
        Vector3d p = new Vector3d(corner);
        p.x -= (double)x;
        p.y -= (double)y;
        p.z -= (double)z;
        float uWidth = 1.0f;
        float vWidth = 1.0f;
        uWidth = icon.func_94212_f() - icon.func_94209_e();
        vWidth = icon.func_94210_h() - icon.func_94206_g();
        uv.x = (float)VecmathUtil.distanceFromPointToPlane(RenderUtil.getUPlaneForFace(face), p);
        uv.y = (float)VecmathUtil.distanceFromPointToPlane(RenderUtil.getVPlaneForFace(face), p);
        uv.x = icon.func_94209_e() + uv.x * uWidth;
        uv.y = icon.func_94206_g() + uv.y * vWidth;
    }

    @Nonnull
    public static Vector4d getVPlaneForFace(@Nonnull EnumFacing face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
        }
        return new Vector4d(0.0, -1.0, 0.0, 1.0);
    }

    @Nonnull
    public static Vector4d getUPlaneForFace(@Nonnull EnumFacing face) {
        switch (face) {
            case EAST: {
                return new Vector4d(0.0, 0.0, -1.0, 1.0);
            }
            case WEST: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
            case NORTH: {
                return new Vector4d(-1.0, 0.0, 0.0, 1.0);
            }
            case SOUTH: {
                return new Vector4d(1.0, 0.0, 0.0, 0.0);
            }
        }
        return new Vector4d(1.0, 0.0, 0.0, 0.0);
    }

    @Nonnull
    public static EnumFacing getVDirForFace(@Nonnull EnumFacing face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.UP;
    }

    @Nonnull
    public static EnumFacing getUDirForFace(@Nonnull EnumFacing face) {
        switch (face) {
            case EAST: {
                return EnumFacing.NORTH;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
            case NORTH: {
                return EnumFacing.WEST;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.EAST;
    }

    @Nonnull
    public static TextureAtlasSprite getStillTexture(@Nonnull FluidStack fluidstack) {
        Fluid fluid = fluidstack.getFluid();
        if (fluid == null) {
            return RenderUtil.getMissingSprite();
        }
        return RenderUtil.getStillTexture(fluid);
    }

    @Nonnull
    public static TextureAtlasSprite getStillTexture(@Nonnull Fluid fluid) {
        ResourceLocation iconKey = fluid.getStill();
        TextureAtlasSprite textureExtry = Minecraft.func_71410_x().func_147117_R().getTextureExtry(iconKey.toString());
        return textureExtry != null ? textureExtry : RenderUtil.getMissingSprite();
    }

    @Nonnull
    public static TextureAtlasSprite getMissingSprite() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public static void renderGuiTank(@Nonnull FluidTank tank, double x, double y, double zLevel, double width, double height) {
        RenderUtil.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public static void renderGuiTank(@Nullable FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = RenderUtil.getStillTexture(fluid);
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        RenderUtil.bindBlockTexture();
        int color = fluid.getFluid().getColor(fluid);
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GlStateManager.func_179147_l();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawBillboardedText(@Nonnull Vector3f pos, @Nonnull String text, float size) {
        RenderUtil.drawBillboardedText(pos, text, size, DEFAULT_TXT_COL, true, DEFAULT_TEXT_SHADOW_COL, true, DEFAULT_TEXT_BG_COL);
    }

    public static void drawBillboardedText(@Nonnull Vector3f pos, @Nonnull String text, float size, @Nonnull Vector4f bgCol) {
        RenderUtil.drawBillboardedText(pos, text, size, DEFAULT_TXT_COL, true, DEFAULT_TEXT_SHADOW_COL, true, bgCol);
    }

    public static void drawBillboardedText(@Nonnull Vector3f pos, @Nonnull String text, float size, @Nonnull Vector4f txtCol, boolean drawShadow, @Nullable Vector4f shadowCol, boolean drawBackground, @Nullable Vector4f bgCol) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)pos.x, (float)pos.y, (float)pos.z);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fnt = mc.field_71466_p;
        float scale = size / (float)fnt.field_78288_b;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)(mc.func_175598_ae().field_78735_i + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-mc.func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-fnt.func_78256_a(text) / 2), (float)0.0f, (float)0.0f);
        if (drawBackground && bgCol != null) {
            RenderUtil.renderBackground(fnt, text, bgCol);
        }
        fnt.func_78276_b(text, 0, 0, ColorUtil.getRGBA(txtCol));
        if (drawShadow && shadowCol != null) {
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.1f);
            fnt.func_78276_b(text, 0, 0, ColorUtil.getRGBA(shadowCol));
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        RenderUtil.bindBlockTexture();
    }

    public static void renderBackground(@Nonnull FontRenderer fnt, @Nonnull String toRender, @Nonnull Vector4f color) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        RenderHelper.func_74518_a();
        float width = fnt.func_78256_a(toRender);
        float height = fnt.field_78288_b;
        float padding = 2.0f;
        GlStateManager.func_179131_c((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tes.func_181662_b((double)(-padding), (double)(-padding), 0.0).func_181675_d();
        tes.func_181662_b((double)(-padding), (double)(height + padding), 0.0).func_181675_d();
        tes.func_181662_b((double)(width + padding), (double)(height + padding), 0.0).func_181675_d();
        tes.func_181662_b((double)(width + padding), (double)(-padding), 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
        GlStateManager.func_179140_f();
    }

    public static void render3DItem(@Nonnull EntityItem item, boolean rotate) {
        float rot = RenderUtil.getRotation(1.0f);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        if (rotate && Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        item.field_70290_d = 0.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
        GL11.glPopMatrix();
    }

    public static float getRotation(float mult) {
        return (float)ClientHandler.getTicksElapsed() * mult;
    }

    public static void renderBillboardQuad(float rot, double scale) {
        GL11.glPushMatrix();
        RenderUtil.rotateToPlayer();
        GL11.glPushMatrix();
        GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tes.func_181662_b(-scale, -scale, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_181662_b(-scale, scale, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tes.func_181662_b(scale, scale, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        tes.func_181662_b(scale, -scale, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void rotateToPlayer() {
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        GL11.glRotatef((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    @Nonnull
    public static TextureAtlasSprite getTexture(@Nonnull IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static void renderBoundingBox(final @Nonnull BoundingBox bb) {
        final BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        NNList.FACING.apply(new NNList.Callback<EnumFacing>(){

            @Override
            public void apply(@Nonnull EnumFacing e) {
                for (Vector3f v : bb.getCornersForFace(e)) {
                    tes.func_181662_b((double)v.x, (double)v.y, (double)v.z).func_181675_d();
                }
            }
        });
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderBoundingBox(@Nonnull BoundingBox bb, @Nonnull IBlockState state) {
        RenderUtil.renderBoundingBox(bb, RenderUtil.getTexture(state));
    }

    public static void renderBoundingBox(@Nonnull BoundingBox bb, @Nonnull TextureAtlasSprite tex) {
        RenderUtil.renderBoundingBox(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
    }

    public static void renderBoundingBox(final @Nonnull BoundingBox bb, final float minU, final float maxU, final float minV, final float maxV) {
        final BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        NNList.FACING.apply(new NNList.Callback<EnumFacing>(){

            @Override
            public void apply(@Nonnull EnumFacing e) {
                Iterator iterator = bb.getCornersWithUvForFace(e, minU, maxU, minV, maxV).iterator();
                while (iterator.hasNext()) {
                    Vertex v = (Vertex)iterator.next();
                    tes.func_181662_b(v.x(), v.y(), v.z()).func_187315_a((double)v.u(), (double)v.v()).func_181675_d();
                }
            }
        });
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void registerReloadListener(@Nonnull IResourceManagerReloadListener obj) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(obj);
    }

    public static void setupLightmapCoords(@Nonnull BlockPos pos, @Nonnull World world) {
        float f = world.func_175699_k(pos);
        int l = RenderUtil.getLightBrightnessForSkyBlocks(world, pos, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        GlStateManager.func_179124_c((float)f, (float)f, (float)f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
    }

    public static int getLightBrightnessForSkyBlocks(@Nonnull World world, @Nonnull BlockPos pos, int min) {
        int i1 = world.func_175642_b(EnumSkyBlock.SKY, pos);
        int j1 = world.func_175642_b(EnumSkyBlock.BLOCK, pos);
        if (j1 < min) {
            j1 = min;
        }
        return i1 << 20 | j1 << 4;
    }

    public static void renderBlockModel(final @Nonnull World world, final @Nonnull BlockPos pos, boolean translateToOrigin) {
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        final IBlockState state = world.func_180495_p(pos);
        final BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        final IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
        Tessellator tesselator = Tessellator.func_178181_a();
        final BufferBuilder wr = tesselator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (translateToOrigin) {
            wr.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        }
        NNList.RENDER_LAYER.apply(new NNList.Callback<BlockRenderLayer>(){

            @Override
            public void apply(@Nonnull BlockRenderLayer layer) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)world, ibakedmodel, state, pos, wr, false);
            }
        });
        if (translateToOrigin) {
            wr.func_178969_c(0.0, 0.0, 0.0);
        }
        tesselator.func_78381_a();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
    }

    public static void renderBlockModelAsItem(@Nonnull World world, @Nonnull ItemStack stack, @Nonnull IBlockState state) {
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = blockrendererdispatcher.func_175023_a().func_178125_b(state);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
    }

    public static void addBakedQuads(@Nonnull List<BakedQuad> quads, @Nonnull BoundingBox bb, @Nonnull TextureAtlasSprite tex) {
        RenderUtil.addBakedQuads(quads, bb, tex, null);
    }

    public static void addBakedQuads(final @Nonnull List<BakedQuad> quads, final @Nonnull BoundingBox bb, final @Nonnull TextureAtlasSprite tex, final Vector4f color) {
        NNList.FACING.apply(new NNList.Callback<EnumFacing>(){

            @Override
            public void apply(@Nonnull EnumFacing face) {
                RenderUtil.addBakedQuadForFace(quads, bb, tex, face, null, false, false, true, color);
            }
        });
    }

    public static void addBakedQuadForFace(@Nonnull List<BakedQuad> quads, @Nonnull BoundingBox bb, @Nonnull TextureAtlasSprite tex, @Nonnull EnumFacing face) {
        RenderUtil.addBakedQuadForFace(quads, bb, tex, face, false, false);
    }

    public static void addBakedQuadForFace(@Nonnull List<BakedQuad> quads, @Nonnull BoundingBox bb, @Nonnull TextureAtlasSprite tex, @Nonnull EnumFacing face, boolean rotateUV, boolean flipU) {
        RenderUtil.addBakedQuadForFace(quads, bb, tex, face, null, rotateUV, flipU, true, null);
    }

    public static void addBakedQuadForFace(@Nonnull List<BakedQuad> quads, @Nonnull BoundingBox bb, @Nonnull TextureAtlasSprite tex, @Nonnull EnumFacing face, @Nullable VertexTransform xform, boolean rotateUV, boolean flipU, boolean recolor, @Nullable Vector4f color) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        List<Vertex> corners = bb.getCornersWithUvForFace(face);
        builder.setQuadOrientation(face);
        builder.setTexture(tex);
        for (Vertex v : corners) {
            if (v == null) continue;
            if (xform != null) {
                xform.apply(v);
            }
            if (recolor) {
                v.color = color;
            }
            if (rotateUV) {
                float u = v.uv.x;
                v.uv.x = v.uv.y;
                v.uv.y = u;
            }
            if (flipU) {
                v.uv.x = 1.0f - v.uv.x;
            }
            RenderUtil.putVertexData(builder, v, face.func_176730_m(), tex);
        }
        quads.add((BakedQuad)builder.build());
    }

    public static void addBakedQuads(@Nonnull List<BakedQuad> quads, @Nonnull Collection<Vertex> vertices, @Nonnull TextureAtlasSprite tex, @Nullable Vector4f color) {
        Iterator<Vertex> it = vertices.iterator();
        while (it.hasNext()) {
            EnumFacing face = EnumFacing.DOWN;
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(Attributes.DEFAULT_BAKED_FORMAT);
            for (int i = 0; i < 4; ++i) {
                Vertex v = it.next();
                if (i == 0) {
                    face = EnumFacing.func_176737_a((float)v.nx(), (float)v.ny(), (float)v.nz());
                    builder.setQuadOrientation(face);
                    builder.setTexture(tex);
                }
                v.color = color;
                RenderUtil.putVertexData(builder, v, face.func_176730_m(), tex);
            }
            quads.add((BakedQuad)builder.build());
        }
    }

    private static void putVertexData(@Nonnull UnpackedBakedQuad.Builder builder, @Nonnull Vertex v, @Nonnull Vec3i normal, @Nonnull TextureAtlasSprite sprite) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)v.x(), (float)v.y(), (float)v.z(), 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = v.normal != null ? LightUtil.diffuseLight((float)v.normal.x, (float)v.normal.y, (float)v.normal.z) : LightUtil.diffuseLight((float)normal.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
                    if (v.color != null) {
                        builder.put(e, new float[]{d * v.color.x, d * v.color.y, d * v.color.z, v.color.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{d, d, d, 1.0f});
                    continue block6;
                }
                case UV: {
                    builder.put(e, new float[]{sprite.func_94214_a((double)(v.u() * 16.0f)), sprite.func_94207_b((double)(v.v() * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (v.normal != null) {
                        builder.put(e, new float[]{v.nx(), v.ny(), v.nz(), 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{normal.func_177958_n(), normal.func_177956_o(), normal.func_177952_p(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

