/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.GhostSlotHandler;
import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.ToolTipManager;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.gui.widget.VScrollbar;
import com.enderio.core.common.util.NNList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public abstract class GuiContainerBase
extends GuiContainer
implements ToolTipManager.ToolTipRenderer,
IGuiScreen {
    @Nonnull
    protected ToolTipManager ttMan = new ToolTipManager();
    @Nonnull
    protected NNList<IGuiOverlay> overlays = new NNList();
    @Nonnull
    protected NNList<TextFieldEnder> textFields = new NNList();
    @Nonnull
    protected NNList<VScrollbar> scrollbars = new NNList();
    @Nonnull
    protected NNList<IDrawingElement> drawingElements = new NNList();
    @Nonnull
    protected GhostSlotHandler ghostSlotHandler = new GhostSlotHandler();
    @Nullable
    protected VScrollbar draggingScrollbar;
    private int realMx;
    private int realMy;

    protected GuiContainerBase(@Nonnull Container par1Container) {
        super(par1Container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.fixupGuiPosition();
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            IGuiOverlay overlay = (IGuiOverlay)iterator.next();
            overlay.init(this);
        }
        iterator = this.textFields.iterator();
        while (iterator.hasNext()) {
            TextFieldEnder f = (TextFieldEnder)iterator.next();
            f.init(this);
        }
    }

    protected void fixupGuiPosition() {
    }

    protected void func_73869_a(char c, int key) throws IOException {
        TextFieldEnder f;
        TextFieldEnder focused = null;
        Iterator iterator = this.textFields.iterator();
        while (iterator.hasNext()) {
            f = (TextFieldEnder)iterator.next();
            if (!f.func_146206_l()) continue;
            focused = f;
        }
        if (key == 1) {
            if (focused != null) {
                focused.func_146195_b(false);
                focused = null;
                return;
            }
            if (!this.hideOverlays()) {
                this.field_146297_k.field_71439_g.func_71053_j();
                return;
            }
        }
        if (c == '\t') {
            for (int i = 0; i < this.textFields.size(); ++i) {
                f = (TextFieldEnder)this.textFields.get(i);
                if (!f.func_146206_l()) continue;
                ((TextFieldEnder)this.textFields.get((i + 1) % this.textFields.size())).func_146195_b(true);
                f.func_146195_b(false);
                return;
            }
        }
        if (focused != null) {
            String old = focused.func_146179_b();
            if (focused.func_146201_a(c, key)) {
                this.onTextFieldChanged(focused, old);
                return;
            }
        }
        if (c == 'f' && focused == null && !this.textFields.isEmpty()) {
            focused = (TextFieldEnder)this.textFields.get(0);
            focused.func_146195_b(true);
        }
        if (key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            if (!this.hideOverlays()) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
            return;
        }
        super.func_73869_a(c, key);
    }

    protected final void setText(@Nonnull TextFieldEnder tf, @Nonnull String newText) {
        String old = tf.func_146179_b();
        tf.func_146180_a(newText);
        this.onTextFieldChanged(tf, old);
    }

    protected void onTextFieldChanged(@Nonnull TextFieldEnder tf, @Nonnull String old) {
    }

    public boolean hideOverlays() {
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            IGuiOverlay overlay = (IGuiOverlay)iterator.next();
            if (!overlay.isVisible()) continue;
            overlay.setIsVisible(false);
            return true;
        }
        return false;
    }

    @Override
    public void addToolTip(@Nonnull GuiToolTip toolTip) {
        this.ttMan.addToolTip(toolTip);
    }

    public void func_73876_c() {
        super.func_73876_c();
        Iterator iterator = this.textFields.iterator();
        while (iterator.hasNext()) {
            GuiTextField f = (GuiTextField)iterator.next();
            f.func_146178_a();
        }
    }

    public void func_146274_d() throws IOException {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int b = Mouse.getEventButton();
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            IGuiOverlay overlay = (IGuiOverlay)iterator.next();
            if (overlay == null || !overlay.isVisible() || !overlay.handleMouseInput(x, y, b)) continue;
            return;
        }
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            this.mouseWheel(x, y, delta);
        }
        super.func_146274_d();
    }

    protected boolean func_146978_c(int p_146978_1_, int p_146978_2_, int p_146978_3_, int p_146978_4_, int p_146978_5_, int p_146978_6_) {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            IGuiOverlay overlay = (IGuiOverlay)iterator.next();
            if (overlay == null || !overlay.isVisible() || !overlay.isMouseInBounds(x, y)) continue;
            return false;
        }
        return super.func_146978_c(p_146978_1_, p_146978_2_, p_146978_3_, p_146978_4_, p_146978_5_, p_146978_6_);
    }

    @Override
    @Nonnull
    public GhostSlotHandler getGhostSlotHandler() {
        return this.ghostSlotHandler;
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        GhostSlot slot;
        Iterator iterator = this.textFields.iterator();
        while (iterator.hasNext()) {
            GuiTextField f = (GuiTextField)iterator.next();
            f.func_146192_a(x, y, button);
        }
        if (!this.scrollbars.isEmpty()) {
            if (this.draggingScrollbar != null) {
                this.draggingScrollbar.mouseClicked(x, y, button);
                return;
            }
            iterator = this.scrollbars.iterator();
            while (iterator.hasNext()) {
                VScrollbar vs = (VScrollbar)iterator.next();
                if (!vs.mouseClicked(x, y, button)) continue;
                this.draggingScrollbar = vs;
                return;
            }
        }
        if (!this.getGhostSlotHandler().getGhostSlots().isEmpty() && (slot = this.getGhostSlotHandler().getGhostSlotAt(this, x, y)) != null) {
            this.getGhostSlotHandler().ghostSlotClicked(this, slot, x, y, button);
            return;
        }
        if (button == 1) {
            iterator = this.textFields.iterator();
            while (iterator.hasNext()) {
                TextFieldEnder tf = (TextFieldEnder)iterator.next();
                if (!tf.contains(x, y)) continue;
                this.setText(tf, "");
            }
        }
        if (button >= 1) {
            for (Object obj : this.field_146292_n) {
                IconButton btn;
                if (!(obj instanceof IconButton) || !(btn = (IconButton)obj).mousePressedButton(this.field_146297_k, x, y, button)) continue;
                btn.func_146113_a(this.field_146297_k.func_147118_V());
                this.actionPerformedButton(btn, button);
            }
        }
        super.func_73864_a(x, y, button);
    }

    protected void func_146286_b(int x, int y, int button) {
        if (this.draggingScrollbar != null) {
            this.draggingScrollbar.mouseMovedOrUp(x, y, button);
            this.draggingScrollbar = null;
        }
        super.func_146286_b(x, y, button);
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        if (this.draggingScrollbar != null) {
            this.draggingScrollbar.mouseClickMove(x, y, button, time);
            return;
        }
        super.func_146273_a(x, y, button, time);
    }

    protected void mouseWheel(int x, int y, int delta) {
        GhostSlot slot;
        if (!this.scrollbars.isEmpty()) {
            Iterator iterator = this.scrollbars.iterator();
            while (iterator.hasNext()) {
                VScrollbar vs = (VScrollbar)iterator.next();
                vs.mouseWheel(x, y, delta);
            }
        }
        if (!this.getGhostSlotHandler().getGhostSlots().isEmpty() && (slot = this.getGhostSlotHandler().getGhostSlotAt(this, x, y)) != null) {
            this.getGhostSlotHandler().ghostSlotClicked(this, slot, x, y, delta < 0 ? -1 : -2);
        }
    }

    protected void actionPerformedButton(@Nonnull IconButton btn, int mouseButton) throws IOException {
        this.func_146284_a(btn);
    }

    public void addOverlay(@Nonnull IGuiOverlay overlay) {
        this.overlays.add(overlay);
    }

    public void removeOverlay(@Nonnull IGuiOverlay overlay) {
        this.overlays.remove(overlay);
    }

    public void addScrollbar(@Nonnull VScrollbar vs) {
        this.scrollbars.add(vs);
        vs.adjustPosition();
    }

    public void removeScrollbar(@Nonnull VScrollbar vs) {
        this.scrollbars.remove(vs);
        if (this.draggingScrollbar == vs) {
            this.draggingScrollbar = null;
        }
    }

    public void addDrawingElement(@Nonnull IDrawingElement element) {
        this.drawingElements.add(element);
        GuiToolTip tooltip = element.getTooltip();
        if (tooltip != null) {
            this.addToolTip(tooltip);
        }
    }

    public void removeDrawingElement(@Nonnull IDrawingElement element) {
        this.drawingElements.remove(element);
        GuiToolTip tooltip = element.getTooltip();
        if (tooltip != null) {
            this.removeToolTip(tooltip);
        }
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        this.drawForegroundImpl(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        this.field_73735_i = 300.0f;
        this.field_146296_j.field_77023_b = 300.0f;
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            IGuiOverlay overlay = (IGuiOverlay)iterator.next();
            if (overlay == null || !overlay.isVisible()) continue;
            overlay.draw(this.realMx, this.realMy, this.field_146297_k.func_184121_ak());
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float par1, int mouseX, int mouseY) {
        Iterator iterator = this.drawingElements.iterator();
        while (iterator.hasNext()) {
            IDrawingElement drawingElement = (IDrawingElement)iterator.next();
            drawingElement.drawGuiContainerBackgroundLayer(par1, mouseX, mouseY);
        }
        iterator = this.textFields.iterator();
        while (iterator.hasNext()) {
            GuiTextField f = (GuiTextField)iterator.next();
            f.func_146194_f();
        }
        if (!this.scrollbars.isEmpty()) {
            iterator = this.scrollbars.iterator();
            while (iterator.hasNext()) {
                VScrollbar vs = (VScrollbar)iterator.next();
                vs.drawScrollbar(mouseX, mouseY);
            }
        }
        if (!this.ghostSlotHandler.getGhostSlots().isEmpty()) {
            this.getGhostSlotHandler().drawGhostSlots(this, mouseX, mouseY);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int mx = this.realMx = par1;
        int my = this.realMy = par2;
        this.func_146276_q_();
        super.func_73863_a(mx, my, par3);
        this.func_191948_b(mx, my);
        if (this.draggingScrollbar == null) {
            this.ghostSlotHandler.drawGhostSlotToolTip(this, par1, par2);
            this.ttMan.drawTooltips(this, par1, par2);
        }
    }

    protected void func_146982_a(@Nonnull ItemStack stack, int mouseX, int mouseY, String str) {
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_175042_a(stack, mouseX, mouseY);
        this.field_146296_j.func_180453_a(font, stack, mouseX, mouseY, str);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void drawFakeItemsStart() {
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
    }

    public void drawFakeItemStack(int x, int y, @Nonnull ItemStack stack) {
        this.field_146296_j.func_180450_b(stack, x, y);
        GlStateManager.func_179141_d();
    }

    public void drawFakeItemStackStdOverlay(int x, int y, @Nonnull ItemStack stack) {
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, null);
    }

    protected void drawFakeItemHover(int x, int y) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
    }

    protected void drawFakeItemsEnd() {
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    public void func_146285_a(@Nonnull ItemStack p_146285_1_, int p_146285_2_, int p_146285_3_) {
        super.func_146285_a(p_146285_1_, p_146285_2_, p_146285_3_);
    }

    @Nonnull
    protected abstract ResourceLocation getGuiTexture();

    @Override
    public boolean removeToolTip(@Nonnull GuiToolTip toolTip) {
        return this.ttMan.removeToolTip(toolTip);
    }

    protected void drawForegroundImpl(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    public void drawHoveringToolTipText(@Nonnull List<String> par1List, int par2, int par3, @Nonnull FontRenderer font) {
        super.drawHoveringText(par1List, par2, par3, font);
    }

    public float getZlevel() {
        return this.field_73735_i;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public void setGuiLeft(int i) {
        this.field_147003_i = i;
    }

    public void setGuiTop(int i) {
        this.field_147009_r = i;
    }

    public void setXSize(int i) {
        this.field_146999_f = i;
    }

    public void setYSize(int i) {
        this.field_147000_g = i;
    }

    @Override
    @Nonnull
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Nonnull
    public <T extends GuiButton> T func_189646_b(@Nonnull T button) {
        if (!this.field_146292_n.contains(button)) {
            this.field_146292_n.add(button);
        }
        return button;
    }

    @Override
    public void removeButton(@Nonnull GuiButton button) {
        this.field_146292_n.remove(button);
    }

    @Override
    public int getOverlayOffsetXLeft() {
        return 0;
    }

    @Override
    public int getOverlayOffsetXRight() {
        return 0;
    }

    @Override
    public void doActionPerformed(@Nonnull GuiButton guiButton) throws IOException {
        this.func_146284_a(guiButton);
    }

    @Override
    public void clearToolTips() {
    }

    public void func_146281_b() {
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            IGuiOverlay overlay = (IGuiOverlay)iterator.next();
            overlay.guiClosed();
        }
    }

    @Override
    public final int getGuiRootLeft() {
        return this.getGuiLeft();
    }

    @Override
    public final int getGuiRootTop() {
        return this.getGuiTop();
    }

    @Override
    public final int getGuiXSize() {
        return this.getXSize();
    }

    @Override
    public final int getGuiYSize() {
        return this.getYSize();
    }

    @Override
    @Nonnull
    public final <T extends GuiButton> T addGuiButton(@Nonnull T button) {
        return this.func_189646_b(button);
    }
}

