/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.forgemodel;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareMultiModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;

public class CCMultiModel
implements IModel {
    private final IModel base;
    private final ModelProperties baseProperties;
    private final List<IModel> subModels;

    public CCMultiModel(IModel base, ModelProperties baseProperties, List<IModel> subModels) {
        this.base = base;
        this.baseProperties = baseProperties;
        this.subModels = subModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> deps = new ArrayList<ResourceLocation>();
        if (this.base != null) {
            deps.addAll(this.base.getDependencies());
        }
        for (IModel subModel : this.subModels) {
            deps.addAll(subModel.getDependencies());
        }
        return deps;
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> deps = new ArrayList<ResourceLocation>();
        if (this.base != null) {
            deps.addAll(this.base.getTextures());
        }
        for (IModel subModel : this.subModels) {
            deps.addAll(subModel.getTextures());
        }
        return deps;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseBakedModel = null;
        if (this.base != null) {
            baseBakedModel = this.base.bake(state, format, bakedTextureGetter);
        }
        ArrayList<IBakedModel> subBakedModels = new ArrayList<IBakedModel>();
        for (IModel subModel : this.subModels) {
            IBakedModel bakedSubModel = subModel.bake(subModel.getDefaultState(), format, bakedTextureGetter);
            subBakedModels.add(bakedSubModel);
        }
        return new PerspectiveAwareMultiModel(baseBakedModel, subBakedModels, new ModelProperties.PerspectiveProperties(state, this.baseProperties));
    }

    public IModelState getDefaultState() {
        return this.base.getDefaultState();
    }
}

