/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.RedstoneFurnace")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class RedstoneFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int energy) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), InputHelper.toStack((IItemStack)input), energy));
    }

    @ZenMethod
    public static void addPyrolysisRecipe(IItemStack output, IItemStack input, int energy, int creosote) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddPyrolysis(InputHelper.toStack((IItemStack)output), InputHelper.toStack((IItemStack)input), energy, creosote));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)input)));
    }

    @ZenMethod
    public static void removePyrolysisRecipe(IItemStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemovePyrolysis(InputHelper.toStack((IItemStack)input)));
    }

    private static class RemovePyrolysis
    extends BaseAction {
        private ItemStack input;

        public RemovePyrolysis(ItemStack input) {
            super("RedstoneFurnace");
            this.input = input;
        }

        public void apply() {
            if (!FurnaceManager.recipeExistsPyrolysis((ItemStack)this.input)) {
                CraftTweakerAPI.logError((String)("No Furnace Pyrolysis recipe exists for: " + this.input));
                return;
            }
            FurnaceManager.removeRecipePyrolysis((ItemStack)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }

    private static class Remove
    extends BaseAction {
        private ItemStack input;

        public Remove(ItemStack input) {
            super("RedstoneFurnace");
            this.input = input;
        }

        public void apply() {
            if (!FurnaceManager.recipeExists((ItemStack)this.input)) {
                CraftTweakerAPI.logError((String)("No Furnace recipe exists for: " + this.input));
                return;
            }
            FurnaceManager.removeRecipe((ItemStack)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }

    private static class AddPyrolysis
    extends BaseAction {
        private ItemStack output;
        private ItemStack input;
        private int energy;
        private int creosote;

        public AddPyrolysis(ItemStack output, ItemStack input, int energy, int creosote) {
            super("RedstoneFurnace");
            this.output = output;
            this.input = input;
            this.energy = energy;
            this.creosote = creosote;
        }

        public void apply() {
            FurnaceManager.addRecipePyrolysis((int)this.energy, (ItemStack)this.input, (ItemStack)this.output, (int)this.creosote);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack output;
        private ItemStack input;
        private int energy;

        public Add(ItemStack output, ItemStack input, int energy) {
            super("RedstoneFurnace");
            this.output = output;
            this.input = input;
            this.energy = energy;
        }

        public void apply() {
            FurnaceManager.addRecipe((int)this.energy, (ItemStack)this.input, (ItemStack)this.output);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }
}

