/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.refinedstorage;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRecipe;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.refinedstorage.Solderer")
@ModOnly(value="refinedstorage")
@ZenRegister
public class Solderer {
    @ZenMethod
    public static void addRecipe(String name, final IItemStack output, final int time, IItemStack[] rows) {
        if (rows.length != 3) {
            CraftTweakerAPI.logError((String)"Invalid array length! There have to have 3 items in the array! Use null where applicable!", (Throwable)new ArrayIndexOutOfBoundsException());
            return;
        }
        final NonNullList list = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])InputHelper.toStacks((IItemStack[])rows));
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(Collections.singletonList(new ISoldererRecipe(){

            public ResourceLocation getName() {
                return new ResourceLocation("modtweaker", "name");
            }

            @Nonnull
            public NonNullList<ItemStack> getRow(int row) {
                return NonNullList.func_191197_a((int)1, (Object)list.get(row));
            }

            @Nonnull
            public ItemStack getResult() {
                return InputHelper.toStack((IItemStack)output);
            }

            public int getDuration() {
                return time;
            }

            public boolean isProjectERecipe() {
                return false;
            }
        })));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    private static class Remove
    extends BaseListRemoval<ISoldererRecipe> {
        private IItemStack output;

        protected Remove(IItemStack output) {
            super("Solderer", API.instance().getSoldererRegistry().getRecipes(), Collections.emptyList());
            this.output = output;
        }

        public void apply() {
            for (ISoldererRecipe recipe : API.instance().getSoldererRegistry().getRecipes()) {
                if (!this.output.matches(InputHelper.toIItemStack((ItemStack)recipe.getResult()))) continue;
                this.recipes.add(recipe);
            }
            super.apply();
        }

        protected String getRecipeInfo(ISoldererRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getResult());
        }
    }

    private static class Add
    extends BaseListAddition<ISoldererRecipe> {
        protected Add(List<ISoldererRecipe> recipes) {
            super("Solderer", API.instance().getSoldererRegistry().getRecipes(), recipes);
        }

        protected String getRecipeInfo(ISoldererRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getResult());
        }
    }
}

