/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.inspirations;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.event.RegisterEvent;
import knightminer.inspirations.library.recipe.cauldron.CauldronBrewingRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronDyeRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronFluidRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronFluidTransformRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronPotionRecipe;
import knightminer.inspirations.library.recipe.cauldron.FillCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ISimpleCauldronRecipe;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import slimeknights.mantle.util.RecipeMatch;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.inspirations.Cauldron")
@ZenRegister
@ModOnly(value="inspirations")
public class Cauldron {
    private static final Set<ICauldronRecipe> ADDED_RECIPES = new HashSet<ICauldronRecipe>();
    public static final List<Triple<Object, Object, IIngredient>> REMOVED_BREWING = new LinkedList<Triple<Object, Object, IIngredient>>();
    public static final List<Triple<IIngredient, IIngredient, Object>> REMOVED_POTION = new LinkedList<Triple<IIngredient, IIngredient, Object>>();
    public static final List<Triple<IIngredient, IIngredient, EnumDyeColor>> REMOVED_DYE = new LinkedList<Triple<IIngredient, IIngredient, EnumDyeColor>>();
    public static final List<Triple<IIngredient, IIngredient, Fluid>> REMOVED_FLUID = new LinkedList<Triple<IIngredient, IIngredient, Fluid>>();
    public static final List<Triple<Fluid, IIngredient, Fluid>> REMOVED_FLUID_TRANSFORM = new LinkedList<Triple<Fluid, IIngredient, Fluid>>();
    public static final List<Pair<IIngredient, Fluid>> REMOVED_FILL = new LinkedList<Pair<IIngredient, Fluid>>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register(Cauldron.class);
            init = true;
        }
    }

    @ZenMethod
    public static void addBrewingRecipe(String output, String input, IIngredient reagent) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddBrewing(output, input, reagent));
    }

    @ZenMethod
    public static void removeBrewingRecipe(String output, @Optional String input, @Optional IIngredient reagent) {
        Cauldron.init();
        CraftTweakerAPI.apply((IAction)new RemoveBrewing(output, input, reagent));
    }

    @ZenMethod
    public static void addPotionRecipe(IItemStack output, IIngredient input, String potion) {
        Cauldron.addPotionRecipe(output, input, potion, 1, null);
    }

    @ZenMethod
    public static void addPotionRecipe(IItemStack output, IIngredient input, String potion, int levels, @Optional Boolean boiling) {
        if (levels < 0 || levels > 3) {
            CraftTweakerAPI.logError((String)("Ignoring Cauldron Fluid recipe for " + output.getDisplayName() + ": Invalid levels of " + levels + " given, must be between 0 and 3."));
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddPotion(InputHelper.toStack((IItemStack)output), input, potion, levels, boiling));
    }

    @ZenMethod
    public static void removePotionRecipe(IIngredient output, @Optional IIngredient input, @Optional String potion) {
        Cauldron.init();
        CraftTweakerAPI.apply((IAction)new RemovePotion(output, input, potion));
    }

    @ZenMethod
    public static void addDyeRecipe(IItemStack output, IIngredient input, String stringDye) {
        EnumDyeColor dye = EnumDyeColor.valueOf((String)stringDye.toUpperCase());
        if (dye == null) {
            CraftTweakerAPI.logError((String)("Ignoring Cauldron Dyeing recipe for " + output.getDisplayName() + ": Could not find matching dye color for " + stringDye));
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddDye(InputHelper.toStack((IItemStack)output), input, dye));
    }

    @ZenMethod
    public static void removeDyeRecipe(IIngredient output, @Optional IIngredient input, @Optional String stringDye) {
        Cauldron.init();
        EnumDyeColor dye = null;
        if (stringDye != null && (dye = EnumDyeColor.valueOf((String)stringDye.toUpperCase())) == null) {
            CraftTweakerAPI.logError((String)("Ignoring Cauldron Dyeing recipe removalS: Could not find matching dye color for " + stringDye));
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveDye(output, input, dye));
    }

    @ZenMethod
    public static void addFluidRecipe(IItemStack output, IIngredient input, ILiquidStack fluid) {
        Cauldron.addFluidRecipe(output, input, fluid, 1, null);
    }

    @ZenMethod
    public static void addFluidRecipe(IItemStack output, IIngredient input, ILiquidStack fluid, int levels, @Optional Boolean boiling) {
        if (levels < 0 || levels > 3) {
            CraftTweakerAPI.logError((String)("Ignoring Cauldron Fluid recipe for " + output.getDisplayName() + ": Invalid levels of " + levels + " given, must be between 0 and 3."));
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddFluid(InputHelper.toStack((IItemStack)output), input, InputHelper.toFluid((ILiquidStack)fluid), levels, boiling));
    }

    @ZenMethod
    public static void addFluidTransform(ILiquidStack output, IIngredient input, ILiquidStack fluid) {
        Cauldron.addFluidTransform(output, input, fluid, 3, null);
    }

    @ZenMethod
    public static void addFluidTransform(ILiquidStack output, IIngredient input, ILiquidStack fluid, int maxLevel, @Optional Boolean boiling) {
        if (maxLevel < 1 || maxLevel > 3) {
            CraftTweakerAPI.logError((String)("Ignoring Cauldron Fluid recipe for " + output.getDisplayName() + ": Invalid max level of " + maxLevel + " given, must be between 1 and 3."));
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddFluidTransform(InputHelper.toFluid((ILiquidStack)output), input, InputHelper.toFluid((ILiquidStack)fluid), maxLevel, boiling));
    }

    @ZenMethod
    public static void removeFluidRecipe(IIngredient output, @Optional IIngredient input, @Optional ILiquidStack fluid) {
        Cauldron.init();
        CraftTweakerAPI.apply((IAction)new RemoveFluid(output, input, fluid));
    }

    @ZenMethod
    public static void removeFluidTransform(IIngredient output, @Optional IIngredient input, @Optional ILiquidStack fluid) {
        Cauldron.init();
        CraftTweakerAPI.apply((IAction)new RemoveFluidTransform(output, input, fluid));
    }

    @ZenMethod
    public static void addFillRecipe(IIngredient input, ILiquidStack fluid) {
        Cauldron.addFillRecipe(input, fluid, 1, null);
    }

    @ZenMethod
    public static void addFillRecipe(IIngredient input, ILiquidStack fluid, int amount, @Optional IItemStack container) {
        if (amount < 1 || amount > 3) {
            CraftTweakerAPI.logError((String)("Ignoring Cauldron Fluid recipe for " + fluid.getDisplayName() + ": Invalid amount " + amount + " given, must be between 1 and 3."));
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddFill(input, InputHelper.toFluid((ILiquidStack)fluid), amount, InputHelper.toStack((IItemStack)container)));
    }

    @ZenMethod
    public static void removeFillRecipe(IIngredient input, @Optional ILiquidStack fluid) {
        Cauldron.init();
        CraftTweakerAPI.apply((IAction)new RemoveFill(input, fluid));
    }

    @SubscribeEvent
    public static void onCauldronRegister(RegisterEvent.RegisterCauldronRecipe event) {
        block8: {
            ICauldronRecipe irecipe;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                irecipe = (ICauldronRecipe)event.getRecipe();
                                if (ADDED_RECIPES.contains(irecipe)) {
                                    return;
                                }
                                if (!(irecipe instanceof CauldronBrewingRecipe)) break block7;
                                for (Triple<Object, Object, IIngredient> remove : REMOVED_BREWING) {
                                    if (!Cauldron.checkRecipeMatches((ISimpleCauldronRecipe)irecipe, (IIngredient)remove.getRight(), null, remove.getMiddle(), remove.getLeft())) continue;
                                    event.setCanceled(true);
                                    return;
                                }
                                break block8;
                            }
                            if (!(irecipe instanceof CauldronDyeRecipe)) break block9;
                            for (Triple<IIngredient, IIngredient, EnumDyeColor> remove : REMOVED_DYE) {
                                if (!Cauldron.checkRecipeMatches((ISimpleCauldronRecipe)irecipe, (IIngredient)remove.getMiddle(), (IIngredient)remove.getLeft(), remove.getRight(), null)) continue;
                                event.setCanceled(true);
                                return;
                            }
                            break block8;
                        }
                        if (!(irecipe instanceof CauldronFluidTransformRecipe)) break block10;
                        for (Triple<Fluid, IIngredient, Fluid> remove : REMOVED_FLUID_TRANSFORM) {
                            if (!Cauldron.checkRecipeMatches((ISimpleCauldronRecipe)irecipe, (IIngredient)remove.getMiddle(), null, remove.getRight(), remove.getLeft())) continue;
                            event.setCanceled(true);
                            return;
                        }
                        break block8;
                    }
                    if (!(irecipe instanceof FillCauldronRecipe)) break block11;
                    for (Pair<IIngredient, Fluid> remove : REMOVED_FILL) {
                        if (!Cauldron.checkRecipeMatches((ISimpleCauldronRecipe)irecipe, (IIngredient)remove.getLeft(), null, null, remove.getRight())) continue;
                        event.setCanceled(true);
                        return;
                    }
                    break block8;
                }
                if (!(irecipe instanceof CauldronFluidRecipe)) break block12;
                for (Triple<IIngredient, IIngredient, Fluid> remove : REMOVED_FLUID) {
                    if (!Cauldron.checkRecipeMatches((ISimpleCauldronRecipe)irecipe, (IIngredient)remove.getMiddle(), (IIngredient)remove.getLeft(), remove.getRight(), null)) continue;
                    event.setCanceled(true);
                    return;
                }
                break block8;
            }
            if (!(irecipe instanceof CauldronPotionRecipe)) break block8;
            for (Triple<IIngredient, IIngredient, Object> remove : REMOVED_POTION) {
                if (!Cauldron.checkRecipeMatches((ISimpleCauldronRecipe)irecipe, (IIngredient)remove.getMiddle(), (IIngredient)remove.getLeft(), remove.getRight(), null)) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    private static void addRecipe(ICauldronRecipe recipe) {
        ADDED_RECIPES.add(recipe);
        InspirationsRegistry.addCauldronRecipe((ICauldronRecipe)recipe);
    }

    private static RecipeMatch fromIIngredient(IIngredient ingredient) {
        List ingredients = ingredient.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        if (ingredients.isEmpty()) {
            return null;
        }
        int amount = ingredient.getAmount();
        return RecipeMatch.of(ingredients, (int)amount, (int)amount);
    }

    private static boolean checkRecipeMatches(ISimpleCauldronRecipe recipe, IIngredient input, IIngredient output, Object inputState, Object outputState) {
        if (!(outputState != null && !Cauldron.compareFluids(outputState, recipe.getState()) || inputState != null && !Cauldron.compareFluids(inputState, recipe.getInputState()) || output != null && !output.matches(CraftTweakerMC.getIItemStack((ItemStack)recipe.getResult())))) {
            if (input == null) {
                return true;
            }
            for (ItemStack stack : recipe.getInput()) {
                if (!input.matches(CraftTweakerMC.getIItemStack((ItemStack)stack))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean compareFluids(Object first, Object second) {
        if (first == second) {
            return true;
        }
        if (first instanceof Fluid && second instanceof Fluid) {
            return ((Fluid)first).getName().equals(((Fluid)second).getName());
        }
        return false;
    }

    private static class RemoveFill
    extends BaseAction {
        private IIngredient input;
        private ILiquidStack fluid;

        public RemoveFill(IIngredient input, ILiquidStack fluid) {
            super("Cauldron Fill");
            this.fluid = fluid;
            this.input = input;
        }

        public void apply() {
            REMOVED_FILL.add((Pair<IIngredient, Fluid>)Pair.of((Object)this.input, (Object)InputHelper.getFluid((ILiquidStack)this.fluid)));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.input);
        }
    }

    private static class AddFill
    extends BaseAction {
        private IIngredient input;
        private FluidStack fluid;
        private int amount;
        private ItemStack container;

        public AddFill(IIngredient input, FluidStack fluid, int amount, ItemStack container) {
            super("Cauldron Fill");
            this.fluid = fluid;
            this.input = input;
            this.amount = amount;
            this.container = container;
        }

        public void apply() {
            RecipeMatch input = Cauldron.fromIIngredient(this.input);
            if (input == null) {
                CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.input.toString() + ". Ignoring Cauldron Fill recipe for " + this.fluid.getLocalizedName()));
                return;
            }
            Cauldron.addRecipe((ICauldronRecipe)new FillCauldronRecipe(input, this.fluid.getFluid(), this.amount, this.container));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.input);
        }
    }

    private static class RemoveFluidTransform
    extends BaseAction {
        private IIngredient output;
        private IIngredient input;
        private ILiquidStack fluid;

        public RemoveFluidTransform(IIngredient output, IIngredient input, ILiquidStack fluid) {
            super("Cauldron Fluid");
            this.output = output;
            this.input = input;
            this.fluid = fluid;
        }

        public void apply() {
            Fluid output;
            if (this.output instanceof IngredientAny) {
                output = null;
            } else if (this.output instanceof ILiquidStack) {
                output = InputHelper.getFluid((ILiquidStack)((ILiquidStack)this.output));
            } else {
                CraftTweakerAPI.logError((String)"Ignoring Cauldron Fluid recipe removal: Output must be fluid or wildcard");
                return;
            }
            REMOVED_FLUID_TRANSFORM.add((Triple<Fluid, IIngredient, Fluid>)Triple.of((Object)output, (Object)this.input, (Object)InputHelper.getFluid((ILiquidStack)this.fluid)));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class RemoveFluid
    extends BaseAction {
        private IIngredient output;
        private IIngredient input;
        private ILiquidStack fluid;

        public RemoveFluid(IIngredient output, IIngredient input, ILiquidStack fluid) {
            super("Cauldron Fluid");
            this.output = output;
            this.input = input;
            this.fluid = fluid;
        }

        public void apply() {
            REMOVED_FLUID.add((Triple<IIngredient, IIngredient, Fluid>)Triple.of((Object)this.output, (Object)this.input, (Object)InputHelper.getFluid((ILiquidStack)this.fluid)));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class AddFluidTransform
    extends BaseAction {
        private FluidStack output;
        private IIngredient input;
        private FluidStack fluid;
        private Boolean boiling;
        private int maxLevels;

        public AddFluidTransform(FluidStack output, IIngredient input, FluidStack fluid, int maxLevels, Boolean boiling) {
            super("Cauldron Fluid");
            this.output = output;
            this.input = input;
            this.fluid = fluid;
            this.maxLevels = maxLevels;
            this.boiling = boiling;
        }

        public void apply() {
            RecipeMatch input = Cauldron.fromIIngredient(this.input);
            if (input == null) {
                CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.input.toString() + ". Ignoring Cauldron Fluid recipe for " + this.output.getLocalizedName()));
                return;
            }
            Cauldron.addRecipe((ICauldronRecipe)new CauldronFluidTransformRecipe(input, this.fluid.getFluid(), this.output.getFluid(), this.boiling, this.maxLevels));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }

    private static class AddFluid
    extends BaseAction {
        private ItemStack output;
        private IIngredient input;
        private FluidStack fluid;
        private Boolean boiling;
        private int levels;

        public AddFluid(ItemStack output, IIngredient input, FluidStack fluid, int levels, Boolean boiling) {
            super("Cauldron Fluid");
            this.output = output;
            this.input = input;
            this.fluid = fluid;
            this.boiling = boiling;
            this.levels = levels;
        }

        public void apply() {
            RecipeMatch input = Cauldron.fromIIngredient(this.input);
            if (input == null) {
                CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.input.toString() + ". Ignoring Cauldron Fluid recipe for " + this.output.func_82833_r()));
                return;
            }
            Cauldron.addRecipe((ICauldronRecipe)new CauldronFluidRecipe(input, this.fluid.getFluid(), this.output, this.boiling, this.levels));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }

    private static class RemoveDye
    extends BaseAction {
        private IIngredient output;
        private IIngredient input;
        private EnumDyeColor dye;

        public RemoveDye(IIngredient output, IIngredient input, EnumDyeColor dye) {
            super("Cauldron Dyeing");
            this.output = output;
            this.input = input;
            this.dye = dye;
        }

        public void apply() {
            REMOVED_DYE.add((Triple<IIngredient, IIngredient, EnumDyeColor>)Triple.of((Object)this.output, (Object)this.input, (Object)this.dye));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class AddDye
    extends BaseAction {
        private ItemStack output;
        private IIngredient input;
        private EnumDyeColor dye;

        public AddDye(ItemStack output, IIngredient input, EnumDyeColor dye) {
            super("Cauldron Dyeing");
            this.output = output;
            this.input = input;
            this.dye = dye;
        }

        public void apply() {
            RecipeMatch input = Cauldron.fromIIngredient(this.input);
            if (input == null) {
                CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.input.toString() + ". Ignoring Cauldron Dyeing recipe for " + this.output.func_82833_r()));
                return;
            }
            Cauldron.addRecipe((ICauldronRecipe)new CauldronDyeRecipe(input, this.dye, this.output));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }

    private static class RemovePotion
    extends BaseAction {
        private IIngredient output;
        private IIngredient input;
        private String potion;

        public RemovePotion(IIngredient output, IIngredient input, String potion) {
            super("Cauldron Potion");
            this.output = output;
            this.input = input;
            this.potion = potion;
        }

        public void apply() {
            PotionType potion = null;
            if (this.potion != null) {
                potion = PotionType.func_185168_a((String)this.potion);
                if (potion == null || potion == PotionTypes.field_185229_a) {
                    CraftTweakerAPI.logError((String)("Could not find potion type for " + this.potion + ". Ignoring Cauldron Brewing recipe removal."));
                    return;
                }
                if (potion == PotionTypes.field_185230_b) {
                    potion = FluidRegistry.WATER;
                }
            }
            REMOVED_POTION.add((Triple<IIngredient, IIngredient, Object>)Triple.of((Object)this.output, (Object)this.input, (Object)potion));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class AddPotion
    extends BaseAction {
        private ItemStack output;
        private IIngredient input;
        private String potion;
        private int levels;
        private Boolean boiling;

        public AddPotion(ItemStack output, IIngredient input, String potion, int levels, Boolean boiling) {
            super("Cauldron Potion");
            this.output = output;
            this.input = input;
            this.potion = potion;
            this.levels = levels;
            this.boiling = boiling;
        }

        public void apply() {
            RecipeMatch input = Cauldron.fromIIngredient(this.input);
            if (input == null) {
                CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.input.toString() + ". Ignoring Cauldron Dyeing recipe for " + this.output.func_82833_r()));
                return;
            }
            PotionType potion = PotionType.func_185168_a((String)this.potion);
            if (potion == null || potion == PotionTypes.field_185229_a) {
                CraftTweakerAPI.logError((String)("Could not find potion type for " + this.potion + ". Ignoring Cauldron Brewing recipe for " + this.output));
                return;
            }
            Cauldron.addRecipe((ICauldronRecipe)new CauldronPotionRecipe(input, potion, this.output, this.levels, this.boiling));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }

    private static class RemoveBrewing
    extends BaseAction {
        private String output;
        private String input;
        private IIngredient reagent;

        public RemoveBrewing(String output, String input, IIngredient reagent) {
            super("Cauldron Brewing");
            this.output = output;
            this.input = input;
            this.reagent = reagent;
        }

        public void apply() {
            PotionType input = null;
            if (this.input != null) {
                input = PotionType.func_185168_a((String)this.input);
                if (input == null || input == PotionTypes.field_185229_a) {
                    CraftTweakerAPI.logError((String)("Could not find potion type for " + this.input + ". Ignoring Cauldron Brewing recipe removal " + this.output));
                    return;
                }
                if (input == PotionTypes.field_185230_b) {
                    input = FluidRegistry.WATER;
                }
            }
            PotionType output = null;
            if (this.output != null) {
                output = PotionType.func_185168_a((String)this.output);
                if (output == null || output == PotionTypes.field_185229_a) {
                    CraftTweakerAPI.logError((String)("Could not find potion type for " + this.output + ". Ignoring Cauldron Brewing recipe removal."));
                    return;
                }
                if (output == PotionTypes.field_185230_b) {
                    output = FluidRegistry.WATER;
                }
            }
            REMOVED_BREWING.add((Triple<Object, Object, IIngredient>)Triple.of((Object)output, (Object)input, (Object)this.reagent));
        }

        protected String getRecipeInfo() {
            return '\"' + this.output + '\"';
        }
    }

    private static class AddBrewing
    extends BaseAction {
        private String output;
        private String input;
        private IIngredient reagent;

        public AddBrewing(String output, String input, IIngredient reagent) {
            super("Cauldron Brewing");
            this.output = output;
            this.input = input;
            this.reagent = reagent;
        }

        public void apply() {
            PotionType input = PotionType.func_185168_a((String)this.input);
            if (input == null || input == PotionTypes.field_185229_a) {
                CraftTweakerAPI.logError((String)("Could not find potion type for " + this.input + ". Ignoring Cauldron Brewing recipe for " + this.output));
                return;
            }
            PotionType output = PotionType.func_185168_a((String)this.output);
            if (output == null || output == PotionTypes.field_185229_a) {
                CraftTweakerAPI.logError((String)("Could not find potion type for " + this.output + ". Ignoring Cauldron Brewing recipe."));
                return;
            }
            Ingredient reagent = Ingredient.func_193369_a((ItemStack[])CraftTweakerMC.getItemStacks((List)this.reagent.getItems()));
            Cauldron.addRecipe((ICauldronRecipe)new CauldronBrewingRecipe(input, reagent, output));
        }

        protected String getRecipeInfo() {
            return '\"' + this.output + '\"';
        }
    }
}

