/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.betterwithmods.util;

import betterwithmods.common.registry.bulk.manager.CraftingManagerBulk;
import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import net.minecraft.item.ItemStack;

public class BulkRemove<T extends BulkRecipe>
extends BaseAction {
    private CraftingManagerBulk<T> manager;
    private final ItemStack output;
    private final ItemStack secondary;
    private final Object[] inputs;

    public BulkRemove(String name, CraftingManagerBulk<T> manager, ItemStack output, ItemStack secondary, Object ... inputs) {
        super(name);
        this.manager = manager;
        this.output = output;
        this.secondary = secondary;
        this.inputs = inputs;
    }

    public void apply() {
        for (BulkRecipe recipe : this.manager.findRecipeForRemoval(this.output, this.secondary, this.inputs)) {
            if (recipe != null) {
                if (this.manager.getRecipes().remove(recipe)) continue;
                LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                continue;
            }
            LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    private String getRecipeInfo(T recipe) {
        return recipe.getOutput().func_82833_r();
    }
}

