/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.betterwithmods;

import betterwithmods.common.registry.blockmeta.managers.TurntableManager;
import betterwithmods.common.registry.blockmeta.recipe.TurntableRecipe;
import com.blamejared.ModTweaker;
import com.blamejared.compat.betterwithmods.util.BMAdd;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.google.common.collect.Lists;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.betterwithmods.Turntable")
@ModOnly(value="betterwithmods")
@ZenRegister
public class Turntable {
    @ZenMethod
    public static void add(IItemStack inputBlock, IItemStack outputBlock, IItemStack[] additionalOutput) {
        if (!InputHelper.isABlock((IItemStack)inputBlock)) {
            LogHelper.logError((String)"Input must be a block", (Throwable)new IllegalArgumentException());
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)inputBlock), InputHelper.toStack((IItemStack)outputBlock), Lists.newArrayList((Object[])InputHelper.toStacks((IItemStack[])additionalOutput))));
    }

    @ZenMethod
    public static void remove(IItemStack inputBlock) {
        if (!InputHelper.isABlock((IItemStack)inputBlock)) {
            LogHelper.logError((String)"Input must be a block", (Throwable)new IllegalArgumentException());
        }
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)inputBlock)));
    }

    public static class Remove
    extends BaseListRemoval<TurntableRecipe> {
        private ItemStack input;

        protected Remove(ItemStack input) {
            super("Remove Turntable Recipe", Collections.emptyList());
            this.input = input;
        }

        public void apply() {
            for (TurntableRecipe recipe : TurntableManager.INSTANCE.getRecipes()) {
                if (!InputHelper.toIItemStack((ItemStack)this.input).matches(InputHelper.toIItemStack((ItemStack)recipe.getStack()))) continue;
                this.successful.add(recipe);
            }
            System.out.println(">>>" + this.successful);
            for (TurntableRecipe recipe : this.successful) {
                System.out.println(">>>" + TurntableManager.INSTANCE.getRecipes().remove(recipe));
            }
        }

        public String describe() {
            return String.format("Removing %d %s Recipe(s) for %s", TurntableManager.INSTANCE.removeTurntableRecipe(this.input).size(), this.name, this.getRecipeInfo());
        }

        protected String getRecipeInfo(TurntableRecipe recipe) {
            return recipe.getStack().func_82833_r();
        }
    }

    public static class Add
    extends BMAdd {
        public Add(ItemStack input, ItemStack output, List<ItemStack> scraps) {
            super("bwm.turntable", TurntableManager.INSTANCE, Lists.newArrayList((Object[])new TurntableRecipe[]{new TurntableRecipe(Block.func_149634_a((Item)input.func_77973_b()), input.func_77960_j(), output.func_190926_b() ? null : Block.func_149634_a((Item)output.func_77973_b()), output.func_190926_b() ? 0 : output.func_77960_j(), scraps)}));
        }
    }
}

