/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser;

import cofh.cofhworld.parser.variables.BiomeData;
import cofh.cofhworld.world.IConfigurableFeatureGenerator;
import cofh.cofhworld.world.IFeatureGenerator;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigOrigin;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.Logger;

public interface IDistributionParser {
    public static void addFeatureRestrictions(IConfigurableFeatureGenerator feature, Config genObject, Logger log) throws InvalidDistributionException {
        IConfigurableFeatureGenerator.GenRestriction biomeRes = IConfigurableFeatureGenerator.GenRestriction.NONE;
        if (genObject.hasPath("biome")) {
            ConfigValue data = genObject.getValue("biome");
            if (data.valueType() == ConfigValueType.STRING) {
                biomeRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString("biome"));
                if (biomeRes != IConfigurableFeatureGenerator.GenRestriction.NONE) {
                    log.error("Invalid biome restriction {2} on '{1}'. Must be an object to meaningfully function", (Object)feature.getFeatureName(), (Object)biomeRes.name().toLowerCase(Locale.US));
                    throw new InvalidDistributionException("Invalid value for string", data.origin());
                }
            } else if (data.valueType() == ConfigValueType.OBJECT) {
                biomeRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString("biome.restriction"));
                feature.addBiomes(BiomeData.parseBiomeRestrictions(genObject.getConfig("biome")));
            }
        }
        feature.setBiomeRestriction(biomeRes);
        IConfigurableFeatureGenerator.GenRestriction dimRes = IConfigurableFeatureGenerator.GenRestriction.NONE;
        if (genObject.hasPath("dimension")) {
            String field = "dimension";
            ConfigValue data = genObject.getValue("dimension");
            ConfigList restrictionList = null;
            switch (data.valueType()) {
                case STRING: {
                    dimRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString("dimension"));
                    if (dimRes == IConfigurableFeatureGenerator.GenRestriction.NONE) break;
                    log.error("Invalid dimension restriction {2} on '{1}'. Must be an object to meaningfully function", (Object)feature.getFeatureName(), (Object)dimRes.name().toLowerCase(Locale.US));
                    throw new InvalidDistributionException("Invalid value for string", data.origin());
                }
                case OBJECT: {
                    dimRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString(field + ".restriction"));
                    field = field + ".value";
                }
                case LIST: {
                    restrictionList = genObject.getList(field);
                    break;
                }
                case NUMBER: {
                    dimRes = IConfigurableFeatureGenerator.GenRestriction.WHITELIST;
                    feature.addDimension(genObject.getNumber(field).intValue());
                }
            }
            if (restrictionList != null) {
                for (int i = 0; i < restrictionList.size(); ++i) {
                    ConfigValue val = (ConfigValue)restrictionList.get(i);
                    if (val.valueType() != ConfigValueType.NUMBER) continue;
                    feature.addDimension(((Number)val.unwrapped()).intValue());
                }
            }
        }
        feature.setDimensionRestriction(dimRes);
    }

    public String[] getRequiredFields();

    @Nonnull
    default public IFeatureGenerator parseFeature(String featureName, Config genObject, Logger log) throws InvalidDistributionException {
        boolean retrogen = false;
        if (genObject.hasPath("retrogen")) {
            retrogen = genObject.getBoolean("retrogen");
        }
        IConfigurableFeatureGenerator feature = this.getFeature(featureName, genObject, retrogen, log);
        if (genObject.hasPath("chunk-chance")) {
            int rarity = MathHelper.func_76125_a((int)genObject.getInt("chunk-chance"), (int)1, (int)1000000000);
            feature.setRarity(rarity);
        }
        IDistributionParser.addFeatureRestrictions(feature, genObject, log);
        if (genObject.hasPath("in-village")) {
            feature.setWithVillage(genObject.getBoolean("in-village"));
        }
        return feature;
    }

    @Nonnull
    public IConfigurableFeatureGenerator getFeature(String var1, Config var2, boolean var3, Logger var4) throws InvalidDistributionException;

    public static class InvalidDistributionException
    extends Exception {
        private final ConfigOrigin origin;

        public InvalidDistributionException(String cause, ConfigOrigin origin) {
            super(cause);
            this.origin = origin;
        }

        public ConfigOrigin origin() {
            return this.origin;
        }

        public InvalidDistributionException causedBy(Throwable cause) {
            this.initCause(cause);
            return this;
        }
    }
}

