/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="netherportalfix", name="NetherPortalFix", version="5.3.13", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12]")
public class NetherPortalFix {
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String NETHER_PORTAL_FIX = "NetherPortalFix";
    private static final String SCHEDULED_TELEPORT = "NPFScheduledTeleport";
    private static final String FROM = "From";
    private static final String FROM_DIM = "FromDim";
    private static final String TO = "To";
    private static final String TO_DIM = "ToDim";

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            MinecraftServer server;
            NBTTagList portalList;
            NBTTagCompound returnPortal;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.getEntityData().func_74764_b(SCHEDULED_TELEPORT)) {
                return;
            }
            BlockPos fromPos = player.field_181016_an;
            if (fromPos == null || player.func_180425_c().func_185332_f(fromPos.func_177958_n(), fromPos.func_177956_o(), fromPos.func_177952_p()) > 2.0) {
                player.field_181016_an = null;
                return;
            }
            int fromDim = event.getEntity().field_71093_bK;
            int toDim = event.getDimension();
            if ((fromDim == 0 && toDim == -1 || fromDim == -1 && toDim == 0) && (returnPortal = this.findReturnPortal(portalList = this.getPlayerPortalList(player), fromPos, fromDim)) != null && (server = player.func_130014_f_().func_73046_m()) != null) {
                BlockPos tryPos;
                WorldServer toWorld = server.func_71218_a(toDim);
                BlockPos toPos = BlockPos.func_177969_a((long)returnPortal.func_74763_f(TO));
                while (toWorld.func_180495_p(tryPos = toPos.func_177972_a(EnumFacing.DOWN)).func_177230_c() == Blocks.field_150427_aO) {
                    toPos = tryPos;
                }
                if (toWorld.func_180495_p(toPos).func_177230_c() == Blocks.field_150427_aO) {
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    tagCompound.func_74768_a(TO_DIM, toDim);
                    tagCompound.func_74772_a(TO, toPos.func_177986_g());
                    player.getEntityData().func_74782_a(SCHEDULED_TELEPORT, (NBTBase)tagCompound);
                    event.setCanceled(true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("netherportalfix:portal_destroyed", new Object[0]), true);
                    this.removeReturnPortal(portalList, returnPortal);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        NBTTagCompound entityData;
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER && (entityData = event.player.getEntityData()).func_74764_b(SCHEDULED_TELEPORT)) {
            NBTTagCompound data = entityData.func_74775_l(SCHEDULED_TELEPORT);
            int toDim = data.func_74762_e(TO_DIM);
            EntityTravelToDimensionEvent travelEvent = new EntityTravelToDimensionEvent((Entity)event.player, toDim);
            if (MinecraftForge.EVENT_BUS.post((Event)travelEvent)) {
                entityData.func_82580_o(SCHEDULED_TELEPORT);
                return;
            }
            MinecraftServer server = event.player.func_130014_f_().func_73046_m();
            if (server != null) {
                NetherPortalFix.transferPlayerToDimension((EntityPlayerMP)event.player, toDim, server.func_184103_al(), BlockPos.func_177969_a((long)data.func_74763_f(TO)));
            }
            entityData.func_82580_o(SCHEDULED_TELEPORT);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.fromDim == 0 && event.toDim == -1 || event.fromDim == -1 && event.toDim == 0) {
            EntityPlayer player = event.player;
            BlockPos fromPos = player.field_181016_an;
            if (fromPos == null) {
                return;
            }
            BlockPos toPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            NBTTagList portalList = this.getPlayerPortalList(player);
            this.storeReturnPortal(portalList, toPos, event.toDim, fromPos);
        }
    }

    private static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld, BlockPos pos) {
        oldWorld.field_72984_F.func_76320_a("placing");
        if (entity.func_70089_S()) {
            entity.func_70012_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), entity.field_70177_z, entity.field_70125_A);
            entity.field_70143_R = 0.0f;
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        oldWorld.field_72984_F.func_76319_b();
        entity.func_70029_a((World)newWorld);
    }

    private static void transferPlayerToDimension(EntityPlayerMP player, int dimension, PlayerList manager, BlockPos pos) {
        player.field_184851_cj = true;
        int oldDim = player.field_71093_bK;
        WorldServer oldWorld = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer newWorld = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, newWorld.func_175659_aa(), newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        oldWorld.func_72973_f((Entity)player);
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        player.field_70128_L = false;
        NetherPortalFix.transferEntityToWorld((Entity)player, oldWorld, newWorld, pos);
        manager.func_72375_a(player, oldWorld);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(newWorld);
        manager.func_72354_b(player, newWorld);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }

    private NBTTagList getPlayerPortalList(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagList list = data.func_150295_c(NETHER_PORTAL_FIX, 10);
        data.func_74782_a(NETHER_PORTAL_FIX, (NBTBase)list);
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)data);
        return list;
    }

    @Nullable
    private NBTTagCompound findReturnPortal(NBTTagList portalList, BlockPos triggerPos, int triggerDim) {
        for (NBTBase entry : portalList) {
            BlockPos portalTrigger;
            NBTTagCompound portal = (NBTTagCompound)entry;
            if (portal.func_74762_e(FROM_DIM) != triggerDim || !((portalTrigger = BlockPos.func_177969_a((long)portal.func_74763_f(FROM))).func_177951_i((Vec3i)triggerPos) <= 16.0)) continue;
            return portal;
        }
        return null;
    }

    private void storeReturnPortal(NBTTagList portalList, BlockPos triggerPos, int triggerDim, BlockPos returnPos) {
        NBTTagCompound found = this.findReturnPortal(portalList, triggerPos, triggerDim);
        if (found == null) {
            NBTTagCompound portalCompound = new NBTTagCompound();
            portalCompound.func_74772_a(FROM, triggerPos.func_177986_g());
            portalCompound.func_74768_a(FROM_DIM, triggerDim);
            portalCompound.func_74772_a(TO, returnPos.func_177986_g());
            portalList.func_74742_a((NBTBase)portalCompound);
        } else {
            BlockPos portalReturnPos = BlockPos.func_177969_a((long)found.func_74763_f(TO));
            if (portalReturnPos.func_177951_i((Vec3i)returnPos) > 16.0) {
                found.func_74772_a(TO, returnPos.func_177986_g());
            }
        }
    }

    private void removeReturnPortal(NBTTagList portalList, NBTTagCompound portal) {
        for (int i = 0; i < portalList.func_74745_c(); ++i) {
            if (portalList.func_179238_g(i) != portal) continue;
            portalList.func_74744_a(i);
            break;
        }
    }
}

