/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.features;

import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.world.ITreeConstants;

public class WorldGenFirTree
extends WorldGenAbstractTree
implements ITreeConstants {
    public final boolean isWorldGen;
    private final int minTreeHeight;
    private IBlockState stateWood;
    private IBlockState stateLeaves;

    public WorldGenFirTree(boolean isWorldGen) {
        this(isWorldGen, 15);
    }

    public WorldGenFirTree(boolean isWorldGen, int minTreeHeight) {
        this(isWorldGen, minTreeHeight, FIR_LOG, FIR_LEAVES);
    }

    public WorldGenFirTree(boolean isWorldGen, int minTreeHeight, IBlockState stateWood, IBlockState stateLeaves) {
        super(!isWorldGen);
        this.isWorldGen = isWorldGen;
        this.minTreeHeight = minTreeHeight;
        this.stateWood = TraverseConfig.useVanillaWood ? DARK_OAK_LOG : stateWood;
        this.stateLeaves = stateLeaves;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int treeHeight = rand.nextInt(15) + this.minTreeHeight;
        int nakedLogHeight = 4 + rand.nextInt(2);
        int leavesHeight = treeHeight - nakedLogHeight;
        int l = 2 + rand.nextInt(2);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + treeHeight + 1 <= worldIn.func_72800_K()) {
            for (int i1 = position.func_177956_o(); i1 <= position.func_177956_o() + 1 + treeHeight && flag; ++i1) {
                int j1 = i1 - position.func_177956_o() < nakedLogHeight ? 0 : l;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1 && flag; ++k1) {
                    for (int l1 = position.func_177952_p() - j1; l1 <= position.func_177952_p() + j1 && flag; ++l1) {
                        if (i1 >= 0 && i1 < worldIn.func_72800_K()) {
                            IBlockState state = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1));
                            if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1)) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g)) && position.func_177956_o() < worldIn.func_72800_K() - treeHeight - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                int i3 = rand.nextInt(2);
                int j3 = 1;
                int k3 = 0;
                for (int l3 = 0; l3 <= leavesHeight; ++l3) {
                    int j4 = position.func_177956_o() + treeHeight - l3;
                    for (int i2 = position.func_177958_n() - i3; i2 <= position.func_177958_n() + i3; ++i2) {
                        int j2 = i2 - position.func_177958_n();
                        for (int k2 = position.func_177952_p() - i3; k2 <= position.func_177952_p() + i3; ++k2) {
                            BlockPos blockpos;
                            int l2 = k2 - position.func_177952_p();
                            if (Math.abs(j2) == i3 && Math.abs(l2) == i3 && i3 > 0 || !(state = worldIn.func_180495_p(blockpos = new BlockPos(i2, j4, k2))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, this.stateLeaves);
                        }
                    }
                    if (i3 >= j3) {
                        i3 = k3;
                        k3 = 1;
                        if (++j3 <= l) continue;
                        j3 = l;
                        continue;
                    }
                    ++i3;
                }
                int i4 = rand.nextInt(3);
                for (int k4 = 0; k4 < treeHeight - i4; ++k4) {
                    BlockPos upN = position.func_177981_b(k4);
                    state = worldIn.func_180495_p(upN);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(k4), this.stateWood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

