/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.features;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import prospector.traverse.world.ITreeConstants;

public class WorldGenCustomSwampTree
extends WorldGenAbstractTree
implements ITreeConstants {
    public final boolean isWorldGen;
    private final int minTreeHeight;
    private IBlockState stateWood;
    private IBlockState stateLeaves;

    public WorldGenCustomSwampTree(boolean isWorldGen) {
        this(isWorldGen, 5);
    }

    public WorldGenCustomSwampTree(boolean isWorldGen, int minTreeHeight) {
        this(isWorldGen, minTreeHeight, OAK_LOG, OAK_LEAVES);
    }

    public WorldGenCustomSwampTree(boolean isWorldGen, int minTreeHeight, IBlockState stateWood, IBlockState stateLeaves) {
        super(!isWorldGen);
        this.isWorldGen = isWorldGen;
        this.minTreeHeight = minTreeHeight;
        this.stateWood = stateWood;
        this.stateLeaves = stateLeaves;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(4) + this.minTreeHeight;
        while (worldIn.func_180495_p(position.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            position = position.func_177977_b();
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            Block block = iblockstate.func_177230_c();
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                                flag = false;
                                continue;
                            }
                            if (j <= position.func_177956_o()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
                for (int k1 = position.func_177956_o() - 3 + i; k1 <= position.func_177956_o() + i; ++k1) {
                    int j2 = k1 - (position.func_177956_o() + i);
                    int l2 = 2 - j2 / 2;
                    for (int j3 = position.func_177958_n() - l2; j3 <= position.func_177958_n() + l2; ++j3) {
                        int k3 = j3 - position.func_177958_n();
                        for (int i4 = position.func_177952_p() - l2; i4 <= position.func_177952_p() + l2; ++i4) {
                            BlockPos blockpos;
                            int j1 = i4 - position.func_177952_p();
                            if (Math.abs(k3) == l2 && Math.abs(j1) == l2 && (rand.nextInt(2) == 0 || j2 == 0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(j3, k1, i4))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, this.stateLeaves);
                        }
                    }
                }
                for (int l1 = 0; l1 < i; ++l1) {
                    BlockPos upN = position.func_177981_b(l1);
                    IBlockState iblockstate1 = worldIn.func_180495_p(upN);
                    Block block2 = iblockstate1.func_177230_c();
                    if (!block2.isAir(iblockstate1, (IBlockAccess)worldIn, upN) && !block2.isLeaves(iblockstate1, (IBlockAccess)worldIn, upN) && block2 != Blocks.field_150358_i && block2 != Blocks.field_150355_j) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(l1), this.stateWood);
                }
                for (int i2 = position.func_177956_o() - 3 + i; i2 <= position.func_177956_o() + i; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + i);
                    int i3 = 2 - k2 / 2;
                    BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                    for (int l3 = position.func_177958_n() - i3; l3 <= position.func_177958_n() + i3; ++l3) {
                        for (int j4 = position.func_177952_p() - i3; j4 <= position.func_177952_p() + i3; ++j4) {
                            blockpos$mutableblockpos1.func_181079_c(l3, i2, j4);
                            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1).func_185904_a() != Material.field_151584_j) continue;
                            BlockPos blockpos3 = blockpos$mutableblockpos1.func_177976_e();
                            BlockPos blockpos4 = blockpos$mutableblockpos1.func_177974_f();
                            BlockPos blockpos1 = blockpos$mutableblockpos1.func_177978_c();
                            BlockPos blockpos2 = blockpos$mutableblockpos1.func_177968_d();
                            if (rand.nextInt(4) == 0 && this.isAir(worldIn, blockpos3)) {
                                this.addVine(worldIn, blockpos3, BlockVine.field_176278_M);
                            }
                            if (rand.nextInt(4) == 0 && this.isAir(worldIn, blockpos4)) {
                                this.addVine(worldIn, blockpos4, BlockVine.field_176280_O);
                            }
                            if (rand.nextInt(4) == 0 && this.isAir(worldIn, blockpos1)) {
                                this.addVine(worldIn, blockpos1, BlockVine.field_176279_N);
                            }
                            if (rand.nextInt(4) != 0 || !this.isAir(worldIn, blockpos2)) continue;
                            this.addVine(worldIn, blockpos2, BlockVine.field_176273_b);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(World worldIn, BlockPos pos, PropertyBool prop) {
        IBlockState iblockstate = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
        this.func_175903_a(worldIn, pos, iblockstate);
        pos = pos.func_177977_b();
        for (int i = 4; this.isAir(worldIn, pos) && i > 0; --i) {
            this.func_175903_a(worldIn, pos, iblockstate);
            pos = pos.func_177977_b();
        }
    }

    private boolean isAir(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos);
    }
}

