/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.biomes;

import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.world.ITreeConstants;
import prospector.traverse.world.features.WorldGenFallenTree;

public class BiomeWoodlands
extends Biome
implements ITreeConstants {
    protected static final WorldGenFallenTree FALLEN_TREE_FEATURE = new WorldGenFallenTree(true);
    public static Biome.BiomeProperties properties = new Biome.BiomeProperties("Woodlands");

    public BiomeWoodlands() {
        super(properties);
        this.field_76760_I.field_76832_z = 4;
        this.field_76760_I.field_76802_A = 6;
        this.field_76760_I.field_76803_B = 16;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 2, 4, 4));
        this.flowers.clear();
        for (BlockFlower.EnumFlowerType type : BlockFlower.EnumFlowerType.values()) {
            if (type.func_176964_a() == BlockFlower.EnumFlowerColor.YELLOW) continue;
            if (type == BlockFlower.EnumFlowerType.BLUE_ORCHID) {
                type = BlockFlower.EnumFlowerType.POPPY;
            }
            this.addFlower(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)type), 10);
        }
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() / 200.0, (double)pos.func_177952_p() / 200.0);
        if (d0 < -0.8) {
            int j = rand.nextInt(4);
            switch (j) {
                case 0: {
                    return BlockFlower.EnumFlowerType.ORANGE_TULIP;
                }
                case 1: {
                    return BlockFlower.EnumFlowerType.RED_TULIP;
                }
                case 2: {
                    return BlockFlower.EnumFlowerType.PINK_TULIP;
                }
            }
            return BlockFlower.EnumFlowerType.WHITE_TULIP;
        }
        if (rand.nextInt(3) > 0) {
            int i = rand.nextInt(3);
            return i == 0 ? BlockFlower.EnumFlowerType.POPPY : (i == 1 ? BlockFlower.EnumFlowerType.HOUSTONIA : BlockFlower.EnumFlowerType.OXEYE_DAISY);
        }
        return BlockFlower.EnumFlowerType.DANDELION;
    }

    public int getModdedBiomeGrassColor(int original) {
        return -6706859;
    }

    public int func_76731_a(float currentTemperature) {
        if (TraverseConfig.disableCustomSkies) {
            return super.func_76731_a(currentTemperature);
        }
        return -7818015;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return -8085942;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        int num = rand.nextInt(3);
        if (num == 0) {
            return new WorldGenShrub(OAK_LOG, OAK_LEAVES);
        }
        return field_76757_N;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int genChance;
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && (genChance = rand.nextInt(5)) == 0) {
            int k6 = rand.nextInt(16) + 8;
            int l = rand.nextInt(16) + 8;
            BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, 0, l));
            FALLEN_TREE_FEATURE.func_180709_b(worldIn, rand, blockpos);
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    static {
        properties.func_185410_a(0.8f);
        properties.func_185395_b(0.4f);
        properties.func_185398_c(0.2f);
        properties.func_185400_d(0.05f);
    }
}

