/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.biomes;

import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.init.TraverseBlocks;
import prospector.traverse.util.TUtils;
import prospector.traverse.world.ITreeConstants;
import prospector.traverse.world.features.WorldGenPlant;

public class BiomeCanyon
extends Biome
implements ITreeConstants {
    public static final WorldGenerator DEAD_GRASS_FEATURE = new WorldGenPlant(TraverseBlocks.blocks.get("dead_grass").func_176223_P());
    public static IBlockState redRock = Blocks.field_180395_cM.func_176223_P();
    public static Biome.BiomeProperties properties = new Biome.BiomeProperties("Canyon");

    public BiomeCanyon() {
        super(properties);
        if (!TraverseConfig.vanillaCanyonBlocks) {
            redRock = TUtils.getBlock("red_rock").func_176223_P();
        }
        this.field_76752_A = redRock;
        this.field_76753_B = redRock;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_189870_A = -999.0f;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76803_B = 1;
        this.field_76760_I.field_76808_K = false;
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPig.class, 3, 3, 5));
    }

    public int getModdedBiomeGrassColor(int original) {
        return -7306931;
    }

    public WorldGenerator func_76730_b(Random rand) {
        return DEAD_GRASS_FEATURE;
    }

    public int func_76731_a(float currentTemperature) {
        if (TraverseConfig.disableCustomSkies) {
            return super.func_76731_a(currentTemperature);
        }
        return -7807489;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? field_185371_g : field_185372_h;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                    chunkPrimerIn.func_177855_a(i1, j1, l, field_185368_d);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j == 0 && iblockstate1.func_177230_c() == Blocks.field_150354_m && k > 1) {
                j = rand.nextInt(4) + Math.max(0, j1 - 63);
                IBlockState iBlockState = iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? field_185369_e : field_185370_f;
            }
            if (j == 0 && iblockstate == redRock && k > 1) {
                j = rand.nextInt(4) + Math.max(0, j1 - 63);
                iblockstate = redRock;
            }
            if (j != 0 || iblockstate1 != redRock || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = redRock;
        }
    }

    public int getModdedBiomeFoliageColor(int original) {
        return -6389427;
    }

    static {
        properties.func_185410_a(1.0f);
        properties.func_185395_b(0.0f);
        properties.func_185398_c(1.8f);
        properties.func_185400_d(1.0f);
    }
}

