/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import prospector.traverse.core.TraverseConstants;
import prospector.traverse.shadow.shootingstar.version.Version;

public class TraverseWorldVersion {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public File versionConfig;
    public Version version;

    public TraverseWorldVersion(File worldDir) {
        File traverseDir = new File(worldDir, "traverse");
        if (!traverseDir.exists()) {
            traverseDir.mkdir();
        }
        this.versionConfig = new File(traverseDir, "instance_version.json");
        this.version = "1".equals("@major@") ? TraverseConstants.DEV_VERSION : new Version(Integer.parseInt("1"), Integer.parseInt("3"), Integer.parseInt("1"));
        this.reloadVersionFile();
    }

    public void reloadVersionFile() {
        if (!this.versionConfig.exists()) {
            this.writeVersionFile(new VersionConfig(this.version));
        }
        if (this.versionConfig.exists()) {
            VersionConfig config = null;
            try (FileReader reader = new FileReader(this.versionConfig);){
                config = (VersionConfig)GSON.fromJson((Reader)reader, VersionConfig.class);
                this.version = config.version;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (config == null) {
                config = new VersionConfig(this.version);
                this.writeVersionFile(config);
            }
        }
    }

    public void writeVersionFile(VersionConfig config) {
        try (FileWriter writer = new FileWriter(this.versionConfig);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reloadVersionFile();
    }

    public static class VersionConfig {
        public Version version;

        public VersionConfig(Version version) {
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
        }
    }
}

