/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.shadow.shootingstar.version.Version;
import prospector.traverse.world.biomes.BiomeAutumnalWoodedHills;
import prospector.traverse.world.biomes.BiomeAutumnalWoods;
import prospector.traverse.world.biomes.BiomeBadlands;
import prospector.traverse.world.biomes.BiomeCanyon;
import prospector.traverse.world.biomes.BiomeCliffs;
import prospector.traverse.world.biomes.BiomeCragCliffs;
import prospector.traverse.world.biomes.BiomeForestedHills;
import prospector.traverse.world.biomes.BiomeGlacier;
import prospector.traverse.world.biomes.BiomeGreenSwamp;
import prospector.traverse.world.biomes.BiomeLushHills;
import prospector.traverse.world.biomes.BiomeMeadow;
import prospector.traverse.world.biomes.BiomeMiniJungle;
import prospector.traverse.world.biomes.BiomeMountainousDesert;
import prospector.traverse.world.biomes.BiomeRedDesert;
import prospector.traverse.world.biomes.BiomeRockyPlateau;
import prospector.traverse.world.biomes.BiomeTemperateRainforest;
import prospector.traverse.world.biomes.BiomeWoodlands;

@Mod.EventBusSubscriber
public class TraverseWorld {
    public static List<TraverseBiomeEntry> biomeList = new ArrayList<TraverseBiomeEntry>();
    public static Biome autumnalWoodsBiome = new BiomeAutumnalWoods();
    public static Biome woodlandsBiome = new BiomeWoodlands();
    public static Biome miniJungleBiome = new BiomeMiniJungle();
    public static Biome meadowBiome = new BiomeMeadow();
    public static Biome lushSwampBiome = new BiomeGreenSwamp();
    public static Biome redDesertBiome = new BiomeRedDesert();
    public static Biome temperateRainforestBiome = new BiomeTemperateRainforest(false);
    public static Biome badlandsBiome = new BiomeBadlands();
    public static Biome mountainousDesertBiome = new BiomeMountainousDesert();
    public static Biome rockyPlateauBiome = new BiomeRockyPlateau();
    public static Biome forestedHillsBiome = new BiomeForestedHills(BiomeForest.Type.NORMAL, "Forested Hills");
    public static Biome birchForestedHillsBiome = new BiomeForestedHills(BiomeForest.Type.BIRCH, "Birch Forested Hills");
    public static Biome autumnalWoodedHillsBiome = new BiomeAutumnalWoodedHills();
    public static Biome cliffsBiome = new BiomeCliffs();
    public static Biome glacierBiome = new BiomeGlacier(false);
    public static Biome glacierSpikesBiome = new BiomeGlacier(true);
    public static Biome snowyConiferousForestBiome = new BiomeTemperateRainforest(true);
    public static Biome lushHillsBiome = new BiomeLushHills();
    public static Biome canyonBiome = new BiomeCanyon();
    public static Biome cragCliffsBiome = new BiomeCragCliffs();
    public static final Version V1 = new Version(1, 0, 0);
    public static final Version V11 = new Version(1, 1, 0);
    public static final Version V12 = new Version(1, 2, 0);
    public static final Version V13 = new Version(1, 3, 0);

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        TraverseWorld.register(V1, autumnalWoodsBiome, BiomeManager.BiomeType.COOL, "autumnal_woods", 8, TraverseConfig.disableAutumnalWoods, event, BiomeDictionary.Type.FOREST);
        TraverseWorld.register(V1, woodlandsBiome, BiomeManager.BiomeType.WARM, "woodlands", 9, TraverseConfig.disableWoodlands, event, BiomeDictionary.Type.PLAINS);
        TraverseWorld.register(V1, miniJungleBiome, BiomeManager.BiomeType.WARM, "mini_jungle", 3, TraverseConfig.disableMiniJungle, event, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET);
        TraverseWorld.register(V1, meadowBiome, BiomeManager.BiomeType.COOL, "meadow", 7, TraverseConfig.disableMeadow, event, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        TraverseWorld.register(V1, lushSwampBiome, BiomeManager.BiomeType.WARM, "green_swamp", 6, TraverseConfig.disableLushSwamp, event, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        TraverseWorld.register(V1, redDesertBiome, BiomeManager.BiomeType.DESERT, "red_desert", 6, TraverseConfig.disableRedDesert, event, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
        TraverseWorld.register(V1, temperateRainforestBiome, BiomeManager.BiomeType.COOL, "temperate_rainforest", 8, TraverseConfig.disableTemperateRainforest, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS);
        TraverseWorld.register(V11, badlandsBiome, BiomeManager.BiomeType.WARM, "badlands", 5, TraverseConfig.disableBadlands, event, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
        TraverseWorld.register(V11, mountainousDesertBiome, BiomeManager.BiomeType.DESERT, "mountainous_desert", 2, TraverseConfig.disableMountainousDesert, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        TraverseWorld.register(V11, rockyPlateauBiome, BiomeManager.BiomeType.WARM, "rocky_plateau", 4, TraverseConfig.disableRockyPlateau, event, new BiomeDictionary.Type[0]);
        TraverseWorld.register(V11, forestedHillsBiome, BiomeManager.BiomeType.COOL, "forested_hills", 6, TraverseConfig.disableForestedHills, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V11, birchForestedHillsBiome, BiomeManager.BiomeType.COOL, "birch_forested_hills", 2, TraverseConfig.disableBirchForestedHills, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V11, autumnalWoodedHillsBiome, BiomeManager.BiomeType.COOL, "autumnal_wooded_hills", 1, TraverseConfig.disableAutumnalWoodedHills, event, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V12, cliffsBiome, BiomeManager.BiomeType.COOL, "cliffs", 2, TraverseConfig.disableCliffs, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS);
        TraverseWorld.register(V12, glacierBiome, BiomeManager.BiomeType.ICY, "glacier", 6, TraverseConfig.disableGlacier, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        TraverseWorld.register(V12, glacierSpikesBiome, BiomeManager.BiomeType.ICY, "glacier_spikes", 2, TraverseConfig.disableGlacierSpikes, event, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        TraverseWorld.register(V12, snowyConiferousForestBiome, BiomeManager.BiomeType.ICY, "snowy_coniferous_forest", 5, TraverseConfig.disableGlacierSpikes, event, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS);
        TraverseWorld.register(V13, lushHillsBiome, BiomeManager.BiomeType.COOL, "lush_hills", 6, TraverseConfig.disableLushHills, event, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET);
        TraverseWorld.register(V13, canyonBiome, BiomeManager.BiomeType.DESERT, "canyon", 5, TraverseConfig.disableCanyon, event, BiomeDictionary.Type.DRY);
        TraverseWorld.register(V13, cragCliffsBiome, BiomeManager.BiomeType.COOL, "crag_cliffs", 4, TraverseConfig.disableCragCliffs, event, BiomeDictionary.Type.COLD);
    }

    public static void register(Version versionAdded, Biome biome, BiomeManager.BiomeType type, String name, int weight, boolean disabled, RegistryEvent.Register<Biome> event, BiomeDictionary.Type ... biomeDictTypes) {
        if (!disabled) {
            biome.setRegistryName(new ResourceLocation("traverse", name));
            event.getRegistry().register((IForgeRegistryEntry)biome);
            for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
                BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
            }
            biomeList.add(new TraverseBiomeEntry(biome, type, weight, versionAdded));
        }
    }

    public static class TraverseBiomeEntry {
        private Biome biome;
        private BiomeManager.BiomeType type;
        private Version versionAdded;
        private int weight;
        private BiomeManager.BiomeEntry entry;

        public TraverseBiomeEntry(Biome biome, BiomeManager.BiomeType type, int weight, Version versionAdded) {
            this.biome = biome;
            this.type = type;
            this.weight = weight;
            this.versionAdded = versionAdded;
            this.entry = new BiomeManager.BiomeEntry(biome, weight);
        }

        public Biome getBiome() {
            return this.biome;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }

        public BiomeManager.BiomeType getType() {
            return this.type;
        }

        public Version getVersionAdded() {
            return this.versionAdded;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

