/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.shadow.shootingstar;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import prospector.traverse.shadow.shootingstar.BlockCompound;
import prospector.traverse.shadow.shootingstar.ItemCompound;
import prospector.traverse.shadow.shootingstar.model.ModelCompound;
import prospector.traverse.shadow.shootingstar.model.ModelMethods;

public class ShootingStar {
    protected static List<ModelCompound> modelList = new ArrayList<ModelCompound>();
    protected static List<BlockCompound> blockList = new ArrayList<BlockCompound>();
    protected static List<ItemCompound> itemList = new ArrayList<ItemCompound>();

    public static Block getBlock(String modid, String name) {
        for (BlockCompound compound : blockList) {
            if (!compound.getRegistryName().equals((Object)new ResourceLocation(modid, name))) continue;
            return compound.getBlock();
        }
        throw new InvalidParameterException("Block '" + modid + ":" + name + "' cannot be found in the Shooting Star registry");
    }

    public static void registerModel(ModelCompound modelCompound) {
        modelList.add(modelCompound);
    }

    public static void registerBlock(BlockCompound blockCompound) {
        blockList.add(blockCompound);
    }

    public static void registerItem(ItemCompound itemCompound) {
        itemList.add(itemCompound);
    }

    public static void registerModels(String modid) {
        for (ModelCompound compound : modelList) {
            if (!compound.getModid().equals(modid)) continue;
            if (compound.isBlock()) {
                if (compound.getFileName().equals("shootingstar.undefinedfilename")) {
                    ModelMethods.registerItemModel(compound.getItem(), compound.getMeta(), compound.getBlockStatePath(), compound.getInventoryVariant());
                } else {
                    ModelMethods.registerItemModel(compound.getItem(), compound.getMeta(), compound.getFileName(), compound.getBlockStatePath(), compound.getInventoryVariant());
                }
            }
            if (!compound.isBlock()) continue;
            if (compound.getFileName().equals("shootingstar.undefinedfilename")) {
                ModelMethods.setBlockStateMapper(compound.getBlock(), compound.getBlockStatePath(), compound.getIgnoreProperties());
                continue;
            }
            ModelMethods.setBlockStateMapper(compound.getBlock(), compound.getFileName(), compound.getBlockStatePath(), compound.getIgnoreProperties());
        }
    }

    public static void registerBlocks(String modid, RegistryEvent.Register<Block> event) {
        for (BlockCompound compound : blockList) {
            if (!compound.getModid().equals(modid)) continue;
            event.getRegistry().register((IForgeRegistryEntry)compound.getBlock());
        }
    }

    public static void registerItems(String modid, RegistryEvent.Register<Item> event) {
        for (BlockCompound blockCompound : blockList) {
            if (!blockCompound.hasItemBlock() || !blockCompound.getModid().equals(modid)) continue;
            if (blockCompound.getItem() == null) {
                event.getRegistry().register(new ItemBlock(blockCompound.getBlock()).setRegistryName(blockCompound.getBlock().getRegistryName()));
                continue;
            }
            event.getRegistry().register((IForgeRegistryEntry)blockCompound.getItem());
        }
        for (ItemCompound itemCompound : itemList) {
            if (!itemCompound.getModid().equals(modid)) continue;
            event.getRegistry().register((IForgeRegistryEntry)itemCompound.getItem());
        }
    }
}

