/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.init;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.util.ResourceLocation;
import prospector.traverse.blocks.AutumnalLSCompound;
import prospector.traverse.blocks.BlockTraverseColdGrass;
import prospector.traverse.blocks.BlockTraverseDeadGrass;
import prospector.traverse.blocks.FirLSCompound;
import prospector.traverse.blocks.base.BlockTraverse;
import prospector.traverse.blocks.base.BlockTraverseSlab;
import prospector.traverse.blocks.base.BlockTraverseStairs;
import prospector.traverse.blocks.base.BlockTraverseWall;
import prospector.traverse.blocks.base.BlockTraverseWoodDoor;
import prospector.traverse.blocks.base.BlockTraverseWoodFence;
import prospector.traverse.blocks.base.BlockTraverseWoodFenceGate;
import prospector.traverse.blocks.base.BlockTraverseWoodLog;
import prospector.traverse.blocks.base.BlockTraverseWoodPlanks;
import prospector.traverse.blocks.base.BlockTraverseWoodSlab;
import prospector.traverse.item.ItemTraverseWoodDoor;
import prospector.traverse.shadow.shootingstar.BlockCompound;
import prospector.traverse.shadow.shootingstar.ShootingStar;

public class TraverseBlocks {
    public static LinkedHashMap<String, Block> blocks = new LinkedHashMap();
    public static Map<Block, String> oreDictNames = new HashMap<Block, String>();

    public static void test() {
    }

    static void addAutumnTreeStuff(String colour) {
        if (colour.isEmpty()) {
            return;
        }
        AutumnalLSCompound lsCompound = new AutumnalLSCompound(colour);
        TraverseBlocks.register((Block)lsCompound.lsLeaves);
        TraverseBlocks.register((Block)lsCompound.lsSapling);
    }

    public static void register(Block block) {
        blocks.put(block.getRegistryName().func_110623_a(), block);
        ShootingStar.registerBlock(new BlockCompound("traverse", block));
    }

    public static void register(Block block, boolean noItemBlock) {
        blocks.put(block.getRegistryName().func_110623_a(), block);
        ShootingStar.registerBlock(new BlockCompound("traverse", block, noItemBlock));
    }

    public static void register(Block block, ItemBlock itemBlock) {
        blocks.put(block.getRegistryName().func_110623_a(), block);
        ShootingStar.registerBlock(new BlockCompound("traverse", block, itemBlock));
    }

    static void addFirTreeStuff() {
        String fir = "fir";
        FirLSCompound lsCompound = new FirLSCompound();
        TraverseBlocks.register((Block)lsCompound.lsLeaves);
        oreDictNames.put((Block)lsCompound.lsLeaves, "treeLeaves");
        TraverseBlocks.register((Block)lsCompound.lsSapling);
        oreDictNames.put((Block)lsCompound.lsSapling, "treeSapling");
        BlockTraverseWoodLog log = new BlockTraverseWoodLog(fir);
        TraverseBlocks.register((Block)log);
        oreDictNames.put((Block)log, "logWood");
        BlockTraverseWoodPlanks planks = new BlockTraverseWoodPlanks(fir);
        TraverseBlocks.register(planks);
        oreDictNames.put(planks, "plankWood");
        BlockTraverseStairs stairs = new BlockTraverseStairs(planks.func_176223_P(), fir);
        TraverseBlocks.register((Block)stairs);
        oreDictNames.put((Block)stairs, "stairWood");
        BlockTraverseWoodSlab.Half halfSlab = new BlockTraverseWoodSlab.Half(fir);
        TraverseBlocks.register((Block)halfSlab, true);
        oreDictNames.put((Block)halfSlab, "slabWood");
        BlockTraverseWoodSlab.Double doubleSlab = new BlockTraverseWoodSlab.Double(fir, (Block)halfSlab);
        TraverseBlocks.register((Block)doubleSlab, (ItemBlock)new ItemSlab(blocks.get(halfSlab.name + "_slab"), (BlockSlab)halfSlab, (BlockSlab)doubleSlab).setRegistryName(halfSlab.getRegistryName()));
        TraverseBlocks.register((Block)new BlockTraverseWoodFence(fir));
        TraverseBlocks.register((Block)new BlockTraverseWoodFenceGate(fir));
        BlockTraverseWoodDoor door = new BlockTraverseWoodDoor(fir);
        TraverseBlocks.register((Block)door, new ItemTraverseWoodDoor((Block)door));
    }

    static void addStone(String name, boolean hasBricks, boolean hasSlab, boolean hasCobblestone) {
        BlockTraverseSlab.Double doubleSlab;
        BlockTraverseSlab.Half halfSlab;
        String cobbleName = name + "_cobblestone";
        BlockTraverse stone = hasCobblestone ? new BlockTraverse(name, Material.field_151576_e, SoundType.field_185851_d, new ResourceLocation("traverse", cobbleName)) : new BlockTraverse(name, Material.field_151576_e, SoundType.field_185851_d);
        TraverseBlocks.register(stone);
        oreDictNames.put(stone, "stone");
        if (hasBricks) {
            BlockTraverse bricks = new BlockTraverse(name + "_bricks", Material.field_151576_e, SoundType.field_185851_d);
            TraverseBlocks.register(bricks);
            TraverseBlocks.register((Block)new BlockTraverseStairs(bricks.func_176223_P(), name + "_bricks"));
            halfSlab = new BlockTraverseSlab.Half(name + "_bricks", Material.field_151576_e, SoundType.field_185851_d);
            TraverseBlocks.register((Block)halfSlab, true);
            doubleSlab = new BlockTraverseSlab.Double(name + "_bricks", Material.field_151576_e, SoundType.field_185851_d, (Block)halfSlab);
            TraverseBlocks.register((Block)doubleSlab, (ItemBlock)new ItemSlab(blocks.get(halfSlab.name + "_slab"), (BlockSlab)halfSlab, (BlockSlab)doubleSlab).setRegistryName(halfSlab.getRegistryName()));
        }
        if (hasSlab) {
            if (hasBricks) {
                TraverseBlocks.register(new BlockTraverse(name + "_bricks_chiseled", Material.field_151576_e, SoundType.field_185851_d));
            }
            BlockTraverseSlab.Half halfSlab2 = new BlockTraverseSlab.Half(name, Material.field_151576_e, SoundType.field_185851_d);
            TraverseBlocks.register((Block)halfSlab2, true);
            BlockTraverseSlab.Double doubleSlab2 = new BlockTraverseSlab.Double(name, Material.field_151576_e, SoundType.field_185851_d, (Block)halfSlab2);
            TraverseBlocks.register((Block)doubleSlab2, (ItemBlock)new ItemSlab(blocks.get(halfSlab2.name + "_slab"), (BlockSlab)halfSlab2, (BlockSlab)doubleSlab2).setRegistryName(halfSlab2.getRegistryName()));
        }
        if (hasCobblestone) {
            BlockTraverse cobblestone = new BlockTraverse(cobbleName, Material.field_151576_e, SoundType.field_185851_d);
            TraverseBlocks.register(cobblestone);
            oreDictNames.put(cobblestone, "cobblestone");
            TraverseBlocks.register((Block)new BlockTraverseStairs(cobblestone.func_176223_P(), cobbleName));
            halfSlab = new BlockTraverseSlab.Half(cobbleName, Material.field_151576_e, SoundType.field_185851_d);
            TraverseBlocks.register((Block)halfSlab, true);
            doubleSlab = new BlockTraverseSlab.Double(cobbleName, Material.field_151576_e, SoundType.field_185851_d, (Block)halfSlab);
            TraverseBlocks.register((Block)doubleSlab, (ItemBlock)new ItemSlab(blocks.get(halfSlab.name + "_slab"), (BlockSlab)halfSlab, (BlockSlab)doubleSlab).setRegistryName(halfSlab.getRegistryName()));
            TraverseBlocks.register((Block)new BlockTraverseWall(cobblestone, cobbleName));
        } else {
            TraverseBlocks.register(new BlockTraverse(name, Material.field_151576_e, SoundType.field_185851_d));
        }
    }

    static {
        TraverseBlocks.addAutumnTreeStuff("red");
        TraverseBlocks.addAutumnTreeStuff("brown");
        TraverseBlocks.addAutumnTreeStuff("orange");
        TraverseBlocks.addAutumnTreeStuff("yellow");
        TraverseBlocks.addFirTreeStuff();
        TraverseBlocks.addStone("red_rock", true, true, true);
        TraverseBlocks.addStone("blue_rock", true, true, true);
        TraverseBlocks.register((Block)new BlockTraverseDeadGrass());
        TraverseBlocks.register((Block)new BlockTraverseColdGrass());
    }
}

