/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.commands;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CommandFindBiome
extends CommandBase {
    public static BlockPos spiralOutwardsLookingForBiome(ICommandSender sender, World world, Biome biomeToFind, double startX, double startZ, int timeout) {
        double a = 16.0 / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double dist = 0.0;
        long start = System.currentTimeMillis();
        int n = 0;
        while (dist < 2.147483647E9) {
            double z;
            if (System.currentTimeMillis() - start > (long)timeout) {
                return null;
            }
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            double x = startX + dist * Math.sin(b * rootN);
            if (world.func_180494_b(new BlockPos(x, 0.0, z = startZ + dist * Math.cos(b * rootN))).equals(biomeToFind)) {
                return new BlockPos((int)x, 0, (int)z);
            }
            ++n;
        }
        return null;
    }

    public String func_71517_b() {
        return "findbiome";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/findbiome <biome>";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Biome b : ForgeRegistries.BIOMES.getValues()) {
            String s = b.getRegistryName().toString();
            if (!s.toLowerCase().contains(args[0].toLowerCase())) continue;
            strings.add(s);
        }
        return strings;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Biome biome = null;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("No biome specified"));
            return;
        }
        for (Biome b : ForgeRegistries.BIOMES.getValues()) {
            String name = b.getRegistryName().toString().replaceAll(" ", "_").toLowerCase();
            if (!args[0].equalsIgnoreCase(name)) continue;
            biome = b;
        }
        if (biome == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error! Biome '" + args[0] + "' cannot be found!"));
            return;
        }
        long start = System.currentTimeMillis();
        int timeout = 20000;
        BlockPos pos = CommandFindBiome.spiralOutwardsLookingForBiome(sender, sender.func_130014_f_(), biome, sender.func_180425_c().func_177958_n(), sender.func_180425_c().func_177952_p(), timeout);
        if (pos == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error! Biome '" + args[0] + "' could not be found after " + TextFormatting.GRAY + timeout + "ms" + TextFormatting.RED + "."));
            return;
        }
        System.out.println(pos);
        System.out.println();
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)sender;
            playerMP.field_71135_a.func_147364_a((double)pos.func_177958_n(), 150.0, (double)pos.func_177952_p(), 0.0f, 0.0f);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "Found '" + biome.getRegistryName().toString() + "' Biome! " + TextFormatting.GRAY + "(" + (System.currentTimeMillis() - start) + "ms)"));
    }
}

