/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.core;

import hellfirepvp.astralsorcery.core.ASMTransformationException;
import hellfirepvp.astralsorcery.core.SubClassTransformer;
import hellfirepvp.astralsorcery.core.transform.AstralPatchTransformer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class AstralTransformer
implements IClassTransformer {
    private static List<SubClassTransformer> subTransformers = new LinkedList<SubClassTransformer>();

    public AstralTransformer() throws IOException {
        this.loadSubTransformers();
    }

    private void loadSubTransformers() throws IOException {
        subTransformers.add(new AstralPatchTransformer());
    }

    private boolean isTransformationRequired(String trName) {
        for (SubClassTransformer transformer : subTransformers) {
            if (!transformer.isTransformRequired(trName)) continue;
            return true;
        }
        return false;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (!this.isTransformationRequired(transformedName)) {
            return bytes;
        }
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        for (SubClassTransformer subTransformer : subTransformers) {
            try {
                subTransformer.transformClassNode(node, transformedName, name);
            }
            catch (ASMTransformationException asmException) {
                FMLLog.warning((String)("Access transformation failed for Transformer: " + subTransformer.getIdentifier()), (Object[])new Object[0]);
                FMLLog.warning((String)"Transformer added information:", (Object[])new Object[0]);
                subTransformer.addErrorInformation();
                asmException.printStackTrace();
                throw asmException;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        bytes = writer.toByteArray();
        return bytes;
    }
}

