/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.struct;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDiscoverer {
    public static BlockArray searchForBlocksAround(World world, BlockPos origin, int cubeSize, BlockStateCheck match) {
        BlockArray out = new BlockArray();
        BlockPos.PooledMutableBlockPos offset = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int xx = -cubeSize; xx <= cubeSize; ++xx) {
            for (int zz = -cubeSize; zz <= cubeSize; ++zz) {
                for (int yy = -cubeSize; yy <= cubeSize; ++yy) {
                    offset.func_181079_c(origin.func_177958_n() + xx, origin.func_177956_o() + yy, origin.func_177952_p() + zz);
                    IBlockState atState = world.func_180495_p((BlockPos)offset);
                    if (!match.isStateValid(world, (BlockPos)offset, atState)) continue;
                    out.addBlock(new BlockPos((Vec3i)offset), atState);
                }
            }
        }
        offset.func_185344_t();
        return out;
    }

    public static BlockArray discoverBlocksWithSameStateAroundLimited(Map<IBlockState, Integer> stateLimits, World world, BlockPos origin, boolean onlyExposed, int cubeSize, int limit, boolean searchCorners) {
        IBlockState testState = world.func_180495_p(origin);
        BlockArray foundResult = new BlockArray();
        foundResult.addBlock(origin, testState);
        LinkedList<BlockPos> visited = new LinkedList<BlockPos>();
        LinkedList<BlockPos> searchNext = new LinkedList<BlockPos>();
        searchNext.addFirst(origin);
        while (!searchNext.isEmpty()) {
            LinkedList<BlockPos> currentSearch = searchNext;
            searchNext = new LinkedList();
            for (BlockPos offsetPos : currentSearch) {
                if (searchCorners) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int yy = -1; yy <= 1; ++yy) {
                            for (int zz = -1; zz <= 1; ++zz) {
                                IBlockState current;
                                BlockPos search = offsetPos.func_177982_a(xx, yy, zz);
                                if (visited.contains(search) || BlockDiscoverer.getCubeDistance(search, origin) > cubeSize || limit != -1 && foundResult.pattern.size() + 1 > limit) continue;
                                visited.add(search);
                                if (onlyExposed && !BlockDiscoverer.isExposedToAir(world, search) || !MiscUtils.matchStateExact(current = world.func_180495_p(search), testState)) continue;
                                foundResult.addBlock(search, current);
                                searchNext.add(search);
                            }
                        }
                    }
                    continue;
                }
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    IBlockState current;
                    BlockPos search = offsetPos.func_177972_a(face);
                    if (visited.contains(search) || BlockDiscoverer.getCubeDistance(search, origin) > cubeSize || limit != -1 && foundResult.pattern.size() + 1 > limit) continue;
                    visited.add(search);
                    if (onlyExposed && !BlockDiscoverer.isExposedToAir(world, search) || !MiscUtils.matchStateExact(current = world.func_180495_p(search), testState)) continue;
                    foundResult.addBlock(search, current);
                    searchNext.add(search);
                }
            }
        }
        return foundResult;
    }

    public static BlockArray discoverBlocksWithSameStateAround(List<IBlockState> states, World world, BlockPos origin, boolean onlyExposed, int cubeSize, int limit, boolean searchCorners) {
        BlockArray foundResult = new BlockArray();
        foundResult.addBlock(origin, world.func_180495_p(origin));
        LinkedList<BlockPos> visited = new LinkedList<BlockPos>();
        LinkedList<BlockPos> searchNext = new LinkedList<BlockPos>();
        searchNext.addFirst(origin);
        while (!searchNext.isEmpty()) {
            LinkedList<BlockPos> currentSearch = searchNext;
            searchNext = new LinkedList();
            for (BlockPos offsetPos : currentSearch) {
                if (searchCorners) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int yy = -1; yy <= 1; ++yy) {
                            for (int zz = -1; zz <= 1; ++zz) {
                                IBlockState current;
                                BlockPos search = offsetPos.func_177982_a(xx, yy, zz);
                                if (visited.contains(search) || BlockDiscoverer.getCubeDistance(search, origin) > cubeSize || limit != -1 && foundResult.pattern.size() + 1 > limit) continue;
                                visited.add(search);
                                if (onlyExposed && !BlockDiscoverer.isExposedToAir(world, search) || MiscUtils.getMatchingState(states, current = world.func_180495_p(search)) == null) continue;
                                foundResult.addBlock(search, current);
                                searchNext.add(search);
                            }
                        }
                    }
                    continue;
                }
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    IBlockState current;
                    BlockPos search = offsetPos.func_177972_a(face);
                    if (visited.contains(search) || BlockDiscoverer.getCubeDistance(search, origin) > cubeSize || limit != -1 && foundResult.pattern.size() + 1 > limit) continue;
                    visited.add(search);
                    if (onlyExposed && !BlockDiscoverer.isExposedToAir(world, search) || MiscUtils.getMatchingState(states, current = world.func_180495_p(search)) == null) continue;
                    foundResult.addBlock(search, current);
                    searchNext.add(search);
                }
            }
        }
        return foundResult;
    }

    public static BlockArray discoverBlocksWithSameStateAround(World world, BlockPos origin, boolean onlyExposed, int cubeSize, int limit, boolean searchCorners) {
        IBlockState toMatch = world.func_180495_p(origin);
        return BlockDiscoverer.discoverBlocksWithSameStateAround(Lists.newArrayList((Object[])new IBlockState[]{toMatch}), world, origin, onlyExposed, cubeSize, limit, searchCorners);
    }

    public static int getCubeDistance(BlockPos p1, BlockPos p2) {
        return (int)MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(p1.func_177958_n() - p2.func_177958_n()), (double)(p1.func_177956_o() - p2.func_177956_o())), (double)(p1.func_177952_p() - p2.func_177952_p()));
    }

    public static boolean isExposedToAir(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos offset = pos.func_177972_a(face);
            if (!world.func_175623_d(offset) && !world.func_180495_p(offset).func_177230_c().func_176200_f((IBlockAccess)world, offset)) continue;
            return true;
        }
        return false;
    }
}

