/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.base.Predicate;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityUtils {
    private static final Method getLootTableMethod;

    public static boolean canEntitySpawnHere(World world, BlockPos at, ResourceLocation entityKey, boolean respectConditions) {
        Event.Result canSpawn;
        Entity entity = EntityList.func_188429_b((ResourceLocation)entityKey, (World)world);
        if (entity == null) {
            return false;
        }
        entity.func_70012_b((double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (respectConditions && entity instanceof EntityLiving && (canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)((EntityLiving)entity), (World)world, (float)((float)at.func_177958_n() + 0.5f), (float)((float)at.func_177956_o() + 0.5f), (float)((float)at.func_177952_p() + 0.5f), null)) != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !((EntityLiving)entity).func_70601_bi() || !((EntityLiving)entity).func_70058_J())) {
            return false;
        }
        return EntityUtils.doesEntityHaveSpace(world, entity);
    }

    public static boolean doesEntityHaveSpace(World world, Entity entity) {
        return !world.func_72953_d(entity.func_174813_aQ()) && world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && world.func_72917_a(entity.func_174813_aQ(), entity);
    }

    public static void applyVortexMotion(Function<Void, Vector3> getPositionFunction, Function<Vector3, Object> addMotionFunction, Vector3 to, double vortexRange, double multiplier) {
        double diffZ;
        double diffY;
        Vector3 pos = getPositionFunction.apply(null);
        double diffX = (to.getX() - pos.getX()) / vortexRange;
        double dist = Math.sqrt(diffX * diffX + (diffY = (to.getY() - pos.getY()) / vortexRange) * diffY + (diffZ = (to.getZ() - pos.getZ()) / vortexRange) * diffZ);
        if (1.0 - dist > 0.0) {
            double dstFactorSq = (1.0 - dist) * (1.0 - dist);
            Vector3 toAdd = new Vector3();
            toAdd.setX(diffX / dist * dstFactorSq * 0.15 * multiplier);
            toAdd.setY(diffY / dist * dstFactorSq * 0.15 * multiplier);
            toAdd.setZ(diffZ / dist * dstFactorSq * 0.15 * multiplier);
            addMotionFunction.apply(toAdd);
        }
    }

    public static Predicate<? super Entity> selectEntities(Class<? extends Entity> ... entities) {
        return entity -> {
            if (entity == null || entity.field_70128_L) {
                return false;
            }
            Class<?> clazz = entity.getClass();
            for (Class test : entities) {
                if (!test.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<? super Entity> selectItemClassInstaceof(Class<?> itemClass) {
        return entity -> {
            if (entity == null || entity.field_70128_L) {
                return false;
            }
            if (!(entity instanceof EntityItem)) {
                return false;
            }
            ItemStack i = ((EntityItem)entity).func_92059_d();
            if (i.func_190926_b()) {
                return false;
            }
            return itemClass.isAssignableFrom(i.func_77973_b().getClass());
        };
    }

    public static Predicate<? super Entity> selectItem(Item item) {
        return entity -> {
            if (entity == null || entity.field_70128_L) {
                return false;
            }
            if (!(entity instanceof EntityItem)) {
                return false;
            }
            ItemStack i = ((EntityItem)entity).func_92059_d();
            if (i.func_190926_b()) {
                return false;
            }
            return i.func_77973_b().equals(item);
        };
    }

    public static Predicate<? super Entity> selectItemStack(Function<ItemStack, Boolean> acceptor) {
        return entity -> {
            if (entity == null || entity.field_70128_L) {
                return false;
            }
            if (!(entity instanceof EntityItem)) {
                return false;
            }
            ItemStack i = ((EntityItem)entity).func_92059_d();
            if (i.func_190926_b()) {
                return false;
            }
            return (Boolean)acceptor.apply(i);
        };
    }

    @Nullable
    public static <T> T selectClosest(Collection<T> elements, Function<T, Double> dstFunc) {
        if (elements.isEmpty()) {
            return null;
        }
        double dstClosest = Double.MAX_VALUE;
        T closestElement = null;
        for (T element : elements) {
            double dst = dstFunc.apply(element);
            if (!(dst < dstClosest)) continue;
            closestElement = element;
            dstClosest = dst;
        }
        return closestElement;
    }

    @Nullable
    public static LootTable getLootTable(EntityLiving entity) {
        if (getLootTableMethod == null) {
            return null;
        }
        try {
            ResourceLocation lootTable = (ResourceLocation)getLootTableMethod.invoke((Object)entity, new Object[0]);
            return entity.field_70170_p.func_184146_ak().func_186521_a(lootTable);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Method m = null;
        try {
            m = ReflectionHelper.findMethod(EntityLiving.class, (String)"getLootTable", (String)"func_184647_J", (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getLootTableMethod = m;
    }
}

