/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.auxiliary.StorageNetworkHandler;
import hellfirepvp.astralsorcery.common.tile.IStorageNetworkTile;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;

public class TileStorageCore
extends TileEntityTick
implements IStorageNetworkTile {
    private Map<StorageKey, StorageCache> contents = new HashMap<StorageKey, StorageCache>();
    private TileStorageCore masterCore = null;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    public void onLoad() {
        super.onLoad();
        StorageNetworkHandler.getHandler(this.func_145831_w()).addCore(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        StorageNetworkHandler.getHandler(this.func_145831_w()).removeCore(this);
    }

    @Override
    protected void onFirstTick() {
    }

    public TileStorageCore getAssociatedCore() {
        return this;
    }

    private void checkMasterIntegrity() {
    }

    public void fillAndDiscardItemOwnership(TileStorageCore newMaster, StorageNetworkHandler.MappingChange out) {
    }

    public boolean tryStoreItemInto(IItemHandler inv, StorageKey key) {
        StorageCache stored = this.getStorage(key);
        if (stored != null) {
            boolean transfer = stored.transferInto(inv);
            if (stored.content.isEmpty()) {
                this.contents.remove(key);
            }
            return transfer;
        }
        return false;
    }

    public void tryStoreItemInStorage(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        StorageKey key = new StorageKey(stack);
        StorageCache cache = this.getStorage(key);
        if (cache == null) {
            cache = new StorageCache();
            this.contents.put(key, cache);
        }
        cache.append(stack);
    }

    @Nullable
    public StorageCache getStorage(StorageKey key) {
        return this.contents.get(key);
    }

    @Override
    public void readSaveNBT(NBTTagCompound compound) {
        super.readSaveNBT(compound);
        this.contents.clear();
        NBTTagList list = compound.func_150295_c("contents", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cmp = list.func_150305_b(i);
            NBTTagCompound keyTag = cmp.func_74775_l("key");
            StorageKey key = StorageKey.deserialize(keyTag);
            if (key == null) continue;
            StorageCache cache = new StorageCache();
            NBTTagList cacheContent = cmp.func_150295_c("cache", 10);
            for (int j = 0; j < cacheContent.func_74745_c(); ++j) {
                StoredItemStack stack = StoredItemStack.deserialize(cacheContent.func_150305_b(j));
                if (stack == null || !stack.isValid()) continue;
                cache.content.add(stack);
            }
            if (cache.content.isEmpty()) continue;
            this.contents.put(key, cache);
        }
    }

    @Override
    public void writeSaveNBT(NBTTagCompound compound) {
        super.writeSaveNBT(compound);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<StorageKey, StorageCache> entry : this.contents.entrySet()) {
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74782_a("key", (NBTBase)entry.getKey().serialize());
            NBTTagList cacheContents = new NBTTagList();
            StorageCache cache = entry.getValue();
            for (StoredItemStack stack : cache.content) {
                if (!stack.isValid()) continue;
                cacheContents.func_74742_a((NBTBase)stack.serialize());
            }
            cmp.func_74782_a("cache", (NBTBase)cacheContents);
            list.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("contents", (NBTBase)list);
    }

    public static class StorageKey {
        @Nonnull
        private final Item item;
        private final int metadata;

        public StorageKey(@Nonnull ItemStack stack) {
            this.item = stack.func_77973_b();
            this.metadata = this.item.func_77645_m() ? 0 : stack.func_77960_j();
        }

        private StorageKey(@Nonnull Item item, int metadata) {
            this.item = item;
            this.metadata = metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StorageKey that = (StorageKey)o;
            return this.metadata == that.metadata && this.item.getRegistryName().equals((Object)that.item.getRegistryName());
        }

        public int hashCode() {
            int result = this.item.hashCode();
            result = 31 * result + this.metadata;
            return result;
        }

        private NBTTagCompound serialize() {
            NBTTagCompound keyTag = new NBTTagCompound();
            keyTag.func_74778_a("name", this.item.getRegistryName().toString());
            keyTag.func_74768_a("meta", this.metadata);
            return keyTag;
        }

        @Nullable
        static StorageKey deserialize(NBTTagCompound nbt) {
            ResourceLocation rl = new ResourceLocation(nbt.func_74779_i("name"));
            Item i = (Item)ForgeRegistries.ITEMS.getValue(rl);
            if (i == null || i == Items.field_190931_a) {
                return null;
            }
            int meta = nbt.func_74762_e("meta");
            return new StorageKey(i, meta);
        }
    }

    public static class StoredItemStack {
        private ItemStack stack;
        private int amount;

        StoredItemStack(ItemStack stack) {
            this(stack, stack.func_190916_E());
        }

        StoredItemStack(ItemStack stack, int amount) {
            this.stack = ItemUtils.copyStackWithSize(stack, 1);
            this.amount = amount;
        }

        private ItemStack getSample() {
            return ItemUtils.copyStackWithSize(this.stack, Math.min(this.stack.func_77976_d(), this.amount));
        }

        private boolean isValid() {
            return this.amount > 0;
        }

        private NBTTagCompound serialize() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("item", (NBTBase)this.stack.serializeNBT());
            tag.func_74768_a("amount", this.amount);
            return tag;
        }

        @Nullable
        static StoredItemStack deserialize(NBTTagCompound cmp) {
            ItemStack stack = new ItemStack(cmp.func_74775_l("item"));
            if (stack.func_190926_b()) {
                return null;
            }
            int amount = cmp.func_74762_e("amount");
            return new StoredItemStack(stack, amount);
        }
    }

    public static class StorageCache {
        private LinkedList<StoredItemStack> content = new LinkedList();

        public int getAmount() {
            int i = 0;
            for (StoredItemStack s : this.content) {
                i += s.amount;
            }
            return i;
        }

        private void append(ItemStack stack) {
            for (StoredItemStack s : this.content) {
                if (!this.combine(stack, s)) continue;
                return;
            }
            this.content.add(new StoredItemStack(stack));
        }

        private void mergeIntoThis(StorageCache source) {
            for (StoredItemStack stack : source.content) {
                StoredItemStack thisStack;
                Iterator iterator = this.content.iterator();
                while (iterator.hasNext() && !this.combineStorage(stack, thisStack = (StoredItemStack)iterator.next())) {
                }
            }
        }

        private boolean combineStorage(StoredItemStack incomingStack, StoredItemStack other) {
            ItemStack typeContained = other.stack;
            ItemStack incomingType = incomingStack.stack;
            if (incomingType.func_77973_b() != typeContained.func_77973_b()) {
                return false;
            }
            if (typeContained.func_77942_o() ^ incomingType.func_77942_o()) {
                return false;
            }
            if (typeContained.func_77942_o() && !typeContained.func_77978_p().equals((Object)incomingType.func_77978_p())) {
                return false;
            }
            if (typeContained.func_77973_b().func_77614_k() && typeContained.func_77960_j() != incomingType.func_77960_j()) {
                return false;
            }
            if (!incomingType.areCapsCompatible(typeContained)) {
                return false;
            }
            StoredItemStack storedItemStack = other;
            storedItemStack.amount = storedItemStack.amount + incomingStack.amount;
            return true;
        }

        private boolean combine(ItemStack incomingStack, StoredItemStack other) {
            ItemStack typeContained = other.stack;
            if (incomingStack.func_77973_b() != typeContained.func_77973_b()) {
                return false;
            }
            if (typeContained.func_77942_o() ^ incomingStack.func_77942_o()) {
                return false;
            }
            if (typeContained.func_77942_o() && !typeContained.func_77978_p().equals((Object)incomingStack.func_77978_p())) {
                return false;
            }
            if (typeContained.func_77973_b().func_77614_k() && typeContained.func_77960_j() != incomingStack.func_77960_j()) {
                return false;
            }
            if (!incomingStack.areCapsCompatible(typeContained)) {
                return false;
            }
            StoredItemStack storedItemStack = other;
            storedItemStack.amount = storedItemStack.amount + incomingStack.func_190916_E();
            return true;
        }

        private boolean transferInto(IItemHandler inv) {
            if (this.content.isEmpty()) {
                return false;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                for (StoredItemStack store : this.content) {
                    ItemStack sample = store.getSample();
                    ItemStack notInserted = inv.insertItem(i, sample, true);
                    if (notInserted.func_190926_b()) continue;
                    ItemStack added = inv.insertItem(i, sample, false);
                    StoredItemStack storedItemStack = store;
                    storedItemStack.amount = storedItemStack.amount - (sample.func_190916_E() - added.func_190916_E());
                    if (!store.isValid()) {
                        this.content.remove(store);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

