/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFloatingCube;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.base.LiquidInteraction;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.entities.EntityLiquidSpark;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.ILiquidStarlightPowered;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.block.SimpleSingleFluidCapabilityTank;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileChalice
extends TileEntityTick
implements ILiquidStarlightPowered {
    private static final int TANK_SIZE = 24000;
    private SimpleSingleFluidCapabilityTank tank;
    public Vector3 rotationDegreeAxis = new Vector3();
    public Vector3 prevRotationDegreeAxis = new Vector3();
    private Vector3 rotationVecAxis1 = null;
    private Vector3 rotationVecAxis2 = null;
    private Vector3 rotationVec = null;
    private int nextTest = -1;

    public TileChalice() {
        this.tank = new SimpleSingleFluidCapabilityTank(24000, EnumFacing.DOWN);
        this.tank.setOnUpdate(this::markForUpdate);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.rotationVecAxis1 == null) {
                this.rotationVecAxis1 = Vector3.random().multiply(360);
            }
            if (this.rotationVecAxis2 == null) {
                this.rotationVecAxis2 = Vector3.random().multiply(360);
            }
            if (this.rotationVec == null) {
                this.rotationVec = Vector3.random().normalize().multiply(1.5f);
            }
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
            this.rotationDegreeAxis.add(this.rotationVec);
            this.playFluidEffect();
        } else {
            if (this.field_145850_b.func_175687_A(this.func_174877_v()) > 0) {
                return;
            }
            if (this.nextTest == -1) {
                this.nextTest = this.ticksExisted + 40 + rand.nextInt(90);
            }
            if (this.ticksExisted >= this.nextTest) {
                this.nextTest = this.ticksExisted + 40 + rand.nextInt(90);
                if (this.getTank().getFluid() == null || this.getTank().getFluid().amount <= 0) {
                    return;
                }
                List<LiquidInteraction> interactions = LiquidInteraction.getPossibleInteractions(this.tank.getFluid());
                if (!interactions.isEmpty()) {
                    List<TileChalice> tch = this.collectChalicesFlat();
                    Collections.shuffle(tch);
                    for (TileChalice ch : tch) {
                        FluidStack otherC;
                        LiquidInteraction exec;
                        RaytraceAssist rta;
                        TileChalice other;
                        if (ch.func_174877_v().equals((Object)this.func_174877_v()) || this.field_145850_b.func_175687_A(ch.field_174879_c) > 0 || (other = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, ch.field_174879_c, TileChalice.class, true)) == null) continue;
                        Vector3 vector3 = new Vector3(this);
                        if (!(vector3.distance((Vec3i)ch.func_174877_v()) <= (double)ConfigEntryChalice.chaliceRange) || !(rta = new RaytraceAssist(this.func_174877_v(), ch.func_174877_v())).isClear(this.field_145850_b) || (exec = LiquidInteraction.getMatchingInteraction(interactions, otherC = other.getTank().getFluid())) == null || !exec.drainComponents(this, other)) continue;
                        EntityLiquidSpark els1 = new EntityLiquidSpark(this.field_145850_b, this.field_174879_c, exec);
                        EntityLiquidSpark els2 = new EntityLiquidSpark(this.field_145850_b, ch.func_174877_v(), exec);
                        els1.setTarget(els2);
                        els1.setFluidRepresented(exec.getComponent1());
                        els2.setTarget(els1);
                        els2.setFluidRepresented(exec.getComponent2());
                        this.field_145850_b.func_72838_d((Entity)els1);
                        this.field_145850_b.func_72838_d((Entity)els2);
                        this.markForUpdate();
                        other.markForUpdate();
                        break;
                    }
                }
            }
        }
    }

    private List<TileChalice> collectChalicesFlat() {
        int ceilRange = MathHelper.func_76123_f((float)ConfigEntryChalice.chaliceRange);
        BlockPos min = this.field_174879_c.func_177982_a(-ceilRange, -ceilRange, -ceilRange);
        BlockPos max = this.field_174879_c.func_177982_a(ceilRange, ceilRange, ceilRange);
        ChunkPos chMin = new ChunkPos(min);
        ChunkPos chMax = new ChunkPos(max);
        LinkedList<TileChalice> out = new LinkedList<TileChalice>();
        for (int xx = chMin.field_77276_a; xx <= chMax.field_77276_a; ++xx) {
            for (int zz = chMin.field_77275_b; zz < chMax.field_77275_b; ++zz) {
                if (!this.field_145850_b.func_175667_e(new BlockPos(xx << 4, 0, zz << 4))) continue;
                Chunk loaded = this.field_145850_b.func_72964_e(xx, zz);
                for (TileEntity te : loaded.func_177434_r().values()) {
                    if (!(te instanceof TileChalice) || te.func_145837_r()) continue;
                    out.add((TileChalice)te);
                }
            }
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    private void playFluidEffect() {
        EntityFXFloatingCube cube;
        FluidStack fs = this.getTank().getFluid();
        if (fs == null || fs.getFluid() == null) {
            return;
        }
        TextureAtlasSprite tas = RenderingUtils.tryGetFlowingTextureOfFluidStack(fs);
        if (rand.nextInt(2 * (DrawSize.values().length - this.getDrawSize().ordinal()) * 4) == 0) {
            Vector3 at = new Vector3(this).add(0.5, 1.4, 0.5);
            at.add((double)((float)this.getDrawSize().ordinal() * rand.nextFloat()) * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)((float)this.getDrawSize().ordinal() * rand.nextFloat()) * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)((float)this.getDrawSize().ordinal() * rand.nextFloat()) * 0.1 * (double)(rand.nextBoolean() ? 1 : -1));
            cube = RenderingUtils.spawnFloatingBlockCubeParticle(at, tas);
            cube.setBlendMode(null).setTextureSubSizePercentage(0.0625f).setMaxAge(20 + rand.nextInt(20));
            cube.setWorldLightCoord((World)Minecraft.func_71410_x().field_71441_e, at.toBlockPos());
            cube.setColorHandler(cb -> new Color(fs.getFluid().getColor(fs)));
            cube.setScale(0.08f * (float)(this.getDrawSize().ordinal() + 1)).tumble().setMotion(rand.nextFloat() * 0.005f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.005f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.005f * (float)(rand.nextBoolean() ? 1 : -1));
        }
        Vector3 perp = this.rotationVecAxis1.clone().perpendicular().normalize();
        perp.rotate(Math.toRadians(360.0 * ((double)ClientScheduler.getClientTick() % 140.0 / 140.0)), this.rotationVecAxis1);
        perp.add((Vec3i)this.func_174877_v()).add(0.5, 0.5, 0.5).addY(1.0);
        cube = RenderingUtils.spawnFloatingBlockCubeParticle(perp, tas);
        cube.setBlendMode(null).setTextureSubSizePercentage(0.0625f).setMaxAge(20 + rand.nextInt(20));
        cube.setWorldLightCoord((World)Minecraft.func_71410_x().field_71441_e, perp.toBlockPos());
        cube.setColorHandler(cb -> new Color(fs.getFluid().getColor(fs)));
        cube.setScale(rand.nextFloat() * 0.1f + 0.2f).tumble().setMotion(rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1));
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(perp);
        p.setColor(Color.WHITE).scale(0.1f + rand.nextFloat() * 0.05f).setMaxAge(15 + rand.nextInt(10));
        if (rand.nextInt(5) == 0) {
            p = EffectHelper.genericFlareParticle(perp);
            p.setColor(Color.WHITE).scale(0.1f + rand.nextFloat() * 0.1f).setMaxAge(20 + rand.nextInt(20));
            p.motion((double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1));
        }
        if (this.getDrawSize().ordinal() > 1) {
            perp = this.rotationVecAxis2.clone().perpendicular().normalize();
            perp.rotate(Math.toRadians(360.0 * ((double)ClientScheduler.getClientTick() % 170.0 / 170.0)), this.rotationVecAxis2);
            perp.add((Vec3i)this.func_174877_v()).add(0.5, 0.5, 0.5).addY(1.0);
            cube = RenderingUtils.spawnFloatingBlockCubeParticle(perp, tas);
            cube.setBlendMode(null).setTextureSubSizePercentage(0.0625f).setMaxAge(20 + rand.nextInt(20));
            cube.setWorldLightCoord((World)Minecraft.func_71410_x().field_71441_e, perp.toBlockPos());
            cube.setColorHandler(cb -> new Color(fs.getFluid().getColor(fs)));
            cube.setScale(rand.nextFloat() * 0.1f + 0.2f).tumble().setMotion(rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1));
            p = EffectHelper.genericFlareParticle(perp);
            p.setColor(Color.WHITE).scale(0.05f + rand.nextFloat() * 0.05f).setMaxAge(15 + rand.nextInt(5));
            if (rand.nextInt(5) == 0) {
                p = EffectHelper.genericFlareParticle(perp);
                p.setColor(Color.WHITE).scale(0.1f + rand.nextFloat() * 0.1f).setMaxAge(20 + rand.nextInt(20));
                p.motion((double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.01 * (double)(rand.nextBoolean() ? 1 : -1));
            }
        }
    }

    public SimpleSingleFluidCapabilityTank getTank() {
        return this.tank;
    }

    @Override
    public boolean canAcceptStarlight(int mbLiquidStarlight) {
        return this.getHeldFluid() == null || this.getFluidAmount() <= 0 || this.getHeldFluid() == BlocksAS.fluidLiquidStarlight && this.getFluidAmount() + mbLiquidStarlight <= 24000;
    }

    @Override
    public void acceptStarlight(int mbLiquidStarlight) {
        if (this.canAcceptStarlight(mbLiquidStarlight)) {
            this.getTank().fill(new FluidStack(BlocksAS.fluidLiquidStarlight, mbLiquidStarlight), true);
            this.markForUpdate();
        }
    }

    @Override
    protected void onFirstTick() {
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    @Nullable
    public Fluid getHeldFluid() {
        return this.tank.getTankFluid();
    }

    public float getPercFilled() {
        return this.tank.getPercentageFilled();
    }

    public DrawSize getDrawSize() {
        float perc = this.getPercFilled();
        if ((double)perc >= 0.75) {
            return DrawSize.FULL;
        }
        if ((double)perc >= 0.5) {
            return DrawSize.BIG;
        }
        if ((double)perc >= 0.25) {
            return DrawSize.MEDIUM;
        }
        return DrawSize.SMALL;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeNBT());
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.tank = SimpleSingleFluidCapabilityTank.deserialize(compound.func_74775_l("tank"));
        if (!this.tank.hasCapability(EnumFacing.DOWN)) {
            this.tank.accessibleSides.add(EnumFacing.DOWN);
        }
        this.tank.setOnUpdate(this::markForUpdate);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tank.hasCapability(facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || !this.hasCapability(capability, facing)) {
            return null;
        }
        return (T)this.tank.getCapability(facing);
    }

    public static class ConfigEntryChalice
    extends ConfigEntry {
        public static final ConfigEntryChalice instance = new ConfigEntryChalice();
        public static float chaliceRange = 16.0f;

        @Override
        public String getConfigurationSection() {
            return super.getConfigurationSection() + "." + this.getKey();
        }

        private ConfigEntryChalice() {
            super(ConfigEntry.Section.MACHINERY, "chalice");
        }

        @Override
        public void loadFromConfig(Configuration cfg) {
            chaliceRange = cfg.getFloat(this.getKey() + "Range", this.getConfigurationSection(), chaliceRange, 4.0f, 64.0f, "Defines the Range where the Chalice look for other chalices to interact with.");
        }
    }

    public static enum DrawSize {
        SMALL(1),
        MEDIUM(2),
        BIG(4),
        FULL(8);

        public final float partTexture;
        public final int mulSize;

        private DrawSize(int mulSize) {
            this.partTexture = (float)mulSize / 16.0f;
            this.mulSize = mulSize;
        }
    }
}

