/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalPropertiesAttunement;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingSprite;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.util.PositionedLoopSound;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.camera.ClientCameraFlightHelper;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerEntity;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemRockCrystalBase;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktAttuneConstellation;
import hellfirepvp.astralsorcery.common.network.packet.server.PktAttunementAltarState;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.TileAttunementRelay;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.struct.PatternBlockArray;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAttunementAltar
extends TileEntityTick
implements IMultiblockDependantTile {
    private static final Random rand = new Random();
    private static final Function<ItemStack, Boolean> crystalAcceptor = stack -> {
        if (!(stack.func_77973_b() instanceof ItemRockCrystalBase)) {
            return false;
        }
        if (stack.func_190916_E() != 1) {
            return false;
        }
        IWeakConstellation tuned = ItemTunedCrystalBase.getMainConstellation(stack);
        IMinorConstellation trait = ItemTunedCrystalBase.getTrait(stack);
        return tuned == null && trait == null;
    };
    private static final Function<ItemStack, Boolean> traitAcceptor = stack -> {
        if (!(stack.func_77973_b() instanceof ItemTunedCrystalBase)) {
            return false;
        }
        if (stack.func_190916_E() != 1) {
            return false;
        }
        IWeakConstellation tuned = ItemTunedCrystalBase.getMainConstellation(stack);
        IMinorConstellation trait = ItemTunedCrystalBase.getTrait(stack);
        return tuned != null && trait == null;
    };
    private static final int TICKS_PLAYER_ATTUNEMENT = 800;
    private static final int TICKS_CRYSTAL_ATTUNEMENT = 500;
    private IConstellation activeFound = null;
    private boolean doesSeeSky = false;
    private boolean hasMultiblock = false;
    private int mode = 0;
    private int serverSyncAttTick = 0;
    private int entityIdActive = -1;
    private Entity activeEntity = null;
    private int playerAttunementWaitTick = -1;
    private Map<BlockPos, Boolean> unloadCache = new HashMap<BlockPos, Boolean>();
    private Object activeSound = null;
    private List<Object> starSprites = new LinkedList<Object>();
    private IConstellation highlight = null;
    private int highlightActive = 0;
    private Object spriteCrystalAttunement = null;
    private int spawnedOrbitalsForCrystal = -1;
    public static final int MAX_START_ANIMATION_TICK = 60;
    public static final int MAX_START_ANIMATION_SPIN = 100;
    public int activationTick = 0;
    public int prevActivationTick = 0;
    public boolean animate = false;
    public boolean tesrLocked = true;
    private boolean cameraFlightActive = false;
    private Object clientActiveCameraFlight = null;

    @Override
    protected void onFirstTick() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void func_73660_a() {
        ItemStack tunedStack;
        block24: {
            block26: {
                block25: {
                    super.func_73660_a();
                    if (this.field_145850_b.field_72995_K) {
                        this.renderEffects();
                        return;
                    }
                    if (this.getTicksExisted() % 10 == 0) {
                        if (this.activeFound == null) {
                            this.searchForConstellation();
                        } else {
                            this.matchActiveConstellation();
                        }
                    }
                    if ((this.ticksExisted & 0xF) == 0) {
                        this.updateSkyState();
                    }
                    if ((this.ticksExisted & 0x1F) == 0) {
                        this.updateMultiblockState();
                    }
                    if (this.activeFound == null && this.getTicksExisted() % 10 == 0 && this.hasMultiblock) {
                        this.searchForConstellation();
                    }
                    if (this.activeFound == null) return;
                    if (this.mode != 0 && this.activeEntity == null) {
                        this.activeEntity = this.field_145850_b.func_73045_a(this.entityIdActive);
                        if (this.activeEntity == null) {
                            return;
                        }
                    }
                    if (this.mode == 0) {
                        if (!ConstellationSkyHandler.getInstance().isNight(this.field_145850_b)) return;
                        this.checkForAttunements();
                        return;
                    }
                    if (this.mode != 1) break block24;
                    if (!(this.activeEntity instanceof EntityPlayer) || this.activeEntity.field_70128_L) break block25;
                    Vector3 vector3 = new Vector3(this);
                    if (!(Vector3.atEntityCorner(this.activeEntity).distance(vector3) > 4.0)) break block26;
                }
                this.setAttunementState(0, null);
                return;
            }
            if (this.playerAttunementWaitTick > 0) {
                --this.playerAttunementWaitTick;
            }
            if (this.playerAttunementWaitTick == 0) {
                this.setAttunementState(0, null);
                this.playerAttunementWaitTick = -1;
            } else {
                ++this.serverSyncAttTick;
                if (EventHandlerEntity.invulnerabilityCooldown.contains((EntityPlayer)this.activeEntity)) {
                    EventHandlerEntity.invulnerabilityCooldown.setTimeout(10, (EntityPlayer)this.activeEntity);
                } else {
                    EventHandlerEntity.invulnerabilityCooldown.add(10, (EntityPlayer)this.activeEntity);
                }
            }
            this.markForUpdate();
            return;
        }
        if (this.mode != 2) return;
        if (this.activeEntity.field_70128_L || !(this.activeEntity instanceof EntityItem) || !EntityUtils.selectItemStack(crystalAcceptor).apply((Object)this.activeEntity) && !EntityUtils.selectItemStack(traitAcceptor).apply((Object)this.activeEntity) || !ConstellationSkyHandler.getInstance().isNight(this.field_145850_b)) {
            this.setAttunementState(0, null);
            return;
        }
        ++this.serverSyncAttTick;
        if (this.serverSyncAttTick % 4 == 0) {
            this.markForUpdate();
        }
        Vector3 crystalHoverPos = new Vector3(this).add(0.5, 1.4, 0.5);
        this.activeEntity.func_70107_b(crystalHoverPos.getX(), crystalHoverPos.getY(), crystalHoverPos.getZ());
        ((EntityItem)this.activeEntity).func_174873_u();
        if (this.serverSyncAttTick < 500) return;
        if (EntityUtils.selectItemStack(crystalAcceptor).apply((Object)this.activeEntity) && this.activeFound instanceof IWeakConstellation) {
            ItemStack current = ((EntityItem)this.activeEntity).func_92059_d();
            ItemTunedCrystalBase tuned = ((ItemRockCrystalBase)current.func_77973_b()).getTunedItemVariant();
            tunedStack = new ItemStack((Item)tuned);
            ItemTunedCrystalBase.applyMainConstellation(tunedStack, (IWeakConstellation)this.activeFound);
            CrystalProperties.applyCrystalProperties(tunedStack, CrystalProperties.getCrystalProperties(current));
        } else if (EntityUtils.selectItemStack(traitAcceptor).apply((Object)this.activeEntity) && this.activeFound instanceof IMinorConstellation) {
            tunedStack = ItemUtils.copyStackWithSize(((EntityItem)this.activeEntity).func_92059_d(), 1);
            ItemTunedCrystalBase.applyTrait(tunedStack, (IMinorConstellation)this.activeFound);
        } else {
            this.activeEntity.func_70106_y();
            this.setAttunementState(0, null);
            return;
        }
        this.activeEntity.func_70106_y();
        ItemUtils.dropItem(this.field_145850_b, crystalHoverPos.getX(), crystalHoverPos.getY(), crystalHoverPos.getZ(), tunedStack);
        this.setAttunementState(0, null);
        EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
        EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
        SoundHelper.playSoundAround((SoundEvent)Sounds.craftFinish, this.field_145850_b, (Vec3i)this.field_174879_c, 2.5f, 1.6f);
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        return MultiBlockArrays.patternAttunementFrame;
    }

    public int getMode() {
        return this.mode;
    }

    private void checkForAttunements() {
        List unfilteredItems;
        if ((this.ticksExisted & 0x1F) != 0) {
            return;
        }
        AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g(1.0).func_186670_a(this.func_174877_v());
        if (this.activeFound instanceof IMajorConstellation) {
            PlayerProgress prog;
            EntityPlayerMP pl;
            Vector3 thisVec = new Vector3(this).add(0.5, 0.5, 0.5);
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, box);
            if (!players.isEmpty() && (pl = EntityUtils.selectClosest(players, player -> thisVec.distanceSquared(player.func_174791_d()))) != null && !MiscUtils.isPlayerFakeMP(pl) && !pl.func_70093_af() && (prog = ResearchManager.getProgress((EntityPlayer)pl, Side.SERVER)) != null && prog.getAttunedConstellation() == null && prog.getResearchProgression().contains((Object)ResearchProgression.ATTUNEMENT) && prog.getKnownConstellations().contains(this.activeFound.getUnlocalizedName())) {
                PktAttunementAltarState state = new PktAttunementAltarState(pl.func_145782_y(), this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v());
                PacketChannel.CHANNEL.sendTo((IMessage)state, pl);
                return;
            }
        }
        if ((unfilteredItems = this.field_145850_b.func_72872_a(EntityItem.class, box)).size() == 1) {
            EntityItem item = (EntityItem)unfilteredItems.get(0);
            if (EntityUtils.selectItemStack(crystalAcceptor).apply((Object)item) && this.activeFound instanceof IWeakConstellation) {
                this.setAttunementState(2, (Entity)item);
            } else if (EntityUtils.selectItemStack(traitAcceptor).apply((Object)item) && this.activeFound instanceof IMinorConstellation) {
                this.setAttunementState(2, (Entity)item);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(3.5, 2.0, 3.5);
    }

    protected void updateSkyState() {
        boolean seesSky = true;
        BlockPos at = this.func_174877_v();
        block0: for (int xx = -7; xx <= 7; ++xx) {
            for (int zz = -7; zz <= 7; ++zz) {
                boolean see;
                BlockPos other = at.func_177982_a(xx, 0, zz);
                if (MiscUtils.isChunkLoaded(this.field_145850_b, new ChunkPos(other))) {
                    see = this.field_145850_b.func_175678_i(other);
                    this.unloadCache.put(other, see);
                    if (see) continue;
                    seesSky = false;
                    break block0;
                }
                if (this.unloadCache.containsKey(other)) {
                    if (this.unloadCache.get(other).booleanValue()) continue;
                    seesSky = false;
                    break block0;
                }
                see = this.field_145850_b.func_175678_i(other);
                this.unloadCache.put(other, see);
                if (see) continue;
                seesSky = false;
                break block0;
            }
        }
        boolean update = this.doesSeeSky != seesSky;
        this.doesSeeSky = seesSky;
        if (update) {
            this.markForUpdate();
        }
    }

    private void updateMultiblockState() {
        boolean found = MultiBlockArrays.patternAttunementFrame.matches(this.field_145850_b, this.func_174877_v());
        boolean update = this.hasMultiblock != found;
        this.hasMultiblock = found;
        if (update) {
            this.markForUpdate();
        }
    }

    private void matchActiveConstellation() {
        boolean valid = true;
        WorldSkyHandler wsh = ConstellationSkyHandler.getInstance().getWorldHandler(this.field_145850_b);
        if (wsh == null) {
            valid = false;
        } else if (!wsh.getActiveConstellations().contains(this.activeFound) || (double)wsh.getCurrentDistribution(this.activeFound, f -> f).floatValue() < 0.65) {
            valid = false;
        }
        List<BlockPos> positions = this.translateConstellationPositions(this.activeFound);
        for (BlockPos pos : positions) {
            ItemStack in;
            TileAttunementRelay tar;
            if (pos.equals((Object)this.func_174877_v())) continue;
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (!state.func_177230_c().equals((Object)BlocksAS.attunementRelay) && !state.func_177230_c().equals((Object)BlocksAS.attunementAltar)) {
                valid = false;
            }
            if (!state.func_177230_c().equals((Object)BlocksAS.attunementRelay) || (tar = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, pos, TileAttunementRelay.class, true)) == null || (in = tar.getInventoryHandler().getStackInSlot(0)).func_190926_b()) continue;
            ItemUtils.dropItemNaturally(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, in);
            tar.getInventoryHandler().setStackInSlot(0, ItemStack.field_190927_a);
        }
        if (!valid) {
            this.activeFound = null;
            this.markForUpdate();
        }
    }

    private void searchForConstellation() {
        WorldSkyHandler wsh = ConstellationSkyHandler.getInstance().getWorldHandler(this.field_145850_b);
        if (wsh == null) {
            return;
        }
        IConstellation match = null;
        for (IConstellation attuneable : ConstellationRegistry.getAllConstellations()) {
            List<BlockPos> positions = this.translateConstellationPositions(attuneable);
            boolean valid = true;
            for (BlockPos pos : positions) {
                IBlockState state;
                if (pos.equals((Object)this.func_174877_v()) || (state = this.field_145850_b.func_180495_p(pos)).func_177230_c().equals((Object)BlocksAS.attunementRelay) || state.func_177230_c().equals((Object)BlocksAS.attunementAltar)) continue;
                valid = false;
            }
            if (!valid) continue;
            match = attuneable;
            break;
        }
        if (match != null && wsh.getActiveConstellations().contains(match) && wsh.isActive(match)) {
            this.activeFound = match;
            this.markForUpdate();
        }
    }

    public void markPlayerStartCameraFlight(EntityPlayer pl) {
        if (this.mode == 0) {
            this.setAttunementState(1, (Entity)pl);
            pl.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            this.playerAttunementWaitTick = 1000;
        }
    }

    public void askForAttunement(EntityPlayerMP playerEntity, IMajorConstellation cst) {
        PlayerProgress prog;
        if (this.mode == 1 && this.playerAttunementWaitTick > 0 && this.activeEntity != null && playerEntity.equals((Object)this.activeEntity) && (prog = ResearchManager.getProgress((EntityPlayer)playerEntity, Side.SERVER)) != null && prog.getAttunedConstellation() == null && prog.getResearchProgression().contains((Object)ResearchProgression.ATTUNEMENT) && prog.getKnownConstellations().contains(cst.getUnlocalizedName())) {
            ResearchManager.setAttunedConstellation((EntityPlayer)playerEntity, cst);
            for (int i = 0; i < 6; ++i) {
                EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
            }
        }
        this.setAttunementState(0, null);
        this.playerAttunementWaitTick = -1;
    }

    private void setAttunementState(int mode, Entity trigger) {
        mode = MathHelper.func_76125_a((int)mode, (int)0, (int)2);
        this.serverSyncAttTick = 0;
        this.playerAttunementWaitTick = -1;
        this.mode = mode;
        switch (mode) {
            case 0: {
                this.entityIdActive = -1;
                this.activeEntity = null;
                break;
            }
            case 1: 
            case 2: {
                this.entityIdActive = trigger.func_145782_y();
                this.activeEntity = trigger;
            }
        }
        this.markForUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean tryStartCameraFlight() {
        if (this.cameraFlightActive || !this.isClientCloseEnough()) {
            return false;
        }
        Vector3 offset = new Vector3(this).add(0.0, 6.0, 0.0);
        ClientCameraFlightHelper.CameraFlightBuilder builder = ClientCameraFlightHelper.builder(offset.clone().add(4.0, 0.0, 4.0), new Vector3(this).add(0.5, 0.5, 0.5));
        builder.addCircularPoints(offset, ClientCameraFlightHelper.DynamicRadiusGetter.dyanmicIncrease(5.0, 0.025), 200, 2);
        builder.addCircularPoints(offset, ClientCameraFlightHelper.DynamicRadiusGetter.dyanmicIncrease(10.0, -0.01), 200, 2);
        builder.setTickDelegate(this.createFloatDelegate(new Vector3(this).add(0.5, 1.2f, 0.5)));
        builder.setStopDelegate(this.createAttunementDelegate());
        OrbitalPropertiesAttunement att = new OrbitalPropertiesAttunement(this, true);
        OrbitalEffectController ctrl = EffectHandler.getInstance().orbital(att, att, null);
        ctrl.setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOrbitRadius(3.0).setTicksPerRotation(80).setOffset(new Vector3(this).add(0.5, 0.5, 0.5));
        ctrl = EffectHandler.getInstance().orbital(att, att, null);
        ctrl.setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOrbitRadius(3.0).setTicksPerRotation(80).setTickOffset(40).setOffset(new Vector3(this).add(0.5, 0.5, 0.5));
        this.clientActiveCameraFlight = builder.finishAndStart();
        this.cameraFlightActive = true;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isClientCloseEnough() {
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g(1.0).func_186670_a(this.func_174877_v()));
        return !players.isEmpty() && players.contains(Minecraft.func_71410_x().field_71439_g);
    }

    private void checkClientEffectIntegrity() {
        if (this.clientActiveCameraFlight != null) {
            this.checkCameraClient();
        }
        if (this.spawnedOrbitalsForCrystal != this.entityIdActive) {
            this.spawnedOrbitalsForCrystal = -1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void checkCameraClient() {
        if (this.mode != 1 || this.entityIdActive != Minecraft.func_71410_x().field_71439_g.func_145782_y()) {
            ((ClientCameraFlightHelper.CameraFlight)this.clientActiveCameraFlight).forceStop();
            this.clientActiveCameraFlight = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderEffects() {
        EntityPlayerSP player;
        if (this.highlightActive > 0) {
            --this.highlightActive;
        }
        if (this.activeFound == null && (player = Minecraft.func_71410_x().field_71439_g) != null && player.func_174818_b(this.func_174877_v()) <= 250.0) {
            Object cst;
            IConstellation held = null;
            if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemConstellationPaper && (cst = ItemConstellationPaper.getConstellation(player.func_184614_ca())) != null) {
                held = cst;
            }
            if (held == null && !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemConstellationPaper && (cst = ItemConstellationPaper.getConstellation(player.func_184592_cb())) != null) {
                held = cst;
            }
            if (held != null && ResearchManager.clientProgress.hasConstellationDiscovered(held.getUnlocalizedName())) {
                this.highlightConstellation(held);
            }
        }
        if (this.mode != 2) {
            this.spriteCrystalAttunement = null;
        }
        if (!this.hasMultiblock || !this.doesSeeSky) {
            this.starSprites.clear();
            this.activeSound = null;
            this.animate = false;
            this.prevActivationTick = this.activationTick;
            if (this.activationTick > 0) {
                --this.activationTick;
            }
            if (this.clientActiveCameraFlight != null) {
                ((ClientCameraFlightHelper.CameraFlight)this.clientActiveCameraFlight).forceStop();
                this.clientActiveCameraFlight = null;
            }
        } else if (this.activeFound == null || !ConstellationSkyHandler.getInstance().isNight(this.field_145850_b)) {
            this.starSprites.clear();
            this.activeSound = null;
            this.animate = false;
            this.prevActivationTick = this.activationTick;
            if (this.activationTick > 0) {
                --this.activationTick;
            }
            if (this.clientActiveCameraFlight != null) {
                ((ClientCameraFlightHelper.CameraFlight)this.clientActiveCameraFlight).forceStop();
                this.clientActiveCameraFlight = null;
            }
            this.spawnAmbientParticles();
            if (this.highlight != null && this.highlightActive > 0) {
                float night = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e);
                List<BlockPos> positions = this.translateConstellationPositions(this.highlight);
                for (BlockPos pos : positions) {
                    if (rand.nextBoolean()) continue;
                    EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).gravity(0.01);
                    p.offset((double)rand.nextFloat() * 0.7 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.7 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.7 * (double)(rand.nextBoolean() ? 1 : -1));
                    p.scale(0.4f + rand.nextFloat() * 0.1f);
                    p.setAlphaMultiplier(0.5f * night);
                }
            }
        } else {
            if (Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) > 0.0f && (this.activeSound == null || ((PositionedLoopSound)((Object)this.activeSound)).hasStoppedPlaying())) {
                this.activeSound = SoundHelper.playSoundLoopClient(Sounds.attunement, new Vector3(this).add(0.5, 0.5, 0.5), 0.4f, 0.8f, () -> this.func_145837_r() || this.activeFound == null || !ConstellationSkyHandler.getInstance().isNight(this.field_145850_b) || Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) <= 0.0f);
            }
            if (this.mode == 1 && this.clientActiveCameraFlight == null) {
                this.playPlayerAttenuationEffects(this.serverSyncAttTick);
                ++this.serverSyncAttTick;
            }
            if (this.mode == 2 && this.entityIdActive != -1) {
                Entity e = this.field_145850_b.func_73045_a(this.entityIdActive);
                if (e != null && !e.field_70128_L && e instanceof EntityItem && (EntityUtils.selectItemStack(crystalAcceptor).apply((Object)e) || EntityUtils.selectItemStack(traitAcceptor).apply((Object)e))) {
                    Vector3 crystalHoverPos = new Vector3(this).add(0.5, 1.4, 0.5);
                    e.func_70107_b(crystalHoverPos.getX(), crystalHoverPos.getY(), crystalHoverPos.getZ());
                    e.func_70016_h(0.0, 0.0, 0.0);
                    this.playCrystalAttenuationEffects(this.serverSyncAttTick);
                    ++this.serverSyncAttTick;
                } else if (this.spriteCrystalAttunement != null) {
                    this.spriteCrystalAttunement = null;
                }
            }
            this.animate = true;
            this.prevActivationTick = this.activationTick;
            if (this.activationTick < 60) {
                ++this.activationTick;
            }
            for (Object o : this.starSprites) {
                EntityFXFacingSprite p = (EntityFXFacingSprite)o;
                if (!p.isRemoved()) continue;
                EffectHandler.getInstance().registerFX(p);
            }
            if (this.starSprites.isEmpty()) {
                this.addStarSprites();
            }
            if (this.getTicksExisted() % 53 == 0) {
                this.addConnectionBeams();
            }
            this.spawnAmbientParticles();
            this.spawnAmbientActiveParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private ClientCameraFlightHelper.StopDelegate createAttunementDelegate() {
        return () -> {
            if (this.clientActiveCameraFlight != null && ((ClientCameraFlightHelper.CameraFlight)this.clientActiveCameraFlight).isExpired() && !((ClientCameraFlightHelper.CameraFlight)this.clientActiveCameraFlight).wasForciblyStopped() && this.activeFound != null) {
                PacketChannel.CHANNEL.sendToServer((IMessage)new PktAttuneConstellation((IMajorConstellation)this.activeFound, this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v()));
                SoundHelper.playSoundClientWorld(Sounds.craftFinish, this.field_174879_c, 1.0f, 1.4f);
            }
            this.cameraFlightActive = false;
            this.clientActiveCameraFlight = null;
        };
    }

    @SideOnly(value=Side.CLIENT)
    private ClientCameraFlightHelper.TickDelegate createFloatDelegate(Vector3 offsetPos) {
        return (renderView, focusedEntity) -> {
            if (focusedEntity == null) {
                return;
            }
            float floatTick = (float)(ClientScheduler.getClientTick() % 40L) / 40.0f;
            float sin = MathHelper.func_76126_a((float)((float)((double)(floatTick * 2.0f) * Math.PI))) / 2.0f + 0.5f;
            focusedEntity.func_174805_g(false);
            focusedEntity.func_70080_a(offsetPos.getX(), offsetPos.getY() + (double)sin * 0.2, offsetPos.getZ(), 0.0f, 0.0f);
            focusedEntity.func_70080_a(offsetPos.getX(), offsetPos.getY() + (double)sin * 0.2, offsetPos.getZ(), 0.0f, 0.0f);
            focusedEntity.field_70759_as = 0.0f;
            focusedEntity.field_70758_at = 0.0f;
            focusedEntity.func_70016_h(0.0, 0.0, 0.0);
            this.playPlayerAttenuationEffects(renderView.field_70173_aa);
        };
    }

    @SideOnly(value=Side.CLIENT)
    private void playPlayerAttenuationEffects(int cameraFlightTick) {
        if (this.activeFound == null) {
            return;
        }
        if (cameraFlightTick >= 0 && cameraFlightTick <= 800 && cameraFlightTick % 30 == 0) {
            List<BlockPos> offsets = this.translateConstellationPositions(this.activeFound);
            Color ov = new Color(2162941);
            float cR = (float)ov.getRed() / 255.0f;
            float cG = (float)ov.getGreen() / 255.0f;
            float cB = (float)ov.getBlue() / 255.0f;
            for (BlockPos effectPos : offsets) {
                Vector3 from = new Vector3(effectPos).add(0.5, -0.1, 0.5);
                MiscUtils.applyRandomOffset(from, rand, 0.1f);
                EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(6.0), from, 1.5);
                lightbeam.setAlphaMultiplier(0.8f);
                lightbeam.setColorOverlay(cR, cG, cB, 0.2f);
                lightbeam.setMaxAge(64);
            }
        }
        if (cameraFlightTick >= 200) {
            for (int i = 0; i < 2; ++i) {
                List<BlockPos> offsets = this.translateConstellationPositions(this.activeFound);
                BlockPos pos = offsets.get(rand.nextInt(offsets.size()));
                Vector3 offset = new Vector3((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
                Vector3 dir = new Vector3(this).add(0.5, 3.0, 0.5).subtract(offset);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(offset.getX(), offset.getY(), offset.getZ());
                p.setColor(Color.WHITE).scale(0.3f + rand.nextFloat() * 0.1f).gravity(0.004).motion(dir.getX() / 40.0, dir.getY() / 40.0, dir.getZ() / 40.0);
            }
        }
        if (cameraFlightTick >= 350) {
            for (int i = 0; i < 3; ++i) {
                Vector3 from = new Vector3(this).add(0.5, 0.5, 0.5);
                from.addX(rand.nextFloat() * 6.0f * (float)(rand.nextBoolean() ? 1 : -1));
                from.addZ(rand.nextFloat() * 6.0f * (float)(rand.nextBoolean() ? 1 : -1));
                Vector3 dir = new Vector3(this).add(0.5, 3.0, 0.5).subtract(from);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(from.getX(), from.getY(), from.getZ());
                p.setColor(Color.WHITE).scale(0.3f + rand.nextFloat() * 0.1f).gravity(0.004).motion(dir.getX() / 40.0, dir.getY() / 40.0, dir.getZ() / 40.0);
            }
        }
        if (cameraFlightTick >= 500) {
            for (int i = 0; i < 4; ++i) {
                Vector3 at = new Vector3(this).add(0.5, 0.1, 0.5);
                at.addX(rand.nextFloat() * 7.0f * (float)(rand.nextBoolean() ? 1 : -1));
                at.addZ(rand.nextFloat() * 7.0f * (float)(rand.nextBoolean() ? 1 : -1));
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f);
                if (rand.nextBoolean()) {
                    p.setColor(Color.WHITE);
                }
                p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                p.gravity(0.05).scale(0.3f + rand.nextFloat() * 0.1f);
            }
        }
        if (cameraFlightTick >= 600 && cameraFlightTick % 5 == 0) {
            Vector3 from = new Vector3(this).add(0.5, -0.1, 0.5);
            MiscUtils.applyRandomOffset(from, rand, 0.3f);
            EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(8.0), from, 2.4f);
            lightbeam.setAlphaMultiplier(0.8f);
            lightbeam.setMaxAge(64);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playCrystalAttenuationEffects(int runTick) {
        Entity ee;
        if (this.activeFound == null) {
            return;
        }
        if (runTick >= 0 && runTick <= 500 && runTick % 30 == 0) {
            List<BlockPos> offsets = this.translateConstellationPositions(this.activeFound);
            Color ov = new Color(2162941);
            float cR = (float)ov.getRed() / 255.0f;
            float cG = (float)ov.getGreen() / 255.0f;
            float cB = (float)ov.getBlue() / 255.0f;
            for (BlockPos effectPos : offsets) {
                Vector3 from = new Vector3(effectPos).add(0.5, -0.1, 0.5);
                MiscUtils.applyRandomOffset(from, rand, 0.1f);
                EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(6.0), from, 1.5);
                lightbeam.setAlphaMultiplier(0.8f);
                lightbeam.setColorOverlay(cR, cG, cB, 0.2f);
                lightbeam.setMaxAge(64);
            }
        }
        if (runTick >= 0 && this.spawnedOrbitalsForCrystal == -1) {
            this.spawnedOrbitalsForCrystal = this.entityIdActive;
            OrbitalPropertiesAttunement attunement = new OrbitalPropertiesAttunement(this, false);
            attunement.setPersistanceRequests(3);
            OrbitalEffectController ctrl = EffectHandler.getInstance().orbital(attunement, attunement, null);
            ctrl.setTicksPerRotation(80).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOffset(new Vector3(this).add(0.5, 0.0, 0.5)).setOrbitRadius(2.0);
            attunement = new OrbitalPropertiesAttunement(this, false);
            attunement.setPersistanceRequests(3);
            ctrl = EffectHandler.getInstance().orbital(attunement, attunement, null);
            ctrl.setTicksPerRotation(80).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOffset(new Vector3(this).add(0.5, 0.0, 0.5)).setOrbitRadius(2.0);
            ctrl.setTickOffset(40);
            attunement = new OrbitalPropertiesAttunement(this, false);
            attunement.setPersistanceRequests(12);
            ctrl = EffectHandler.getInstance().orbital(attunement, attunement, null);
            ctrl.setTicksPerRotation(20).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOffset(new Vector3(this).add(0.5, 0.0, 0.5)).setOrbitRadius(1.0);
            attunement = new OrbitalPropertiesAttunement(this, false);
            attunement.setPersistanceRequests(2);
            ctrl = EffectHandler.getInstance().orbital(attunement, attunement, null);
            ctrl.setTicksPerRotation(120).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOffset(new Vector3(this).add(0.5, 0.0, 0.5)).setOrbitRadius(3.5);
            ctrl.setTickOffset(40);
            attunement = new OrbitalPropertiesAttunement(this, false);
            attunement.setPersistanceRequests(2);
            ctrl = EffectHandler.getInstance().orbital(attunement, attunement, null);
            ctrl.setTicksPerRotation(120).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOffset(new Vector3(this).add(0.5, 0.0, 0.5)).setOrbitRadius(3.5);
            ctrl.setTickOffset(100);
        }
        if (runTick >= 200) {
            for (int i = 0; i < 2; ++i) {
                List<BlockPos> offsets = this.translateConstellationPositions(this.activeFound);
                BlockPos pos = offsets.get(rand.nextInt(offsets.size()));
                Vector3 offset = new Vector3((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
                Vector3 dir = new Vector3(this).add(0.5, 1.7, 0.5).subtract(offset);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(offset.getX(), offset.getY(), offset.getZ());
                p.setColor(Color.WHITE).scale(0.3f + rand.nextFloat() * 0.1f).gravity(0.004).motion(dir.getX() / 40.0, dir.getY() / 40.0, dir.getZ() / 40.0);
            }
        }
        if (runTick >= 225 && this.spriteCrystalAttunement == null && (ee = this.field_145850_b.func_73045_a(this.entityIdActive)) != null) {
            Vector3 posV = Vector3.atEntityCorner(ee);
            EntityFXFacingSprite sprite = EntityFXFacingSprite.fromSpriteSheet(SpriteLibrary.spriteStar2, posV.getX(), posV.getY(), posV.getZ(), 2.5f, 2);
            EffectHandler.getInstance().registerFX(sprite);
            this.spriteCrystalAttunement = sprite;
            sprite.setRefreshFunc(() -> {
                if (this.func_145837_r() || this.mode != 2 || this.entityIdActive == -1) {
                    return false;
                }
                Entity ent = this.field_145850_b.func_73045_a(this.entityIdActive);
                return ent != null && !ent.field_70128_L && ent instanceof EntityItem && (EntityUtils.selectItemStack(crystalAcceptor).apply((Object)ent) || EntityUtils.selectItemStack(traitAcceptor).apply((Object)ent));
            });
            sprite.setPositionUpdateFunction((fx, v, m) -> {
                if (this.func_145837_r() || this.mode != 2 || this.entityIdActive == -1) {
                    return v;
                }
                Entity ent = this.field_145850_b.func_73045_a(this.entityIdActive);
                if (ent == null || ent.field_70128_L) {
                    return v;
                }
                return Vector3.atEntityCorner(ent).addY(ent.field_70131_O * 2.0f);
            });
        }
        if (runTick >= 250) {
            for (int i = 0; i < 3; ++i) {
                Vector3 from = new Vector3(this).add(0.5, 0.5, 0.5);
                from.addX(rand.nextFloat() * 6.5f * (float)(rand.nextBoolean() ? 1 : -1));
                from.addZ(rand.nextFloat() * 6.5f * (float)(rand.nextBoolean() ? 1 : -1));
                Vector3 dir = new Vector3(this).add(0.5, 1.7, 0.5).subtract(from);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(from.getX(), from.getY(), from.getZ());
                p.setColor(Color.WHITE).scale(0.3f + rand.nextFloat() * 0.1f).gravity(0.004).motion(dir.getX() / 40.0, dir.getY() / 40.0, dir.getZ() / 40.0);
            }
        }
        if (runTick >= 350 && runTick % 5 == 0) {
            Vector3 from = new Vector3(this).add(0.5, -0.1, 0.5);
            MiscUtils.applyRandomOffset(from, rand, 0.3f);
            EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(8.0), from, 2.4f);
            lightbeam.setAlphaMultiplier(0.8f);
            lightbeam.setMaxAge(64);
        }
        if (runTick >= 400) {
            for (int i = 0; i < 4; ++i) {
                Vector3 at = new Vector3(this).add(0.5, 0.1, 0.5);
                at.addX(rand.nextFloat() * 7.0f * (float)(rand.nextBoolean() ? 1 : -1));
                at.addZ(rand.nextFloat() * 7.0f * (float)(rand.nextBoolean() ? 1 : -1));
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f);
                if (rand.nextBoolean()) {
                    p.setColor(Color.WHITE);
                }
                p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                p.gravity(0.05).scale(0.3f + rand.nextFloat() * 0.1f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnAmbientActiveParticles() {
        if (rand.nextInt(3) == 0) {
            Vector3 at = new Vector3(this).add(0.0, 0.1, 0.0);
            at.add(rand.nextFloat() * 3.0f - 1.0f, 0.0, rand.nextFloat() * 3.0f - 1.0f);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
            p.setAlphaMultiplier(0.7f);
            p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
            p.gravity(0.05).scale(0.3f + rand.nextFloat() * 0.1f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnAmbientParticles() {
        if (rand.nextBoolean()) {
            Vector3 at = new Vector3(this).add(0.0, 0.01, 0.0);
            at.add(rand.nextFloat() * 15.0f - 7.0f, 0.0, rand.nextFloat() * 15.0f - 7.0f);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
            p.setAlphaMultiplier(0.7f);
            p.setColor(Color.WHITE);
            p.gravity(0.004).scale(0.3f + rand.nextFloat() * 0.1f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addConnectionBeams() {
        List<Tuple<BlockPos, BlockPos>> connectionTuples = this.translateConnectionPositions(this.activeFound);
        Color ov = new Color(2162941);
        float cR = (float)ov.getRed() / 255.0f;
        float cG = (float)ov.getGreen() / 255.0f;
        float cB = (float)ov.getBlue() / 255.0f;
        float alpha = 0.2f;
        for (Tuple<BlockPos, BlockPos> connection : connectionTuples) {
            Vector3 from = new Vector3((BlockPos)connection.key).add(0.5, 0.5, 0.5);
            Vector3 to = new Vector3((BlockPos)connection.value).add(0.5, 0.5, 0.5);
            EffectHandler.getInstance().lightbeam(from, to, 1.1).setColorOverlay(cR, cG, cB, alpha);
            EffectHandler.getInstance().lightbeam(to, from, 1.1).setColorOverlay(cR, cG, cB, alpha);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addStarSprites() {
        List<BlockPos> positions = this.translateConstellationPositions(this.activeFound);
        for (BlockPos pos : positions) {
            EntityFXFacingSprite sprite = EntityFXFacingSprite.fromSpriteSheet(SpriteLibrary.spriteStar1, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.55, (double)pos.func_177952_p() + 0.5, 1.5f, 2);
            EffectHandler.getInstance().registerFX(sprite);
            this.starSprites.add(sprite);
            sprite.setRefreshFunc(() -> this.starSprites.contains(sprite) && !this.func_145837_r());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void highlightConstellation(IConstellation highlight) {
        this.highlight = highlight;
        this.highlightActive = 4;
    }

    private List<Tuple<BlockPos, BlockPos>> translateConnectionPositions(IConstellation cst) {
        LinkedList<Tuple<BlockPos, BlockPos>> offsetPositions = new LinkedList<Tuple<BlockPos, BlockPos>>();
        for (StarConnection c : cst.getStarConnections()) {
            StarLocation from = c.from;
            StarLocation to = c.to;
            offsetPositions.add(new Tuple<BlockPos, BlockPos>(new BlockPos(from.x / 2 - 7, 0, from.y / 2 - 7).func_177971_a((Vec3i)this.func_174877_v()), new BlockPos(to.x / 2 - 7, 0, to.y / 2 - 7).func_177971_a((Vec3i)this.func_174877_v())));
        }
        return offsetPositions;
    }

    private List<BlockPos> translateConstellationPositions(IConstellation cst) {
        LinkedList<BlockPos> offsetPositions = new LinkedList<BlockPos>();
        for (StarLocation sl : cst.getStars()) {
            int x = sl.x / 2;
            int z = sl.y / 2;
            offsetPositions.add(new BlockPos(x - 7, 0, z - 7).func_177971_a((Vec3i)this.func_174877_v()));
        }
        return offsetPositions;
    }

    @Override
    public void readNetNBT(NBTTagCompound compound) {
        this.mode = compound.func_74762_e("modeId");
        this.entityIdActive = compound.func_74762_e("entityId");
        this.serverSyncAttTick = compound.func_74762_e("sSync");
        this.checkClientEffectIntegrity();
    }

    @Override
    public void writeNetNBT(NBTTagCompound compound) {
        compound.func_74768_a("modeId", this.mode);
        compound.func_74768_a("entityId", this.entityIdActive);
        compound.func_74768_a("sSync", this.serverSyncAttTick);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.hasMultiblock = compound.func_74767_n("mbState");
        this.doesSeeSky = compound.func_74767_n("skState");
        IConstellation prev = this.activeFound;
        IConstellation found = IConstellation.readFromNBT(compound);
        this.activeFound = found == null ? null : found;
        if (prev != this.activeFound) {
            this.starSprites.clear();
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("mbState", this.hasMultiblock);
        compound.func_74757_a("skState", this.doesSeeSky);
        if (this.activeFound != null) {
            this.activeFound.writeToNBT(compound);
        }
    }
}

