/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base;

import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class SimpleTransmissionReceiver
implements ITransmissionReceiver {
    private BlockPos thisPos;
    private Set<BlockPos> sourcesToThis = new HashSet<BlockPos>();

    public SimpleTransmissionReceiver(BlockPos thisPos) {
        this.thisPos = thisPos;
    }

    @Override
    public BlockPos getPos() {
        return this.thisPos;
    }

    @Override
    public void notifySourceLink(World world, BlockPos source) {
        if (!this.sourcesToThis.contains(source)) {
            this.sourcesToThis.add(source);
        }
    }

    @Override
    public void notifySourceUnlink(World world, BlockPos source) {
        this.sourcesToThis.remove(source);
    }

    @Override
    public boolean notifyBlockChange(World world, BlockPos changed) {
        return false;
    }

    @Override
    public List<BlockPos> getSources() {
        return this.sourcesToThis.stream().collect(Collectors.toCollection(LinkedList::new));
    }

    @Nullable
    public <T extends TileEntity> T getTileAtPos(World world, Class<T> tileClass) {
        return (T)((TileEntity)MiscUtils.getTileAt((IBlockAccess)world, this.getPos(), tileClass, false));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.thisPos = NBTHelper.readBlockPosFromNBT(compound);
        this.sourcesToThis.clear();
        NBTTagList list = compound.func_150295_c("sources", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.sourcesToThis.add(NBTHelper.readBlockPosFromNBT(list.func_150305_b(i)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTHelper.writeBlockPosToNBT(this.thisPos, compound);
        NBTTagList sources = new NBTTagList();
        for (BlockPos source : this.sourcesToThis) {
            NBTTagCompound comp = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(source, comp);
            sources.func_74742_a((NBTBase)comp);
        }
        compound.func_74782_a("sources", (NBTBase)sources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTransmissionReceiver that = (SimpleTransmissionReceiver)o;
        return !(this.thisPos == null ? that.thisPos != null : !this.thisPos.equals((Object)that.thisPos));
    }
}

