/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base;

import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SimplePrismTransmissionNode
implements IPrismTransmissionNode {
    private boolean ignoreBlockCollision = false;
    private Map<BlockPos, PrismNext> nextNodes = new HashMap<BlockPos, PrismNext>();
    private BlockPos thisPos;
    private Set<BlockPos> sourcesToThis = new HashSet<BlockPos>();

    public SimplePrismTransmissionNode(BlockPos thisPos) {
        this.thisPos = thisPos;
    }

    @Override
    public BlockPos getPos() {
        return this.thisPos;
    }

    public void updateIgnoreBlockCollisionState(World world, boolean ignoreBlockCollision) {
        this.ignoreBlockCollision = ignoreBlockCollision;
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(world);
        if (handle != null) {
            boolean anyChange = false;
            for (PrismNext next : this.nextNodes.values()) {
                boolean oldState = next.reachable;
                next.reachable = ignoreBlockCollision || next.rayAssist.isClear(world);
                if (next.reachable == oldState) continue;
                anyChange = true;
            }
            if (anyChange) {
                handle.notifyTransmissionNodeChange(this);
            }
        }
    }

    public boolean ignoresBlockCollision() {
        return this.ignoreBlockCollision;
    }

    @Override
    public boolean notifyUnlink(World world, BlockPos to) {
        return this.nextNodes.remove(to) != null;
    }

    @Override
    public void notifyLink(World world, BlockPos pos) {
        this.addLink(world, pos, true, false);
    }

    private void addLink(World world, BlockPos pos, boolean doRayCheck, boolean previousRayState) {
        PrismNext nextNode = new PrismNext(this, world, this.thisPos, pos, doRayCheck, previousRayState);
        this.nextNodes.put(pos, nextNode);
    }

    @Override
    public boolean notifyBlockChange(World world, BlockPos at) {
        boolean anyChange = false;
        for (PrismNext next : this.nextNodes.values()) {
            if (!next.notifyBlockPlace(world, this.thisPos, at)) continue;
            anyChange = true;
        }
        return anyChange;
    }

    @Override
    public void notifySourceLink(World world, BlockPos source) {
        if (!this.sourcesToThis.contains(source)) {
            this.sourcesToThis.add(source);
        }
    }

    @Override
    public void notifySourceUnlink(World world, BlockPos source) {
        this.sourcesToThis.remove(source);
    }

    @Override
    public List<NodeConnection<IPrismTransmissionNode>> queryNext(WorldNetworkHandler handler) {
        LinkedList<NodeConnection<IPrismTransmissionNode>> nodes = new LinkedList<NodeConnection<IPrismTransmissionNode>>();
        for (BlockPos pos : this.nextNodes.keySet()) {
            nodes.add(new NodeConnection<IPrismTransmissionNode>(handler.getTransmissionNode(pos), pos, this.nextNodes.get(pos).reachable));
        }
        return nodes;
    }

    @Override
    public List<BlockPos> getSources() {
        return this.sourcesToThis.stream().collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public TransmissionClassRegistry.TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.thisPos = NBTHelper.readBlockPosFromNBT(compound);
        this.sourcesToThis.clear();
        this.ignoreBlockCollision = compound.func_74767_n("ignoreBlockCollision");
        NBTTagList list = compound.func_150295_c("sources", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.sourcesToThis.add(NBTHelper.readBlockPosFromNBT(list.func_150305_b(i)));
        }
        NBTTagList nextList = compound.func_150295_c("nextList", 10);
        for (int i = 0; i < nextList.func_74745_c(); ++i) {
            NBTTagCompound tag = nextList.func_150305_b(i);
            BlockPos next = NBTHelper.readBlockPosFromNBT(tag);
            boolean oldState = tag.func_74767_n("rayState");
            this.addLink(null, next, false, oldState);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTHelper.writeBlockPosToNBT(this.thisPos, compound);
        compound.func_74757_a("ignoreBlockCollision", this.ignoreBlockCollision);
        NBTTagList sources = new NBTTagList();
        for (BlockPos source : this.sourcesToThis) {
            NBTTagCompound comp = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(source, comp);
            sources.func_74742_a((NBTBase)comp);
        }
        compound.func_74782_a("sources", (NBTBase)sources);
        NBTTagList nextList = new NBTTagList();
        for (BlockPos next : this.nextNodes.keySet()) {
            PrismNext prism = this.nextNodes.get(next);
            NBTTagCompound pos = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(next, pos);
            pos.func_74757_a("rayState", prism.reachable);
            nextList.func_74742_a((NBTBase)pos);
        }
        compound.func_74782_a("nextList", (NBTBase)nextList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePrismTransmissionNode that = (SimplePrismTransmissionNode)o;
        return !(this.thisPos == null ? that.thisPos != null : !this.thisPos.equals((Object)that.thisPos));
    }

    public int hashCode() {
        return this.thisPos != null ? this.thisPos.hashCode() : 0;
    }

    public static class Provider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public IPrismTransmissionNode provideEmptyNode() {
            return new SimplePrismTransmissionNode(null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:SimplePrismTransmissionNode";
        }
    }

    private static class PrismNext {
        private final SimplePrismTransmissionNode parent;
        private boolean reachable = false;
        private double distanceSq;
        private final BlockPos pos;
        private RaytraceAssist rayAssist = null;

        private PrismNext(SimplePrismTransmissionNode parent, World world, BlockPos start, BlockPos end, boolean doRayTest, boolean oldRayState) {
            this.parent = parent;
            this.pos = end;
            this.rayAssist = new RaytraceAssist(start, end);
            this.reachable = doRayTest ? parent.ignoreBlockCollision || this.rayAssist.isClear(world) : oldRayState;
            this.distanceSq = end.func_177954_c((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p());
        }

        private boolean notifyBlockPlace(World world, BlockPos connect, BlockPos at) {
            double dstStart = connect.func_177954_c((double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p());
            double dstEnd = this.pos.func_177954_c((double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p());
            if (dstStart > this.distanceSq || dstEnd > this.distanceSq) {
                return false;
            }
            boolean oldState = this.reachable;
            this.reachable = this.parent.ignoreBlockCollision || this.rayAssist.isClear(world);
            return this.reachable != oldState;
        }
    }
}

