/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class StarlightTransmissionHandler
implements ITickHandler {
    private static final StarlightTransmissionHandler instance = new StarlightTransmissionHandler();
    private Map<Integer, TransmissionWorldHandler> worldHandlers = new HashMap<Integer, TransmissionWorldHandler>();

    private StarlightTransmissionHandler() {
    }

    public static StarlightTransmissionHandler getInstance() {
        return instance;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.field_72995_K) {
            return;
        }
        int dimId = world.field_73011_w.getDimension();
        TransmissionWorldHandler handle = this.worldHandlers.get(dimId);
        if (handle == null) {
            handle = new TransmissionWorldHandler(world);
            this.worldHandlers.put(dimId, handle);
        }
        handle.tick();
    }

    public void serverCleanHandlers() {
        for (int id : this.worldHandlers.keySet()) {
            this.worldHandlers.get(id).clear(id);
        }
        this.worldHandlers.clear();
    }

    public void informWorldUnload(World world) {
        int dimId = world.field_73011_w.getDimension();
        TransmissionWorldHandler handle = this.worldHandlers.get(dimId);
        if (handle != null) {
            handle.clear(world.field_73011_w.getDimension());
        }
        this.worldHandlers.remove(dimId);
    }

    @Nullable
    public TransmissionWorldHandler getWorldHandler(World world) {
        if (world == null) {
            return null;
        }
        return this.worldHandlers.get(world.field_73011_w.getDimension());
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Starlight Transmission Handler";
    }
}

