/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.client.gui.journal.GuiJournalPages;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RegistryBookLookups {
    private static Map<ItemStack, LookupInfo> lookupMap = new HashMap<ItemStack, LookupInfo>();

    @Nullable
    public static LookupInfo tryGetPage(EntityPlayer querying, Side side, ItemStack search) {
        for (ItemStack compare : lookupMap.keySet()) {
            if (!ItemUtils.stackEqualsNonNBT(search, compare)) continue;
            LookupInfo info = lookupMap.get(compare);
            PlayerProgress prog = ResearchManager.getProgress(querying, side);
            if (prog == null || !prog.getResearchProgression().contains((Object)info.neededKnowledge) || !info.node.canSee(prog)) continue;
            return info;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void openLookupJournalPage(LookupInfo info) {
        if (info == null) {
            return;
        }
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalPages(current, info.node, info.pageIndex));
    }

    public static void registerItemLookup(ItemStack stack, ResearchNode parentNode, int nodePage, ResearchProgression neededProgression) {
        lookupMap.put(stack, new LookupInfo(parentNode, nodePage, neededProgression));
    }

    public static class LookupInfo {
        public final ResearchNode node;
        public final int pageIndex;
        public final ResearchProgression neededKnowledge;

        public LookupInfo(ResearchNode node, int pageIndex, ResearchProgression neededKnowledge) {
            this.node = node;
            this.pageIndex = pageIndex;
            this.neededKnowledge = neededKnowledge;
        }
    }
}

