/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.AbstractData;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PktSyncData
implements IMessage,
IMessageHandler<PktSyncData, IMessage> {
    private Map<String, AbstractData> data = new HashMap<String, AbstractData>();
    private boolean shouldSyncAll = false;

    public PktSyncData() {
    }

    public PktSyncData(Map<String, AbstractData> dataToSend, boolean shouldSyncAll) {
        this.data = dataToSend;
        this.shouldSyncAll = shouldSyncAll;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        int size = pb.readInt();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound cmp;
            String key = ByteBufUtils.readString(pb);
            byte providerId = pb.readByte();
            AbstractData.AbstractDataProvider<? extends AbstractData> provider = AbstractData.Registry.getProvider(providerId);
            if (provider == null) {
                AstralSorcery.log.warn("[AstralSorcery] Provider for ID " + providerId + " doesn't exist! Skipping...");
                continue;
            }
            try {
                cmp = pb.func_150793_b();
            }
            catch (IOException e) {
                AstralSorcery.log.warn("[AstralSorcery] Provider Compound of " + providerId + " threw an IOException! Skipping...");
                AstralSorcery.log.warn("[AstralSorcery] Exception message: " + e.getMessage());
                continue;
            }
            AbstractData dat = provider.provideNewInstance(Side.CLIENT);
            dat.readRawFromPacket(cmp);
            this.data.put(key, dat);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.writeInt(this.data.size());
        for (String key : this.data.keySet()) {
            AbstractData dat = this.data.get(key);
            NBTTagCompound cmp = new NBTTagCompound();
            if (this.shouldSyncAll) {
                dat.writeAllDataToPacket(cmp);
            } else {
                dat.writeToPacket(cmp);
            }
            ByteBufUtils.writeString(pb, key);
            byte providerId = dat.getProviderID();
            pb.writeByte((int)providerId);
            pb.func_150786_a(cmp);
        }
    }

    public IMessage onMessage(PktSyncData message, MessageContext ctx) {
        AstralSorcery.proxy.scheduleClientside(() -> SyncDataHolder.receiveServerPacket(message.data));
        return null;
    }
}

