/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkMap;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkMap;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerks;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.packet.ClientReplyPacket;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktUnlockPerk
implements IMessage,
IMessageHandler<PktUnlockPerk, PktUnlockPerk>,
ClientReplyPacket {
    private ConstellationPerks perk;
    private IMajorConstellation owningConstellation;
    private boolean serverAccept = false;

    public PktUnlockPerk() {
    }

    public PktUnlockPerk(boolean serverAccept, ConstellationPerks perk) {
        this.serverAccept = serverAccept;
        this.perk = perk;
    }

    public PktUnlockPerk(ConstellationPerks perk, IMajorConstellation owningConstellation) {
        this.perk = perk;
        this.owningConstellation = owningConstellation;
    }

    public void fromBytes(ByteBuf buf) {
        IMajorConstellation cst;
        this.serverAccept = buf.readBoolean();
        ConstellationPerks perk = ConstellationPerks.getById(buf.readInt());
        if (perk != null) {
            this.perk = perk;
        }
        if (!this.serverAccept && (cst = ConstellationRegistry.getMajorConstellationByName(ByteBufUtils.readString(buf))) != null) {
            this.owningConstellation = cst;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.serverAccept);
        buf.writeInt(this.perk.getSingleInstance().getId());
        if (!this.serverAccept) {
            ByteBufUtils.writeString(buf, this.owningConstellation.getUnlocalizedName());
        }
    }

    public PktUnlockPerk onMessage(PktUnlockPerk message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            Map<ConstellationPerk, Integer> appliedPerks;
            PlayerProgress prog;
            ConstellationPerkMap map;
            EntityPlayerMP pl = ctx.getServerHandler().field_147369_b;
            if (pl != null && message.perk != null && message.owningConstellation != null && (map = message.owningConstellation.getPerkMap()) != null && (prog = ResearchManager.getProgress((EntityPlayer)pl, ctx.side)) != null && !(appliedPerks = prog.getAppliedPerks()).containsKey(message.perk.getSingleInstance())) {
                boolean canUnlock = prog.hasFreeAlignmentLevel();
                for (ConstellationPerkMap.Dependency d : map.getPerkDependencies()) {
                    if (!d.to.equals((Object)message.perk) || appliedPerks.containsKey(d.from.getSingleInstance())) continue;
                    canUnlock = false;
                }
                if (canUnlock && ResearchManager.applyPerk((EntityPlayer)pl, message.perk)) {
                    return new PktUnlockPerk(true, message.perk);
                }
            }
        } else {
            this.recUnlockResultClient(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void recUnlockResultClient(PktUnlockPerk message) {
        if (message.serverAccept) {
            ConstellationPerks perk = message.perk;
            GuiScreen current = Minecraft.func_71410_x().field_71462_r;
            if (current != null && current instanceof GuiJournalPerkMap) {
                ((GuiJournalPerkMap)current).playUnlockAnimation(perk);
            }
        }
    }
}

