/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PktDiscoverConstellation
implements IMessage,
IMessageHandler<PktDiscoverConstellation, IMessage> {
    private String discoveredConstellation;

    public PktDiscoverConstellation() {
    }

    public PktDiscoverConstellation(String discoveredConstellation) {
        this.discoveredConstellation = discoveredConstellation;
    }

    public void fromBytes(ByteBuf buf) {
        this.discoveredConstellation = ByteBufUtils.readString(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeString(buf, this.discoveredConstellation);
    }

    public IMessage onMessage(PktDiscoverConstellation message, MessageContext ctx) {
        IConstellation received = ConstellationRegistry.getConstellationByName(message.discoveredConstellation);
        if (received == null) {
            AstralSorcery.log.info("[AstralSorcery] Received unknown constellation from client: " + message.discoveredConstellation);
        } else {
            PlayerProgress prog = ResearchManager.getProgress((EntityPlayer)ctx.getServerHandler().field_147369_b, Side.SERVER);
            if (prog != null && received.canDiscover(prog)) {
                ResearchManager.discoverConstellation(received, (EntityPlayer)ctx.getServerHandler().field_147369_b);
                ctx.getServerHandler().field_147369_b.func_145747_a(new TextComponentTranslation("progress.discover.constellation.chat", new Object[]{new TextComponentTranslation(message.discoveredConstellation, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY))}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
            }
        }
        return null;
    }
}

