/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wearable;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantHelper;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.amulet.EnchantmentUpgradeHelper;
import hellfirepvp.astralsorcery.common.enchantment.amulet.PlayerAmuletHandler;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnchantmentAmulet
extends Item
implements ItemDynamicColor,
IBauble {
    private static Random rand = new Random();

    public ItemEnchantmentAmulet() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            items.add((Object)stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List<AmuletEnchantment> enchantments = ItemEnchantmentAmulet.getAmuletEnchantments(stack);
        for (AmuletEnchantment ench : enchantments) {
            tooltip.add(TextFormatting.BLUE + ench.getDescription());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && !ItemEnchantmentAmulet.getAmuletColor(stack).isPresent()) {
            ItemEnchantmentAmulet.freezeAmuletColor(stack);
        }
        if (!worldIn.field_72995_K && ItemEnchantmentAmulet.getAmuletEnchantments(stack).isEmpty()) {
            AmuletEnchantHelper.rollAmulet(stack, 0.0f);
        }
    }

    @Override
    public int getColorForItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return -1;
        }
        Optional<Integer> color = ItemEnchantmentAmulet.getAmuletColor(stack);
        if (color.isPresent()) {
            return color.get();
        }
        int tick = (int)(ClientScheduler.getClientTick() % 500000L);
        int c = Color.getHSBColor((float)tick / 500000.0f * 360.0f, 0.7f, 1.0f).getRGB();
        return c | 0xFF000000;
    }

    public static Optional<Integer> getAmuletColor(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return Optional.empty();
        }
        NBTTagCompound tag = NBTHelper.getPersistentData(stack);
        if (!tag.func_74764_b("amuletColor")) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e("amuletColor"));
    }

    public static void freezeAmuletColor(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return;
        }
        NBTTagCompound tag = NBTHelper.getPersistentData(stack);
        if (tag.func_74764_b("amuletColor")) {
            return;
        }
        if (rand.nextInt(400) == 0) {
            tag.func_74768_a("amuletColor", -1);
        } else {
            float hue = rand.nextFloat() * 360.0f;
            tag.func_74768_a("amuletColor", Color.getHSBColor(hue, 0.7f, 1.0f).getRGB() | 0xFF000000);
        }
    }

    public static List<AmuletEnchantment> getAmuletEnchantments(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return Lists.newArrayList();
        }
        NBTTagCompound tag = NBTHelper.getPersistentData(stack);
        if (!tag.func_74764_b("amuletEnchantments")) {
            return Lists.newArrayList();
        }
        NBTTagList enchants = tag.func_150295_c("amuletEnchantments", 10);
        ArrayList<AmuletEnchantment> enchantments = new ArrayList<AmuletEnchantment>(enchants.func_74745_c());
        for (int i = 0; i < enchants.func_74745_c(); ++i) {
            AmuletEnchantment ench = AmuletEnchantment.deserialize(enchants.func_150305_b(i));
            if (ench == null) continue;
            enchantments.add(ench);
        }
        enchantments.sort(Comparator.comparing(AmuletEnchantment::getType));
        return enchantments;
    }

    public static void setAmuletEnchantments(ItemStack stack, List<AmuletEnchantment> enchantments) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return;
        }
        enchantments.sort(Comparator.comparing(AmuletEnchantment::getType));
        NBTTagCompound tag = NBTHelper.getPersistentData(stack);
        NBTTagList enchants = tag.func_150297_b("amuletEnchantments", 10) ? tag.func_150295_c("amuletEnchantments", 10) : new NBTTagList();
        for (AmuletEnchantment enchant : enchantments) {
            enchants.func_74742_a((NBTBase)enchant.serialize());
        }
        tag.func_74782_a("amuletEnchantments", (NBTBase)enchants);
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemEnchantmentAmulet && player instanceof EntityPlayer) {
            List<AmuletEnchantment> enchList = ItemEnchantmentAmulet.getAmuletEnchantments(itemstack);
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack stack = player.func_184582_a(slot);
                if (!ItemEnchantmentAmulet.canBeAffected(stack, enchList)) continue;
                EnchantmentUpgradeHelper.applyAmuletOwner(player.func_184582_a(slot), (EntityPlayer)player);
            }
        }
    }

    public static boolean canBeAffected(ItemStack stack, Collection<AmuletEnchantment> enchantments) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(stack) || stack.func_190926_b()) {
            return false;
        }
        for (AmuletEnchantment ench : enchantments) {
            if (!ItemEnchantmentAmulet.canInfluenceType(ench.getType(), stack, enchantments)) continue;
            return true;
        }
        return false;
    }

    private static boolean canInfluenceType(AmuletEnchantment.Type type, ItemStack stack, Collection<AmuletEnchantment> enchantments) {
        for (AmuletEnchantment ench : enchantments) {
            Enchantment e = ench.getEnchantment();
            if (e == null || e.field_77351_y == null || ench.getType() != type) continue;
            switch (type) {
                case ADD_TO_SPECIFIC: {
                    if (!e.field_77351_y.func_77557_a(stack.func_77973_b())) break;
                    return true;
                }
                case ADD_TO_EXISTING_SPECIFIC: {
                    if (EnchantmentHelper.func_77506_a((Enchantment)e, (ItemStack)stack) <= 0 && !ItemEnchantmentAmulet.hasAddedEnchant(enchantments, stack, e)) break;
                    return true;
                }
                case ADD_TO_EXISTING_ALL: {
                    if (EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty() && !ItemEnchantmentAmulet.hasAddedEnchant(enchantments, stack, null)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasAddedEnchant(Collection<AmuletEnchantment> enchantments, ItemStack stack, @Nullable Enchantment e) {
        for (AmuletEnchantment enchantment : enchantments) {
            if (enchantment.getType() != AmuletEnchantment.Type.ADD_TO_SPECIFIC || e != null && (!enchantment.getEnchantment().equals(e) || !e.field_77351_y.func_77557_a(stack.func_77973_b()))) continue;
            return true;
        }
        return false;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187567_bP, 0.65f, 6.4f);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187567_bP, 0.65f, 6.4f);
        if (player instanceof EntityPlayerMP) {
            PlayerAmuletHandler.INSTANCE.clearAmuletTags((EntityPlayer)((EntityPlayerMP)player));
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

