/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import hellfirepvp.astralsorcery.common.entities.EntityCrystalTool;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.item.crystal.ToolCrystalProperties;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrystalSword
extends ItemSword
implements CrystalPropertyItem {
    private static final Random rand = new Random();

    public ItemCrystalSword() {
        super(RegistryItems.crystalToolMaterial);
        this.func_77656_e(0);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            CrystalProperties maxCelestial = CrystalProperties.getMaxCelestialProperties();
            ItemStack stack = new ItemStack((Item)this);
            ItemCrystalSword.setToolProperties(stack, ToolCrystalProperties.merge(maxCelestial, maxCelestial));
            items.add((Object)stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ToolCrystalProperties prop = ItemCrystalSword.getToolProperties(stack);
        CrystalProperties.addPropertyTooltip(prop, tooltip, this.getMaxSize(stack));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getMaxSize(ItemStack stack) {
        return 1800;
    }

    @Override
    @Nullable
    public CrystalProperties provideCurrentPropertiesOrNull(ItemStack stack) {
        return ItemCrystalSword.getToolProperties(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return 10;
    }

    public static ToolCrystalProperties getToolProperties(ItemStack stack) {
        NBTTagCompound nbt = NBTHelper.getPersistentData(stack);
        return ToolCrystalProperties.readFromNBT(nbt);
    }

    public static void setToolProperties(ItemStack stack, ToolCrystalProperties properties) {
        NBTTagCompound nbt = NBTHelper.getPersistentData(stack);
        properties.writeToNBT(nbt);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity ei, ItemStack itemstack) {
        EntityCrystalTool newItem = new EntityCrystalTool(ei.field_70170_p, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, itemstack);
        newItem.field_70159_w = ei.field_70159_w;
        newItem.field_70181_x = ei.field_70181_x;
        newItem.field_70179_y = ei.field_70179_y;
        newItem.func_174867_a(40);
        return newItem;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
        this.damageProperties(stack, damage);
    }

    private void damageProperties(ItemStack stack, int damage) {
        ToolCrystalProperties prop = ItemCrystalSword.getToolProperties(stack);
        if (prop == null) {
            stack.func_77964_b(stack.func_77958_k());
            return;
        }
        if (prop.getSize() <= 0) {
            super.setDamage(stack, 11);
            return;
        }
        if (damage < 0) {
            return;
        }
        for (int i = 0; i < damage; ++i) {
            double purity;
            double chance = Math.pow((double)prop.getCollectiveCapability() / 100.0, 2.0);
            if (!(chance >= (double)rand.nextFloat())) continue;
            if (rand.nextInt(3) == 0) {
                prop = prop.copyDamagedCutting();
            }
            if (!((purity = (double)prop.getPurity() / 100.0) <= (double)rand.nextFloat()) || rand.nextInt(3) != 0) continue;
            prop = prop.copyDamagedCutting();
        }
        ItemCrystalSword.setToolProperties(stack, prop);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        ToolCrystalProperties prop;
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND && (prop = ItemCrystalSword.getToolProperties(stack)) != null) {
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(1.0f + 12.0f * prop.getEfficiencyMultiplier()), 0));
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -1.0, 0));
        }
        return modifiers;
    }
}

