/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class WellRecipeAdd
implements SerializeableRecipe {
    private ItemStack inStack;
    private Fluid fluidOut;
    private float productionMultiplier;
    private float shatterMultiplier;
    private int colorHex;

    WellRecipeAdd() {
    }

    public WellRecipeAdd(ItemStack inStack, Fluid fluidOut, float productionMultiplier, float shatterMultiplier, int colorHex) {
        this.inStack = inStack;
        this.fluidOut = fluidOut;
        this.productionMultiplier = productionMultiplier;
        this.shatterMultiplier = shatterMultiplier;
        this.colorHex = colorHex;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.WELL_ADD;
    }

    @Override
    public void read(ByteBuf buf) {
        this.inStack = ByteBufUtils.readItemStack(buf);
        this.fluidOut = FluidRegistry.getFluid((String)ByteBufUtils.readString(buf));
        this.productionMultiplier = buf.readFloat();
        this.shatterMultiplier = buf.readFloat();
        this.colorHex = buf.readInt();
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeItemStack(buf, this.inStack);
        ByteBufUtils.writeString(buf, this.fluidOut.getName());
        buf.writeFloat(this.productionMultiplier);
        buf.writeFloat(this.shatterMultiplier);
        buf.writeInt(this.colorHex);
    }

    @Override
    public void applyRecipe() {
        CraftingAccessManager.addMTLiquefaction(this.inStack, this.fluidOut, this.productionMultiplier, this.shatterMultiplier, new Color(this.colorHex));
    }
}

