/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.listener;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.data.config.Config;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerRedirect {
    public static float getSunBrightnessFactorInj(float prevBrightness, World world) {
        if (Config.weakSkyRendersWhitelist.contains(world.field_73011_w.getDimension())) {
            return prevBrightness;
        }
        WorldSkyHandler wsh = ConstellationSkyHandler.getInstance().getWorldHandler(world);
        if (wsh != null && wsh.dayOfSolarEclipse && wsh.solarEclipse) {
            int eclTick = wsh.solarEclipseTick;
            eclTick = eclTick >= 2400 ? (eclTick -= 2400) : 2400 - eclTick;
            float perc = (float)eclTick / 2400.0f;
            return prevBrightness * (0.05f + 0.95f * perc);
        }
        return prevBrightness;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getSunBrightnessBodyInj(float prevBrightness, World world) {
        if (Config.weakSkyRendersWhitelist.contains(world.field_73011_w.getDimension())) {
            return prevBrightness;
        }
        WorldSkyHandler wsh = ConstellationSkyHandler.getInstance().getWorldHandler(world);
        if (wsh != null && wsh.dayOfSolarEclipse && wsh.solarEclipse) {
            int eclTick = wsh.solarEclipseTick;
            eclTick = eclTick >= 2400 ? (eclTick -= 2400) : 2400 - eclTick;
            float perc = (float)eclTick / 2400.0f;
            return prevBrightness * (0.05f + 0.95f * perc);
        }
        return prevBrightness;
    }
}

