/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.listener;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.auxiliary.StarlightNetworkDebugHandler;
import hellfirepvp.astralsorcery.common.auxiliary.SwordSharpenHelper;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.EntityKnockbackEvent;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerServer;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationDraconicEvolution;
import hellfirepvp.astralsorcery.common.item.ItemBlockStorage;
import hellfirepvp.astralsorcery.common.item.tool.wand.ItemWand;
import hellfirepvp.astralsorcery.common.item.tool.wand.WandAugment;
import hellfirepvp.astralsorcery.common.item.wearable.ItemCape;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktClearBlockStorageStack;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.TickTokenizedMap;
import hellfirepvp.astralsorcery.common.util.data.TimeoutList;
import hellfirepvp.astralsorcery.common.util.data.TimeoutListContainer;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.WorldBlockPos;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerEntity {
    private static final Random rand = new Random();
    private static final Color discidiaWandColor = new Color(0x880100);
    public static int spawnSkipId = -1;
    public static TickTokenizedMap<WorldBlockPos, TickTokenizedMap.SimpleTickToken<Double>> spawnDenyRegions = new TickTokenizedMap(TickEvent.Type.SERVER, new TickEvent.Type[0]);
    public static TimeoutList<EntityPlayer> invulnerabilityCooldown = new TimeoutList(null, TickEvent.Type.SERVER);
    public static TimeoutList<EntityPlayer> ritualFlight = new TimeoutList<EntityPlayer>(player -> {
        if (!player.func_184812_l_()) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            player.func_71016_p();
        }
    }, TickEvent.Type.SERVER);
    public static Map<Integer, EntityAttackStack> attackStack = new HashMap<Integer, EntityAttackStack>();

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        EventHandlerServer.PlayerWrapperContainer ctOld = new EventHandlerServer.PlayerWrapperContainer(event.getOriginal());
        this.removeTimeoutContents(EventHandlerServer.perkCooldowns, ctOld);
        this.removeTimeoutContents(EventHandlerServer.perkCooldownsClient, ctOld);
    }

    private <V> void removeTimeoutContents(TimeoutListContainer<EventHandlerServer.PlayerWrapperContainer, V> container, EventHandlerServer.PlayerWrapperContainer old) {
        if (container.hasList(old)) {
            container.removeList(old);
        }
    }

    @SubscribeEvent
    public void onTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase living = event.getTarget();
        if (living != null && !living.field_70128_L && living instanceof EntityPlayer && invulnerabilityCooldown.contains((EntityPlayer)living)) {
            event.getEntityLiving().func_70604_c(null);
            if (event.getEntityLiving() instanceof EntityLiving) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        WorldSkyHandler wsh = ConstellationSkyHandler.getInstance().getWorldHandler(event.getEntityPlayer().func_130014_f_());
        if (wsh != null && wsh.dayOfSolarEclipse && wsh.solarEclipse && event.getResultStatus() == null) {
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_NOW);
        }
    }

    @SubscribeEvent
    public void onSpawnDropCloud(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityAreaEffectCloud && MiscUtils.iterativeSearch(((EntityAreaEffectCloud)event.getEntity()).field_184503_f, pEffect -> pEffect.func_188419_a().equals((Object)RegistryPotions.potionDropModifier)) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKnockback(EntityKnockbackEvent event) {
        EntityPlayer p;
        PlayerProgress prog;
        Entity attacker = event.getAttacker();
        if (attacker == null || attacker.func_130014_f_().field_72995_K) {
            return;
        }
        if (attacker instanceof EntityPlayer && (prog = ResearchManager.getProgress(p = (EntityPlayer)attacker, Side.SERVER)) != null) {
            Map<ConstellationPerk, Integer> perks = prog.getAppliedPerks();
            for (ConstellationPerk perk : perks.keySet()) {
                if (!prog.isPerkActive(perk) || !perk.mayExecute(ConstellationPerk.Target.ENTITY_KNOCKBACK)) continue;
                perk.onEntityKnockback(p, event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAttack(LivingHurtEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null) {
            Entity shooter;
            EntityLivingBase entitySource = null;
            if (source.func_76346_g() instanceof EntityLivingBase) {
                entitySource = (EntityLivingBase)source.func_76346_g();
            } else if (source.func_76346_g() instanceof EntityArrow && (shooter = ((EntityArrow)source.func_76346_g()).field_70250_c) != null && shooter instanceof EntityLivingBase) {
                entitySource = (EntityLivingBase)shooter;
            }
            if (entitySource != null) {
                WandAugment foundAugment = null;
                ItemStack stack = entitySource.func_184614_ca();
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWand) {
                    foundAugment = ItemWand.getAugment(stack);
                }
                stack = entitySource.func_184592_cb();
                if (foundAugment == null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemWand) {
                    foundAugment = ItemWand.getAugment(stack);
                }
                if (foundAugment != null && foundAugment.equals((Object)WandAugment.DISCIDIA)) {
                    EntityAttackStack attack = attackStack.get(entitySource.func_145782_y());
                    if (attack == null) {
                        attack = new EntityAttackStack();
                        attackStack.put(entitySource.func_145782_y(), attack);
                    }
                    EntityLivingBase entity = event.getEntityLiving();
                    float multiplier = attack.getAndUpdateMultipler((Entity)entity);
                    event.setAmount(event.getAmount() * (1.0f + multiplier));
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.DISCIDIA_ATTACK_STACK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    ev.setAdditionalData(multiplier);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(event.getEntity().field_70170_p, (Vec3i)event.getEntity().func_180425_c(), 64.0));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDeathInform(LivingDeathEvent event) {
        attackStack.remove(event.getEntity().func_145782_y());
    }

    @SubscribeEvent
    public void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
        if (event.getEntityLiving().func_70644_a((Potion)RegistryPotions.potionTimeFreeze)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving().field_70170_p == null || event.getEntityLiving().field_70170_p.field_72995_K || !(event.getEntityLiving().field_70170_p instanceof WorldServer)) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer || !(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityLiving el = (EntityLiving)event.getEntityLiving();
        WorldServer ws = (WorldServer)el.field_70170_p;
        PotionEffect pe = el.func_70660_b((Potion)RegistryPotions.potionDropModifier);
        if (pe != null) {
            el.func_184596_c((Potion)RegistryPotions.potionDropModifier);
            int ampl = pe.func_76458_c();
            if (ampl == 0) {
                event.getDrops().clear();
            } else {
                LootTable lootTableRef = EntityUtils.getLootTable(el);
                LootContext.Builder builder = new LootContext.Builder(ws).func_186472_a((Entity)el).func_186473_a(event.getSource()).func_186469_a(0.0f);
                if (lootTableRef != null) {
                    for (int i = 0; i < ampl; ++i) {
                        for (ItemStack stack : lootTableRef.func_186462_a(rand, builder.func_186471_a())) {
                            if (stack.func_190926_b()) continue;
                            EntityItem ei = new EntityItem((World)ws, el.field_70165_t, el.field_70163_u, el.field_70161_v, stack);
                            ei.func_174869_p();
                            event.getDrops().add(ei);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack held = event.getItemStack();
        if (!event.getWorld().field_72995_K && !held.func_190926_b() && held.func_77973_b() instanceof ItemBlockStorage) {
            ItemBlockStorage.tryClearContainerFor(event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack held = event.getItemStack();
        if (!held.func_190926_b() && held.func_77973_b() instanceof ItemBlockStorage) {
            PacketChannel.CHANNEL.sendToServer((IMessage)new PktClearBlockStorageStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClickDebug(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_184812_l_() && !event.getWorld().field_72995_K && StarlightNetworkDebugHandler.INSTANCE.beginDebugFor(event.getWorld(), event.getPos(), event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDamage(LivingHurtEvent event) {
        EntityLivingBase entity;
        Map<ConstellationPerk, Integer> perks;
        float dmg;
        PlayerProgress prog;
        DamageSource source;
        block17: {
            EntityPlayer p;
            block19: {
                Entity shooter;
                block18: {
                    ItemStack chest;
                    EntityLivingBase living = event.getEntityLiving();
                    if (living == null || living.func_130014_f_().field_72995_K) {
                        return;
                    }
                    if (!living.field_70128_L && living instanceof EntityPlayer && invulnerabilityCooldown.contains((EntityPlayer)living)) {
                        event.setCanceled(true);
                        return;
                    }
                    source = event.getSource();
                    if (Mods.DRACONICEVOLUTION.isPresent() && !(chest = living.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemCape && ModIntegrationDraconicEvolution.isChaosDamage(source)) {
                        if (living instanceof EntityPlayer && ((EntityPlayer)living).func_184812_l_()) {
                            event.setCanceled(true);
                            return;
                        }
                        event.setAmount(event.getAmount() * (1.0f - Config.capeChaosResistance));
                        if ((double)event.getAmount() <= 1.0E-4) {
                            event.setCanceled(true);
                            return;
                        }
                    }
                    if (source.func_76346_g() == null) break block17;
                    if (!(source.func_76346_g() instanceof EntityPlayer)) break block18;
                    p = (EntityPlayer)source.func_76346_g();
                    break block19;
                }
                if (!(source.func_76346_g() instanceof EntityArrow) || (shooter = ((EntityArrow)source.func_76346_g()).field_70250_c) == null || !(shooter instanceof EntityPlayer)) break block17;
                p = (EntityPlayer)shooter;
            }
            ItemStack held = p.func_184614_ca();
            if (SwordSharpenHelper.isSwordSharpened(held)) {
                event.setAmount(event.getAmount() * (1.0f + (float)Config.swordSharpMultiplier));
            }
            if ((prog = ResearchManager.getProgress(p, Side.SERVER)) != null) {
                dmg = event.getAmount();
                perks = prog.getAppliedPerks();
                for (ConstellationPerk perk : perks.keySet()) {
                    if (!prog.isPerkActive(perk) || !perk.mayExecute(ConstellationPerk.Target.ENTITY_ATTACK)) continue;
                    dmg = perk.onEntityAttack(p, event.getEntityLiving(), dmg);
                }
                event.setAmount(dmg);
            }
        }
        if ((entity = event.getEntityLiving()) != null) {
            WandAugment wa;
            ItemStack active;
            EntityPlayer hurt;
            if (entity instanceof EntityPlayer && (prog = ResearchManager.getProgress(hurt = (EntityPlayer)entity, Side.SERVER)) != null) {
                dmg = event.getAmount();
                perks = prog.getAppliedPerks();
                for (ConstellationPerk perk : perks.keySet()) {
                    if (!prog.isPerkActive(perk) || !perk.mayExecute(ConstellationPerk.Target.ENTITY_HURT)) continue;
                    dmg = perk.onEntityHurt(hurt, source, dmg);
                }
                event.setAmount(dmg);
            }
            if (!(active = entity.func_184607_cu()).func_190926_b() && active.func_77973_b() instanceof ItemWand && (wa = ItemWand.getAugment(active)) != null && wa.equals((Object)WandAugment.ARMARA)) {
                PotionEffect potion = new PotionEffect(MobEffects.field_76429_m, 100, 0);
                if (entity.func_70687_e(potion)) {
                    entity.func_70690_d(potion);
                }
                if (entity.func_70687_e(potion = new PotionEffect(MobEffects.field_76444_x, 100, 1))) {
                    entity.func_70690_d(potion);
                }
            }
        }
    }

    @SubscribeEvent
    public void onSpawnTest(LivingSpawnEvent.CheckSpawn event) {
        boolean mayDeny;
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityLivingBase toTest = event.getEntityLiving();
        if (spawnSkipId != -1 && toTest.func_145782_y() == spawnSkipId) {
            return;
        }
        Vector3 at = Vector3.atEntityCorner((Entity)toTest);
        boolean bl = mayDeny = Config.doesMobSpawnDenyDenyEverything || toTest.isCreatureType(EnumCreatureType.MONSTER, false);
        if (mayDeny) {
            for (Map.Entry entry : spawnDenyRegions.entrySet()) {
                if (!((WorldBlockPos)((Object)entry.getKey())).getWorld().equals(toTest.func_130014_f_()) || !(at.distance((Vec3i)entry.getKey()) <= (Double)((TickTokenizedMap.SimpleTickToken)entry.getValue()).getValue())) continue;
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playDiscidiaStackAttackEffects(PktParticleEvent pkt) {
        EntityLivingBase e;
        Vector3 at = pkt.getVec();
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        EntityLivingBase found = null;
        if (w != null && (e = EntityUtils.selectClosest(w.func_72872_a(EntityLivingBase.class, Block.field_185505_j.func_72317_d(at.getX() - 0.5, at.getY() - 0.5, at.getZ() - 0.5)), ent -> ent.func_70011_f(at.getX(), at.getY(), at.getZ()))) != null) {
            found = e;
        }
        if (found != null) {
            AxisAlignedBB box = found.func_174813_aQ();
            for (int i = 0; i < 24; ++i) {
                if (!((double)rand.nextFloat() < pkt.getAdditionalData())) continue;
                Vector3 pos = new Vector3(box.field_72340_a + (box.field_72336_d - box.field_72340_a) * (double)rand.nextFloat(), box.field_72338_b + (box.field_72337_e - box.field_72338_b) * (double)rand.nextFloat(), box.field_72339_c + (box.field_72334_f - box.field_72339_c) * (double)rand.nextFloat());
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ());
                p.setColor(discidiaWandColor).setMaxAge(25 + rand.nextInt(10));
                p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setAlphaMultiplier(1.0f);
                p.gravity(0.004).scale(0.15f + rand.nextFloat() * 0.1f);
                Vector3 motion = new Vector3();
                MiscUtils.applyRandomOffset(motion, rand, 0.03f);
                p.motion(motion.getX(), motion.getY(), motion.getZ());
            }
        }
    }

    private static class EntityAttackStack {
        private static long stackMsDuration = 5000L;
        private int entityStackId = -1;
        private long lastStackMs = 0L;
        private int stack = 0;

        private EntityAttackStack() {
        }

        public float getMultiplier(Entity attackedEntity) {
            return this.getMultiplier(attackedEntity.func_145782_y());
        }

        public float getMultiplier(int attackedEntityId) {
            if (this.entityStackId != attackedEntityId) {
                return 0.0f;
            }
            return (float)this.stack / (float)Config.discidiaStackCap * Config.discidiaStackMultiplier;
        }

        public float getAndUpdateMultipler(Entity attackedEntity) {
            return this.getAndUpdateMultipler(attackedEntity.func_145782_y());
        }

        public float getAndUpdateMultipler(int attackedEntityId) {
            if (attackedEntityId != this.entityStackId) {
                this.entityStackId = attackedEntityId;
                this.lastStackMs = System.currentTimeMillis();
                this.stack = 0;
            } else {
                long current = System.currentTimeMillis();
                long diff = current - this.lastStackMs;
                this.lastStackMs = current;
                this.stack = diff < stackMsDuration ? MathHelper.func_76125_a((int)(this.stack + 1), (int)0, (int)Config.discidiaStackCap) : MathHelper.func_76125_a((int)(this.stack - (int)(diff / stackMsDuration)), (int)0, (int)Config.discidiaStackCap);
            }
            return (float)this.stack / (float)Config.discidiaStackCap * Config.discidiaStackMultiplier;
        }
    }
}

