/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.listener;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.base.Plants;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectAevitas;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectArmara;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectBootes;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectDiscidia;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectEvorsio;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectFornax;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectHorologium;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectLucerna;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectMineralis;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectOctans;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectPelotrio;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectVicio;
import hellfirepvp.astralsorcery.common.entities.EntitySpectralTool;
import hellfirepvp.astralsorcery.common.item.wearable.ItemCape;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktElytraCapeState;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.CropHelper;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerCapeEffects
implements ITickHandler {
    private static final Random rand = new Random();
    public static EventHandlerCapeEffects INSTANCE = new EventHandlerCapeEffects();
    public static EntityPlayer currentPlayerInTick = null;
    private static boolean discidiaChainingAttack = false;
    private static boolean evorsioChainingBreak = false;
    private static boolean updateElytraBuffer = false;
    public static boolean inElytraCheck = false;

    private EventHandlerCapeEffects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        CapeEffectEvorsio ev;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (evorsioChainingBreak) {
            return;
        }
        EntityPlayer pl = event.getPlayer();
        if (pl == null || !(pl instanceof EntityPlayerMP)) {
            return;
        }
        if (MiscUtils.isPlayerFakeMP((EntityPlayerMP)pl)) {
            return;
        }
        IBlockState state = event.getState();
        ItemStack held = pl.func_184614_ca();
        CapeEffectPelotrio pel = (CapeEffectPelotrio)ItemCape.getCapeEffect(pl, Constellations.pelotrio);
        if (pel != null) {
            if (("pickaxe".equalsIgnoreCase(state.func_177230_c().getHarvestTool(state)) || !state.func_185904_a().func_76229_l() && Items.field_151046_w.func_150897_b(state)) && !pl.func_184614_ca().func_190926_b() && pl.func_184614_ca().func_77973_b().getToolClasses(held).contains("pickaxe") && rand.nextFloat() < pel.getChanceSpawnPick()) {
                BlockPos at = pl.func_180425_c().func_177984_a();
                EntitySpectralTool esp = new EntitySpectralTool(event.getWorld(), at, new ItemStack(Items.field_151046_w), EntitySpectralTool.ToolTask.createPickaxeTask());
                event.getWorld().func_72838_d((Entity)esp);
                return;
            }
            if ((state.func_177230_c().isWood((IBlockAccess)event.getWorld(), event.getPos()) || state.func_177230_c().isLeaves(state, (IBlockAccess)event.getWorld(), event.getPos())) && !pl.func_184614_ca().func_190926_b() && pl.func_184614_ca().func_77973_b().getToolClasses(held).contains("axe") && rand.nextFloat() < pel.getChanceSpawnAxe()) {
                BlockPos at = pl.func_180425_c().func_177984_a();
                EntitySpectralTool esp = new EntitySpectralTool(event.getWorld(), at, new ItemStack(Items.field_151056_x), EntitySpectralTool.ToolTask.createLogTask());
                event.getWorld().func_72838_d((Entity)esp);
            }
        }
        if ((ev = (CapeEffectEvorsio)ItemCape.getCapeEffect(pl, Constellations.evorsio)) != null && !pl.func_184614_ca().func_190926_b() && !pl.func_184614_ca().func_77973_b().getToolClasses(pl.func_184614_ca()).isEmpty()) {
            evorsioChainingBreak = true;
            try {
                EnumFacing faceHit;
                RayTraceResult rtr = MiscUtils.rayTraceLook(pl);
                if (rtr != null && (faceHit = rtr.field_178784_b) != null) {
                    ev.breakBlocksPlane((EntityPlayerMP)pl, faceHit, event.getWorld(), event.getPos());
                }
            }
            finally {
                evorsioChainingBreak = false;
            }
        }
    }

    @SubscribeEvent
    public void playerUpdatePre(TickEvent.PlayerTickEvent event) {
        currentPlayerInTick = event.phase == TickEvent.Phase.START ? event.player : null;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHurt(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() != null && event.getEntityLiving() instanceof EntityPlayer) {
            Entity source;
            CapeEffectArmara ca;
            EntityPlayer pl = (EntityPlayer)event.getEntityLiving();
            CapeEffectDiscidia cd = (CapeEffectDiscidia)ItemCape.getCapeEffect(pl, Constellations.discidia);
            if (cd != null) {
                cd.writeLastAttackDamage(event.getAmount());
            }
            if ((ca = (CapeEffectArmara)ItemCape.getCapeEffect(pl, Constellations.armara)) != null && ca.shouldPreventDamage(event.getSource(), false)) {
                event.setCanceled(true);
                return;
            }
            CapeEffectBootes bo = (CapeEffectBootes)ItemCape.getCapeEffect(pl, Constellations.bootes);
            if (bo != null && event.getSource().func_76346_g() != null && (source = event.getSource().func_76346_g()) instanceof EntityLivingBase) {
                bo.onPlayerDamagedByEntity(pl, (EntityLivingBase)source);
            }
            if (event.getSource().func_76347_k()) {
                CapeEffectFornax cf = (CapeEffectFornax)ItemCape.getCapeEffect(pl, Constellations.fornax);
                if (cf != null) {
                    cf.healFor(pl, event.getAmount());
                    float mul = cf.getDamageMultiplier();
                    if (mul <= 0.0f) {
                        event.setCanceled(true);
                        return;
                    }
                    event.setAmount(event.getAmount() * mul);
                }
            } else {
                CapeEffectHorologium horo = (CapeEffectHorologium)ItemCape.getCapeEffect(pl, Constellations.horologium);
                if (horo != null) {
                    horo.onHurt(pl);
                }
            }
        }
    }

    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        DamageSource ds = event.getSource();
        if (ds.func_76346_g() != null && ds.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer pl = (EntityPlayer)ds.func_76346_g();
            if (!(pl instanceof EntityPlayerMP)) {
                return;
            }
            if (MiscUtils.isPlayerFakeMP((EntityPlayerMP)pl)) {
                return;
            }
            CapeEffectEvorsio ev = (CapeEffectEvorsio)ItemCape.getCapeEffect(pl, Constellations.evorsio);
            if (ev != null) {
                ev.deathAreaDamage(ds, event.getEntityLiving());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        if (discidiaChainingAttack) {
            return;
        }
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        DamageSource ds = event.getSource();
        if (ds.func_76346_g() != null && ds.func_76346_g() instanceof EntityPlayer) {
            CapeEffectPelotrio pel;
            EntityPlayer attacker = (EntityPlayer)ds.func_76346_g();
            if (!(attacker instanceof EntityPlayerMP)) {
                return;
            }
            if (MiscUtils.isPlayerFakeMP((EntityPlayerMP)attacker)) {
                return;
            }
            CapeEffectDiscidia cd = (CapeEffectDiscidia)ItemCape.getCapeEffect(attacker, Constellations.discidia);
            if (cd != null) {
                double added = cd.getLastAttackDamage();
                discidiaChainingAttack = true;
                try {
                    event.getEntityLiving().func_70097_a((DamageSource)CommonProxy.dmgSourceStellar, (float)(added / 2.0));
                    event.getEntityLiving().func_70097_a(DamageSource.func_76365_a((EntityPlayer)attacker), (float)(added / 2.0));
                }
                finally {
                    discidiaChainingAttack = false;
                }
            }
            if ((pel = (CapeEffectPelotrio)ItemCape.getCapeEffect(attacker, Constellations.pelotrio)) != null && !attacker.func_184614_ca().func_190926_b() && rand.nextFloat() < pel.getChanceSpawnSword()) {
                BlockPos at = attacker.func_180425_c().func_177984_a();
                EntitySpectralTool esp = new EntitySpectralTool(attacker.func_130014_f_(), at, new ItemStack(Items.field_151048_u), EntitySpectralTool.ToolTask.createAttackTask());
                attacker.func_130014_f_().func_72838_d((Entity)esp);
            }
        }
    }

    @SubscribeEvent
    public void onWaterBreak(PlayerEvent.BreakSpeed event) {
        CapeEffectOctans ceo;
        EntityPlayer pl = event.getEntityPlayer();
        if (pl.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)pl) && (ceo = (CapeEffectOctans)ItemCape.getCapeEffect(pl, Constellations.octans)) != null) {
            event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
        }
    }

    private void tickFornaxMelting(EntityPlayer pl) {
        CapeEffectFornax cf;
        if (pl.func_70027_ad() && (cf = (CapeEffectFornax)ItemCape.getCapeEffect(pl, Constellations.fornax)) != null) {
            cf.attemptMelt(pl);
        }
    }

    private void tickAevitasEffect(EntityPlayer pl) {
        CapeEffectAevitas cd = (CapeEffectAevitas)ItemCape.getCapeEffect(pl, Constellations.aevitas);
        if (cd != null) {
            float potency = cd.getPotency();
            float range = cd.getRange();
            if (rand.nextFloat() < potency) {
                World w = pl.func_130014_f_();
                AxisAlignedBB bb = new AxisAlignedBB((double)(-range), (double)(-range), (double)(-range), (double)range, (double)range, (double)range);
                bb = bb.func_72317_d(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v);
                Predicate pr = EntitySelectors.field_180132_d.and((Predicate)EntitySelectors.field_94557_a);
                List players = w.func_175647_a(EntityPlayer.class, bb, pr::test);
                for (EntityPlayer player : players) {
                    if (!(rand.nextFloat() <= cd.getFeedChancePerCycle())) continue;
                    player.func_70691_i(cd.getHealPerCycle());
                    player.func_71024_bL().func_75122_a(cd.getFoodLevelPerCycle(), cd.getFoodSaturationLevelPerCycle());
                }
            }
            if (rand.nextFloat() < cd.getTurnChance()) {
                int x = Math.round(-range + 1.0f + 2.0f * range * rand.nextFloat());
                int y = Math.round(-range + 1.0f + 2.0f * range * rand.nextFloat());
                int z = Math.round(-range + 1.0f + 2.0f * range * rand.nextFloat());
                BlockPos at = pl.func_180425_c().func_177982_a(x, y, z);
                IBlockState state = pl.func_130014_f_().func_180495_p(at);
                if (Plants.matchesAny(state)) {
                    state = Plants.getAnyRandomState();
                    pl.func_130014_f_().func_175656_a(at, state);
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)at);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(pl.func_130014_f_(), (Vec3i)at, 16.0));
                } else {
                    CropHelper.GrowablePlant growable = CropHelper.wrapPlant(pl.func_130014_f_(), at);
                    if (growable != null) {
                        growable.tryGrow(pl.func_130014_f_(), rand);
                        PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)at);
                        PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(pl.func_130014_f_(), (Vec3i)at, 16.0));
                    }
                }
            }
        }
    }

    private void tickArmaraWornEffect(EntityPlayer pl) {
        CapeEffectArmara ca = (CapeEffectArmara)ItemCape.getCapeEffect(pl, Constellations.armara);
        if (ca != null) {
            ca.wornTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tickVicioClientEffect(EntityPlayer player) {
        if (player instanceof EntityPlayerSP) {
            EntityPlayerSP spl = (EntityPlayerSP)player;
            if (spl.field_71158_b.field_78901_c && !spl.field_70122_E && spl.field_70181_x < -0.5 && !spl.field_71075_bZ.field_75100_b && !spl.func_70090_H() && !spl.func_180799_ab()) {
                PacketChannel.CHANNEL.sendToServer((IMessage)PktElytraCapeState.resetFallDistance());
                if (!spl.func_184613_cA()) {
                    PacketChannel.CHANNEL.sendToServer((IMessage)PktElytraCapeState.setFlying());
                }
            } else if (spl.func_184613_cA()) {
                PacketChannel.CHANNEL.sendToServer((IMessage)PktElytraCapeState.resetFallDistance());
                if (spl.field_71075_bZ.field_75100_b || spl.field_70122_E || spl.func_70090_H() || spl.func_180799_ab()) {
                    PacketChannel.CHANNEL.sendToServer((IMessage)PktElytraCapeState.resetFlying());
                } else {
                    Vector3 mov = new Vector3(((EntityPlayerSP)player).field_70159_w, 0.0, ((EntityPlayerSP)player).field_70179_y);
                    if (mov.length() <= (double)0.4f && ((EntityPlayerSP)player).field_70181_x > (double)0.4f) {
                        PacketChannel.CHANNEL.sendToServer((IMessage)PktElytraCapeState.resetFlying());
                    }
                }
            }
        }
    }

    private void tickOctansEffect(EntityPlayer pl) {
        CapeEffectOctans ceo = (CapeEffectOctans)ItemCape.getCapeEffect(pl, Constellations.octans);
        if (ceo != null && pl.func_70055_a(Material.field_151586_h)) {
            if (pl.func_70086_ai() < 300) {
                pl.func_70050_g(300);
            }
            ceo.onWaterHealTick(pl);
        }
    }

    private void tickBootesEffect(EntityPlayer pl) {
        CapeEffectBootes ceo = (CapeEffectBootes)ItemCape.getCapeEffect(pl, Constellations.bootes);
        if (ceo != null) {
            ceo.onPlayerTick(pl);
        }
    }

    public static void updateElytraEventPre(EntityLivingBase entity) {
        CapeEffectVicio vic;
        if (entity instanceof EntityPlayer && (vic = (CapeEffectVicio)ItemCape.getCapeEffect((EntityPlayer)entity, Constellations.vicio)) != null) {
            updateElytraBuffer = entity.func_70083_f(7);
            inElytraCheck = true;
        }
    }

    public static void updateElytraEventPost(EntityLivingBase entity) {
        CapeEffectVicio vic;
        inElytraCheck = false;
        if (entity instanceof EntityPlayer && updateElytraBuffer && (vic = (CapeEffectVicio)ItemCape.getCapeEffect((EntityPlayer)entity, Constellations.vicio)) != null) {
            boolean current = entity.func_70083_f(7);
            if (!(current || ((EntityPlayer)entity).field_70122_E || entity.func_184218_aH())) {
                entity.func_70052_a(7, true);
            }
            entity.field_70159_w *= (double)1.005f;
            entity.field_70181_x *= (double)1.005f;
            entity.field_70179_y *= (double)1.005f;
        }
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        switch (type) {
            case WORLD: {
                break;
            }
            case PLAYER: {
                CapeEffectMineralis min;
                CapeEffectLucerna luc;
                CapeEffectVicio vic;
                EntityPlayer pl = (EntityPlayer)context[0];
                Side side = (Side)context[1];
                if (side == Side.SERVER) {
                    if (!(pl instanceof EntityPlayerMP)) {
                        return;
                    }
                    if (MiscUtils.isPlayerFakeMP((EntityPlayerMP)pl)) {
                        return;
                    }
                    this.tickAevitasEffect(pl);
                    this.tickFornaxMelting(pl);
                    this.tickArmaraWornEffect(pl);
                    this.tickOctansEffect(pl);
                    this.tickBootesEffect(pl);
                    break;
                }
                if (side != Side.CLIENT) break;
                CapeArmorEffect cae = ItemCape.getCapeEffect(pl);
                if (cae != null) {
                    cae.playActiveParticleTick(pl);
                }
                if ((vic = (CapeEffectVicio)ItemCape.getCapeEffect(pl, Constellations.vicio)) != null) {
                    this.tickVicioClientEffect(pl);
                }
                if ((luc = (CapeEffectLucerna)ItemCape.getCapeEffect(pl, Constellations.lucerna)) != null) {
                    luc.playClientHighlightTick(pl);
                }
                if ((min = (CapeEffectMineralis)ItemCape.getCapeEffect(pl, Constellations.mineralis)) == null) break;
                min.playClientHighlightTick(pl);
                break;
            }
            case CLIENT: {
                break;
            }
            case SERVER: {
                break;
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Cape-EventHandler";
    }
}

