/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFloatingCube;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.base.LiquidInteraction;
import hellfirepvp.astralsorcery.common.entities.EntityTechnicalAmbient;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktLiquidInteractionBurst;
import hellfirepvp.astralsorcery.common.tile.ILiquidStarlightPowered;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.util.ASDataSerializers;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLiquidSpark
extends EntityFlying
implements EntityTechnicalAmbient {
    private static final DataParameter<Integer> ENTITY_TARGET = EntityDataManager.func_187226_a(EntityLiquidSpark.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<FluidStack> FLUID_REPRESENTED = EntityDataManager.func_187226_a(EntityLiquidSpark.class, ASDataSerializers.FLUID);
    private LiquidInteraction purpose;
    private TileEntity tileTarget;
    private BlockPos resolvableTilePos = null;

    public EntityLiquidSpark(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.4f);
        this.field_70145_X = true;
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        this.purpose = null;
    }

    public EntityLiquidSpark(World world, BlockPos spawnPos, LiquidInteraction purposeOfLiving) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
        this.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
        this.field_70145_X = true;
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        this.purpose = purposeOfLiving;
    }

    public EntityLiquidSpark(World world, BlockPos spawnPos, TileEntity target) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
        this.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
        this.field_70145_X = true;
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        this.tileTarget = target;
    }

    public void setTarget(EntityLiquidSpark other) {
        this.field_70180_af.func_187227_b(ENTITY_TARGET, (Object)other.func_145782_y());
    }

    public void setFluidRepresented(FluidStack fs) {
        this.field_70180_af.func_187227_b(FLUID_REPRESENTED, (Object)fs);
    }

    public FluidStack getRepresentitiveFluid() {
        return (FluidStack)this.field_70180_af.func_187225_a(FLUID_REPRESENTED);
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENTITY_TARGET, (Object)-1);
        this.field_70180_af.func_187214_a(FLUID_REPRESENTED, (Object)new FluidStack(FluidRegistry.WATER, 1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.35);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        this.field_70145_X = this.func_130014_f_().func_180495_p(this.func_180425_c()).func_177230_c().equals((Object)BlocksAS.blockChalice);
        if (this.resolvableTilePos != null) {
            this.tileTarget = MiscUtils.getTileAt((IBlockAccess)this.field_70170_p, this.resolvableTilePos, TileEntity.class, true);
            this.resolvableTilePos = null;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > 800) {
                this.func_70106_y();
                return;
            }
            if (this.purpose != null) {
                int target = (Integer)this.field_70180_af.func_187225_a(ENTITY_TARGET);
                if (target == -1) {
                    this.func_70106_y();
                    return;
                }
                Entity e = this.field_70170_p.func_73045_a(target);
                if (e == null || e.field_70128_L || !(e instanceof EntityLiquidSpark)) {
                    this.func_70106_y();
                    return;
                }
                if (this.func_70032_d(e) < 0.7f) {
                    this.func_70106_y();
                    e.func_70106_y();
                    Vector3 at = Vector3.atEntityCenter(e).subtract(Vector3.atEntityCenter((Entity)this)).divide(2.0).add(Vector3.atEntityCenter((Entity)this));
                    this.purpose.triggerInteraction(this.field_70170_p, at);
                    PktLiquidInteractionBurst ev = new PktLiquidInteractionBurst(this.purpose.getComponent1(), this.purpose.getComponent2(), at);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_70170_p, (Vec3i)at.toBlockPos(), 32.0));
                } else {
                    this.field_70765_h.func_75642_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, (double)2.4f);
                }
            } else if (this.tileTarget != null) {
                if (this.tileTarget.func_145837_r() || MiscUtils.getTileAt((IBlockAccess)this.field_70170_p, this.tileTarget.func_174877_v(), this.tileTarget.getClass(), true) == null) {
                    this.func_70106_y();
                    return;
                }
                Vector3 target = new Vector3(this.tileTarget.func_174877_v()).add(0.5, 0.5, 0.5);
                if (this.func_70011_f(target.getX(), target.getY(), target.getZ()) < (double)1.1f) {
                    IFluidHandler handler;
                    this.func_70106_y();
                    if (this.getRepresentitiveFluid().getFluid() == BlocksAS.fluidLiquidStarlight && this.tileTarget instanceof ILiquidStarlightPowered) {
                        ((ILiquidStarlightPowered)this.tileTarget).acceptStarlight(this.getRepresentitiveFluid().amount);
                    } else if (this.tileTarget.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (handler = (IFluidHandler)this.tileTarget.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null) {
                        handler.fill(this.getRepresentitiveFluid(), true);
                    }
                    if (this.tileTarget instanceof TileEntitySynchronized) {
                        ((TileEntitySynchronized)this.tileTarget).markForUpdate();
                    } else {
                        this.tileTarget.func_70296_d();
                    }
                    Vector3 at = Vector3.atEntityCenter((Entity)this);
                    PktLiquidInteractionBurst ev = new PktLiquidInteractionBurst(this.getRepresentitiveFluid(), this.getRepresentitiveFluid(), at);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_70170_p, (Vec3i)at.toBlockPos(), 32.0));
                } else {
                    this.field_70765_h.func_75642_a(target.getX(), target.getY(), target.getZ(), (double)2.4f);
                }
            } else {
                this.func_70106_y();
            }
        } else {
            this.playAmbientParticles();
        }
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return null;
    }

    protected float func_70599_aP() {
        return 0.0f;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("tileTarget")) {
            this.resolvableTilePos = NBTHelper.readBlockPosFromNBT(compound.func_74775_l("tileTarget"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.tileTarget != null) {
            NBTTagCompound cmp = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(this.tileTarget.func_174877_v(), cmp);
            compound.func_74782_a("tileTarget", (NBTBase)cmp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playAmbientParticles() {
        FluidStack stack = (FluidStack)this.field_70180_af.func_187225_a(FLUID_REPRESENTED);
        if (stack == null) {
            return;
        }
        TextureAtlasSprite tas = RenderingUtils.tryGetFlowingTextureOfFluidStack(stack);
        Vector3 at = Vector3.atEntityCenter((Entity)this);
        EntityFXFloatingCube cube = RenderingUtils.spawnFloatingBlockCubeParticle(at, tas);
        cube.setTextureSubSizePercentage(0.0625f).setMaxAge(20 + this.field_70146_Z.nextInt(20));
        cube.setWorldLightCoord((World)Minecraft.func_71410_x().field_71441_e, at.toBlockPos());
        cube.setColorHandler(cb -> new Color(stack.getFluid().getColor(stack)));
        cube.setScale(0.3f).tumble().setMotion(this.field_70146_Z.nextFloat() * 0.02f * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70146_Z.nextFloat() * 0.02f * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70146_Z.nextFloat() * 0.02f * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at);
        p.setColor(Color.WHITE).scale(0.3f + this.field_70146_Z.nextFloat() * 0.1f).setMaxAge(20 + this.field_70146_Z.nextInt(10));
    }
}

