/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import baubles.api.BaubleType;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletHolderCapability;
import hellfirepvp.astralsorcery.common.enchantment.amulet.EnchantmentUpgradeHelper;
import hellfirepvp.astralsorcery.common.item.wearable.ItemEnchantmentAmulet;
import hellfirepvp.astralsorcery.common.util.BaublesHelper;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerAmuletHandler
implements ITickHandler {
    public static final PlayerAmuletHandler INSTANCE = new PlayerAmuletHandler();

    private PlayerAmuletHandler() {
    }

    @SubscribeEvent
    public void attachAmuletItemCapability(AttachCapabilitiesEvent<ItemStack> itemCapEvent) {
        if (!EnchantmentUpgradeHelper.isItemBlacklisted((ItemStack)itemCapEvent.getObject())) {
            itemCapEvent.addCapability(AmuletHolderCapability.CAP_AMULETHOLDER_NAME, (ICapabilityProvider)new AmuletHolderCapability.Provider());
        }
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        this.clearAmuletTags((EntityPlayer)context[0]);
    }

    public void clearAmuletTags(EntityPlayer player) {
        boolean hasAmulet = false;
        for (ItemStack bauble : BaublesHelper.getWornBaublesForType(player, BaubleType.AMULET)) {
            if (bauble.func_190926_b() || !(bauble.func_77973_b() instanceof ItemEnchantmentAmulet)) continue;
            hasAmulet = true;
        }
        EnchantmentUpgradeHelper.removeAmuletTagsAndCleanup(player, hasAmulet);
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "PlayerAmuletHandler";
    }
}

