/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world;

import com.google.common.io.Files;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.data.ChunkVersionBuffer;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import hellfirepvp.astralsorcery.common.data.world.data.LightNetworkBuffer;
import hellfirepvp.astralsorcery.common.data.world.data.RockCrystalBuffer;
import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class WorldCacheManager
implements ITickHandler {
    private static WorldCacheManager instance = new WorldCacheManager();
    private static Map<Integer, Map<SaveKey, CachedWorldData>> cachedData = new HashMap<Integer, Map<SaveKey, CachedWorldData>>();
    private static File saveDir;

    private WorldCacheManager() {
    }

    public static WorldCacheManager getInstance() {
        return instance;
    }

    public static void wipeCache() {
        cachedData.clear();
        saveDir = null;
    }

    public static <T extends CachedWorldData> T getOrLoadData(World world, SaveKey key) {
        CachedWorldData data = WorldCacheManager.getFromCache(world, key);
        if (data != null) {
            return (T)data;
        }
        return (T)WorldCacheManager.loadAndCache(world, key);
    }

    private static synchronized DataFileSet getDataFile(World world, String key) {
        File worldDir;
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Tried to access data structure on clientside. This is a severe implementation error!");
        }
        if (saveDir == null) {
            saveDir = new File(world.func_72860_G().func_75765_b(), "AstralSorceryData");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            } else {
                WorldCacheManager.ensureFolder(saveDir);
            }
        }
        if (!(worldDir = new File(saveDir, "DIM_" + world.field_73011_w.getDimension())).exists()) {
            worldDir.mkdirs();
        } else {
            WorldCacheManager.ensureFolder(worldDir);
        }
        return new DataFileSet(new File(worldDir, key + ".dat"));
    }

    private static void ensureFolder(File f) {
        if (!f.isDirectory()) {
            AstralSorcery.log.warn("[AstralSorcery] AstralSorcery dataFile exists, but is a file instead of a folder! Please ensure that this is a folder/delete the file!");
            AstralSorcery.log.warn("[AstralSorcery] Encountered illegal state. Crashing to prevent further, harder to resolve errors!");
            throw new IllegalStateException("Affected file: " + f.getAbsolutePath());
        }
    }

    @Nullable
    private static CachedWorldData getFromCache(World world, SaveKey key) {
        if (!cachedData.containsKey(world.field_73011_w.getDimension())) {
            return null;
        }
        Map<SaveKey, CachedWorldData> dataMap = cachedData.get(world.field_73011_w.getDimension());
        return dataMap.get((Object)key);
    }

    private static CachedWorldData loadAndCache(World world, SaveKey key) {
        Map<SaveKey, CachedWorldData> dataMap;
        CachedWorldData data = WorldCacheManager.getFromCache(world, key);
        if (data != null) {
            return data;
        }
        int dimId = world.field_73011_w.getDimension();
        CachedWorldData loaded = WorldCacheManager.loadDataFromFile(world, key);
        if (!cachedData.containsKey(dimId)) {
            cachedData.put(dimId, new HashMap());
        }
        if ((dataMap = cachedData.get(dimId)).containsKey((Object)key)) {
            AstralSorcery.log.warn("[AstralSorcery] Duplicate loading of the same WorldData! Discarding old data.");
            AstralSorcery.log.warn("[AstralSorcery] Affected data: Dim=" + dimId + " key=" + key.identifier);
            dataMap.remove((Object)key);
        }
        dataMap.put(key, loaded);
        loaded.onLoad(world);
        return loaded;
    }

    private static CachedWorldData loadDataFromFile(World world, SaveKey key) {
        DataFileSet errorSet;
        DataFileSet f = WorldCacheManager.getDataFile(world, key.identifier);
        if (!f.actualFile.exists() && !f.backupFile.exists()) {
            return key.getNewInstance();
        }
        AstralSorcery.log.info("[AstralSorcery] Load CachedWorldData '" + key.identifier + "' for world " + world.field_73011_w.getDimension());
        boolean errored = false;
        CachedWorldData data = null;
        try {
            if (f.actualFile.exists()) {
                data = WorldCacheManager.attemptLoad(key, f.actualFile);
            }
        }
        catch (Exception exc) {
            AstralSorcery.log.info("[AstralSorcery] Loading worlddata '" + key.identifier + "' failed for its actual save file. Attempting load from backup file.");
            errored = true;
        }
        if (data == null) {
            try {
                if (f.backupFile.exists()) {
                    data = WorldCacheManager.attemptLoad(key, f.backupFile);
                }
            }
            catch (Exception exc) {
                AstralSorcery.log.info("[AstralSorcery] Loading worlddata '" + key.identifier + "' failed for its backup save file. Creating empty one for current runtime and copying erroneous files to error files.");
                errored = true;
            }
        }
        if (data == null && errored) {
            errorSet = f.getErrorFileSet();
            try {
                if (f.actualFile.exists()) {
                    Files.copy((File)f.actualFile, (File)errorSet.actualFile);
                    f.actualFile.delete();
                }
                if (f.backupFile.exists()) {
                    Files.copy((File)f.backupFile, (File)errorSet.backupFile);
                    f.backupFile.delete();
                }
            }
            catch (Exception e) {
                AstralSorcery.log.info("[AstralSorcery] Attempting to copy erroneous worlddata '" + key.identifier + "' to its error files failed.");
                e.printStackTrace();
            }
        }
        if (data == null) {
            if (errored) {
                errorSet = f.getErrorFileSet();
                try {
                    if (f.actualFile.exists()) {
                        Files.copy((File)f.actualFile, (File)errorSet.actualFile);
                        f.actualFile.delete();
                    }
                    if (f.backupFile.exists()) {
                        Files.copy((File)f.backupFile, (File)errorSet.backupFile);
                        f.backupFile.delete();
                    }
                }
                catch (Exception e) {
                    AstralSorcery.log.info("[AstralSorcery] Attempting to copy erroneous worlddata '" + key.identifier + "' to its error files failed.");
                    e.printStackTrace();
                }
            }
            data = key.getNewInstance();
        }
        AstralSorcery.log.info("[AstralSorcery] Loading of '" + key.identifier + "' for world " + world.field_73011_w.getDimension() + " finished.");
        return data;
    }

    private static CachedWorldData attemptLoad(SaveKey key, File f) throws IOException {
        CachedWorldData data = key.getNewInstance();
        NBTTagCompound cmp = CompressedStreamTools.func_74797_a((File)f);
        data.readFromNBT(cmp);
        return data;
    }

    private static void saveDataToFile(World world, CachedWorldData data) throws IOException {
        SaveKey key = data.getSaveKey();
        DataFileSet f = WorldCacheManager.getDataFile(world, key.identifier);
        if (!f.actualFile.getParentFile().exists()) {
            f.actualFile.getParentFile().mkdirs();
        }
        if (f.actualFile.exists()) {
            try {
                Files.copy((File)f.actualFile, (File)f.backupFile);
            }
            catch (Exception exc) {
                AstralSorcery.log.info("[AstralSorcery] Copying '" + key.identifier + "' 's actual file to its backup file failed!");
                exc.printStackTrace();
            }
        }
        if (!f.actualFile.exists()) {
            f.actualFile.createNewFile();
        }
        NBTTagCompound tag = new NBTTagCompound();
        data.writeToNBT(tag);
        CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)f.actualFile);
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.field_72995_K) {
            return;
        }
        int dimId = world.field_73011_w.getDimension();
        Map<SaveKey, CachedWorldData> dataMap = cachedData.get(dimId);
        if (dataMap == null) {
            return;
        }
        for (SaveKey key : SaveKey.values()) {
            if (!dataMap.containsKey((Object)key)) continue;
            dataMap.get((Object)key).updateTick(world);
        }
    }

    public void doSave(World world) {
        int dimId = world.field_73011_w.getDimension();
        Map<SaveKey, CachedWorldData> worldCache = cachedData.get(dimId);
        if (worldCache == null) {
            return;
        }
        for (SaveKey key : SaveKey.values()) {
            CachedWorldData data;
            if (!worldCache.containsKey((Object)key) || !(data = worldCache.get((Object)key)).needsSaving()) continue;
            try {
                WorldCacheManager.saveDataToFile(world, data);
            }
            catch (IOException e) {
                AstralSorcery.log.warn("[AstralSorcery] Unable to save WorldData!");
                AstralSorcery.log.warn("[AstralSorcery] Affected data: Dim=" + dimId + " key=" + key.identifier);
                AstralSorcery.log.warn("[AstralSorcery] Printing StackTrace details...");
                e.printStackTrace();
            }
            data.clearDirtyFlag();
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "WorldCacheManager";
    }

    private static class DataFileSet {
        private final File actualFile;
        private final File backupFile;

        private DataFileSet(File actualFile) {
            this.actualFile = actualFile;
            this.backupFile = new File(actualFile.getParent(), actualFile.getName() + ".back");
        }

        private DataFileSet getErrorFileSet() {
            return new DataFileSet(new File(this.actualFile.getParent(), this.actualFile.getName() + ".error"));
        }
    }

    public static enum SaveKey {
        ROCK_CRYSTAL("rcrystals", RockCrystalBuffer::new),
        LIGHT_NETWORK("lightnetwork", LightNetworkBuffer::new),
        CHUNK_VERSIONING("chunkversions", ChunkVersionBuffer::new),
        GATEWAY_DATA("gateway", GatewayCache::new),
        STRUCTURE_GEN("structures", StructureGenBuffer::new);

        private final String identifier;
        private final DataProvider<CachedWorldData> instanceProvider;

        private SaveKey(String identifier, DataProvider<CachedWorldData> provider) {
            this.identifier = identifier;
            this.instanceProvider = provider;
        }

        public CachedWorldData getNewInstance() {
            return this.instanceProvider.provideDataInstance();
        }

        public String getIdentifier() {
            return this.identifier;
        }

        private static interface DataProvider<T extends CachedWorldData> {
            public T provideDataInstance();
        }
    }
}

