/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.tool.wand.ItemWand;
import hellfirepvp.astralsorcery.common.item.tool.wand.WandAugment;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WandAttunementRecipe
extends TraitRecipe {
    private final IMajorConstellation cst;

    public WandAttunementRecipe(IMajorConstellation cst, AccessibleRecipeAdapater ara) {
        super(ara);
        this.cst = cst;
    }

    @Override
    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        ItemStack center = invHandler.getStackInSlot(ShapedRecipeSlot.CENTER.getSlotID());
        if (center.func_190926_b() || !(center.func_77973_b() instanceof ItemWand) || ItemWand.getAugment(center) != null) {
            return false;
        }
        return super.matches(altar, invHandler, ignoreStarlightRequirement);
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender() {
        ItemStack cPaper = new ItemStack((Item)ItemsAS.wand);
        ItemWand.setAugment(cPaper, WandAugment.getByConstellation(this.cst));
        return cPaper;
    }

    @Override
    @Nonnull
    public ItemStack getOutputForMatching() {
        ItemStack cPaper = new ItemStack((Item)ItemsAS.wand);
        ItemWand.setAugment(cPaper, WandAugment.getByConstellation(this.cst));
        return cPaper;
    }

    @Override
    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        ItemStack cPaper = new ItemStack((Item)ItemsAS.wand);
        ItemWand.setAugment(cPaper, WandAugment.getByConstellation(this.cst));
        return cPaper;
    }
}

