/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class PerkDestructionArmor
extends ConstellationPerk {
    private static float dropChance = 0.2f;
    private static float damageChanceMultiplier = 0.2f;

    public PerkDestructionArmor() {
        super("DTR_ARMORBREAK", ConstellationPerk.Target.ENTITY_ATTACK);
    }

    @Override
    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        if (!attacked.field_70128_L) {
            float currentChance = MathHelper.func_76131_a((float)(dropChance + dmgIn * damageChanceMultiplier), (float)0.0f, (float)1.0f);
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack stack;
                if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || rand.nextFloat() < currentChance || (stack = attacked.func_184582_a(slot)).func_190926_b()) continue;
                this.addAlignmentCharge(attacker, 0.15);
                attacked.func_184201_a(slot, ItemStack.field_190927_a);
                ItemUtils.dropItemNaturally(attacked.field_70170_p, attacked.field_70165_t, attacked.field_70163_u, attacked.field_70161_v, stack);
                break;
            }
        }
        return dmgIn;
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        dropChance = cfg.getFloat(this.getKey() + "DropChance", this.getConfigurationSection(), dropChance, 0.0f, 1.0f, "Defines the chance (in percent) per hit to make the attacked entity drop its armor.");
        damageChanceMultiplier = cfg.getFloat(this.getKey() + "DamageChanceMultiplier", this.getConfigurationSection(), damageChanceMultiplier, 0.0f, 1.0f, "Defines the multiplier applied to damage to increase the drop chance. (Example: 2 damage at 1% would increase the chance by 2%)");
    }
}

