/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;

public class PerkDamageDistance
extends ConstellationPerk {
    private static float maxMultiplier = 4.0f;
    private static double maxRelevantSqDistance = 4096.0;

    public PerkDamageDistance() {
        super("DMG_DST", ConstellationPerk.Target.ENTITY_ATTACK);
    }

    @Override
    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        double dst = attacker.func_70068_e((Entity)attacked);
        float perc = (float)(dst / maxRelevantSqDistance);
        this.addAlignmentCharge(attacker, perc * 2.0f * Math.max(0.0f, dmgIn));
        return dmgIn * Math.max(1.0f, 1.0f + maxMultiplier * (perc > 1.0f ? 1.0f : perc));
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        maxMultiplier = cfg.getFloat(this.getKey() + "MaxMultiplier", this.getConfigurationSection(), maxMultiplier, 1.0f, 60.0f, "Defines the multiplier how much the player can get additionally at max. distance defined.");
        double dst = cfg.getFloat(this.getKey() + "MaxDistance", this.getConfigurationSection(), 64.0f, 16.0f, 2048.0f, "Defines the max. distance that is relevant. If you hit something further away it won't grant more additional bonus than defined in MaxMultiplier");
        maxRelevantSqDistance = dst * dst;
    }
}

