/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkCreationBreedables;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkCreationFlares;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkCreationGrowables;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkCreationMending;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkCreationReach;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkCreationStoneEnrichment;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDamageBleed;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDamageDistance;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDamageIncrease;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDamageKnockedback;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDamageOnKill;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDamageReflect;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDefensiveCheatDeath;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDefensiveDamageDodge;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDefensiveDamageReduction;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDefensiveElemental;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDefensiveNoArmor;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDefensiveReduceFall;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDestructionArmor;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDestructionDamageArc;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDestructionDigSpeed;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDestructionDigTypes;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDestructionLowHealth;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkDestructionStack;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkTravelLavaProtection;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkTravelMovespeed;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkTravelPlaceLight;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkTravelReduceFoodNeed;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkTravelStepAssist;
import hellfirepvp.astralsorcery.common.constellation.perk.impl.PerkTravelWaterMovement;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerServer;
import hellfirepvp.astralsorcery.common.util.data.TimeoutListContainer;

public enum ConstellationPerks {
    DMG_INCREASE(0, PerkDamageIncrease::new),
    DMG_AFTERKILL(1, PerkDamageOnKill::new),
    DMG_DISTANCE(2, PerkDamageDistance::new),
    DMG_KNOCKBACK(3, PerkDamageKnockedback::new),
    DMG_BLEED(4, PerkDamageBleed::new),
    DMG_REFLECT(5, PerkDamageReflect::new),
    TRV_PLACELIGHTS(20, PerkTravelPlaceLight::new),
    TRV_LAVAPROTECT(21, PerkTravelLavaProtection::new),
    TRV_MOVESPEED(22, PerkTravelMovespeed::new),
    TRV_SWIMSPEED(23, PerkTravelWaterMovement::new),
    TRV_REDFOODNEED(24, PerkTravelReduceFoodNeed::new),
    TRV_STEPASSIST(25, PerkTravelStepAssist::new),
    CRE_GROWTH(40, PerkCreationGrowables::new),
    CRE_BREEDING(41, PerkCreationBreedables::new),
    CRE_OREGEN(42, PerkCreationStoneEnrichment::new),
    CRE_REACH(43, PerkCreationReach::new),
    CRE_MEND(44, PerkCreationMending::new),
    CRE_FLARES(45, PerkCreationFlares::new),
    DEF_DMGREDUCTION(60, PerkDefensiveDamageReduction::new),
    DEF_DODGE(61, PerkDefensiveDamageDodge::new),
    DEF_NOARMOR(62, PerkDefensiveNoArmor::new),
    DEF_ELEMENTAL(63, PerkDefensiveElemental::new),
    DEF_FALLREDUCTION(64, PerkDefensiveReduceFall::new),
    DEF_CHEATDEATH(65, PerkDefensiveCheatDeath::new),
    DTR_DIG_SPEED(80, PerkDestructionDigSpeed::new),
    DTR_DIG_TYPES(81, PerkDestructionDigTypes::new),
    DTR_ARMOR_BREAK(82, PerkDestructionArmor::new),
    DTR_DAMAGE_ARC(83, PerkDestructionDamageArc::new),
    DTR_LOW_HEALTH(84, PerkDestructionLowHealth::new),
    DTR_STACK(85, PerkDestructionStack::new);

    private final int id;
    private final PerkProvider provider;
    private final ConstellationPerk singleInstance;

    private ConstellationPerks(int id, PerkProvider provider) {
        this.id = id;
        this.provider = provider;
        this.singleInstance = this.createPerk();
    }

    public ConstellationPerk getSingleInstance() {
        return this.singleInstance;
    }

    public int getId() {
        return this.id;
    }

    public ConstellationPerk createPerk() {
        ConstellationPerk newPerk = this.provider.providePerk();
        newPerk.setId(this.id);
        return newPerk;
    }

    public boolean isInstanceOfThis(ConstellationPerk perk) {
        return perk.getId() == this.id;
    }

    public static void addDynamicConfigEntries() {
        for (ConstellationPerks p : ConstellationPerks.values()) {
            ConstellationPerk perk = p.getSingleInstance();
            if (!perk.hasConfigEntries()) continue;
            Config.addDynamicEntry(perk);
        }
    }

    public static ConstellationPerks getById(int id) {
        for (ConstellationPerks perk : ConstellationPerks.values()) {
            if (perk.id != id) continue;
            return perk;
        }
        return null;
    }

    public static class PerkTimeoutHandler
    implements TimeoutListContainer.ContainerTimeoutDelegate<EventHandlerServer.PlayerWrapperContainer, Integer> {
        @Override
        public void onContainerTimeout(EventHandlerServer.PlayerWrapperContainer key, Integer id) {
            ConstellationPerks timedOut = ConstellationPerks.getById(id);
            if (timedOut != null) {
                timedOut.getSingleInstance().onTimeout(key.player);
            }
        }
    }

    private static interface PerkProvider {
        public ConstellationPerk providePerk();
    }
}

