/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import net.minecraftforge.common.config.Configuration;

public class ConstellationPerkLevelManager {
    public static int[] levelsRequired = new int[8];
    public static int[] levelsRequiredClientCache = new int[8];

    public static int getAlignmentLevel(PlayerProgress progress) {
        int i;
        double charge = progress.getAlignmentCharge();
        if (charge >= (double)levelsRequired[levelsRequired.length - 1]) {
            return levelsRequired.length;
        }
        for (i = 0; i < levelsRequired.length && !(charge < (double)levelsRequired[i]); ++i) {
        }
        return i;
    }

    public static float getPercToNextLevel(PlayerProgress progress) {
        double current = progress.getAlignmentCharge();
        int level = progress.getAlignmentLevel();
        if (level >= levelsRequired.length) {
            return 1.0f;
        }
        if (level < 0) {
            return 0.0f;
        }
        double left = current - (double)(level - 1 < 0 ? 0 : levelsRequired[level - 1]);
        if (level >= levelsRequired.length) {
            return 1.0f;
        }
        double reqNext = levelsRequired[level] - (level - 1 < 0 ? 0 : levelsRequired[level - 1]);
        return (float)(left / reqNext);
    }

    public static ConfigEntry getLevelConfigurations() {
        return new ConfigEntry(ConfigEntry.Section.PERK_LEVELS, "levels"){

            @Override
            public void loadFromConfig(Configuration cfg) {
                int[] levelBuf = new int[]{cfg.getInt(this.getKey() + "_Level_1", this.getConfigurationSection(), 15, 1, Integer.MAX_VALUE, "Defines the amount of Alignment needed for level: 1"), cfg.getInt(this.getKey() + "_Level_2", this.getConfigurationSection(), 45, 2, Integer.MAX_VALUE, "Defines the amount of Alignment needed for level: 2"), cfg.getInt(this.getKey() + "_Level_3", this.getConfigurationSection(), 85, 3, Integer.MAX_VALUE, "Defines the amount of Alignment needed for level: 3"), cfg.getInt(this.getKey() + "_Level_4", this.getConfigurationSection(), 130, 4, Integer.MAX_VALUE, "Defines the amount of Alignment needed for level: 4"), cfg.getInt(this.getKey() + "_Level_5", this.getConfigurationSection(), 180, 5, Integer.MAX_VALUE, "Defines the amount of Alignment needed for level: 5"), cfg.getInt(this.getKey() + "_Level_6", this.getConfigurationSection(), 245, 6, Integer.MAX_VALUE, "(Unused YET) Defines the amount of Alignment needed for level: 6"), cfg.getInt(this.getKey() + "_Level_7", this.getConfigurationSection(), 325, 7, Integer.MAX_VALUE, "(Unused YET) Defines the amount of Alignment needed for level: 7"), cfg.getInt(this.getKey() + "_Level_8", this.getConfigurationSection(), 400, 8, Integer.MAX_VALUE, "(Unused YET) Defines the amount of Alignment needed for level: 8")};
                for (int i = 0; i < 7; ++i) {
                    int prev = levelBuf[i];
                    int next = levelBuf[i + 1];
                    if (prev < next) continue;
                    throw new IllegalStateException("Illegal AstralSorcery config state: Alignment required for level " + (i + 2) + " is lower than alignment needed for level " + (i + 1));
                }
                levelsRequired = levelBuf;
                levelsRequiredClientCache = new int[levelsRequired.length];
                System.arraycopy(levelsRequired, 0, levelsRequiredClientCache, 0, levelsRequired.length);
            }
        };
    }
}

