/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerEntity;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class GenListEntries {

    public static class PosDefinedTuple<K extends NBTBase, V extends NBTBase>
    implements CEffectPositionListGen.CEffectGenListEntry {
        private final BlockPos pos;
        public K key;
        public V value;

        public PosDefinedTuple(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.key = nbt.func_74781_a("mapKey");
            this.value = nbt.func_74781_a("mapValue");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74782_a("mapKey", this.key);
            nbt.func_74782_a("mapValue", this.value);
        }
    }

    public static class SimpleBlockPosEntry
    implements CEffectPositionListGen.CEffectGenListEntry {
        private final BlockPos pos;

        public SimpleBlockPosEntry(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
        }
    }

    public static class CounterMaxListEntry
    extends CounterListEntry {
        public int maxCount;

        public CounterMaxListEntry(BlockPos at, int maxCount) {
            super(at);
            this.maxCount = maxCount;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.maxCount = nbt.func_74762_e("maxCounter");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            super.writeToNBT(nbt);
            nbt.func_74768_a("maxCounter", this.maxCount);
        }
    }

    public static class CounterListEntry
    implements CEffectPositionListGen.CEffectGenListEntry {
        private final BlockPos at;
        public int counter;

        public CounterListEntry(BlockPos at) {
            this.at = at;
        }

        @Override
        public BlockPos getPos() {
            return this.at;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.counter = nbt.func_74762_e("counter");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("counter", this.counter);
        }
    }

    public static class PelotrioSpawnListEntry
    extends CounterListEntry {
        private ResourceLocation entityName;

        public PelotrioSpawnListEntry(BlockPos at) {
            super(at);
        }

        public PelotrioSpawnListEntry(BlockPos at, ResourceLocation entityName) {
            super(at);
            this.entityName = entityName;
        }

        @Nullable
        public static PelotrioSpawnListEntry createEntry(World world, BlockPos pos) {
            Biome b = world.func_180494_b(pos);
            LinkedList applicable = new LinkedList();
            if (ConstellationSkyHandler.getInstance().isNight(world)) {
                applicable.addAll(b.func_76747_a(EnumCreatureType.MONSTER));
            } else {
                applicable.addAll(b.func_76747_a(EnumCreatureType.CREATURE));
            }
            if (applicable.isEmpty()) {
                return null;
            }
            Collections.shuffle(applicable);
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)applicable.get(world.field_73012_v.nextInt(applicable.size()));
            Class applicableClass = entry.field_76300_b;
            ResourceLocation key = EntityList.func_191306_a((Class)applicableClass);
            if (key != null && EntityUtils.canEntitySpawnHere(world, pos, key, true)) {
                return new PelotrioSpawnListEntry(pos, key);
            }
            return null;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.entityName = new ResourceLocation(nbt.func_74779_i("entityName"));
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            super.writeToNBT(nbt);
            nbt.func_74778_a("entityName", this.entityName.toString());
        }

        public void spawn(World world) {
            Entity entity;
            if (this.entityName != null && EntityUtils.canEntitySpawnHere(world, this.getPos(), this.entityName, true) && (entity = EntityList.func_188429_b((ResourceLocation)this.entityName, (World)world)) != null) {
                BlockPos at = this.getPos();
                entity.func_70012_b((double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_180482_a(world.func_175649_E(at), null);
                    if (!((EntityLiving)entity).func_70058_J()) {
                        entity.func_70106_y();
                        return;
                    }
                }
                EventHandlerEntity.spawnSkipId = entity.func_145782_y();
                world.func_72838_d(entity);
                EventHandlerEntity.spawnSkipId = -1;
                world.func_175718_b(2004, entity.func_180425_c(), 0);
                world.func_175718_b(2004, entity.func_180425_c(), 0);
            }
        }
    }
}

