/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.distribution;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.client.util.mappings.ClientConstellationPositionMapping;
import hellfirepvp.astralsorcery.common.constellation.CelestialEvent;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.data.DataActiveCelestials;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldSkyHandler {
    public int lastRecordedDay = -1;
    private LinkedList<IConstellation> activeConstellations = new LinkedList();
    private Map<Integer, LinkedList<IConstellation>> initialValueMappings = new HashMap<Integer, LinkedList<IConstellation>>();
    private Map<Integer, Map<IConstellation, Float>> dayDistributionMap = new HashMap<Integer, Map<IConstellation, Float>>();
    private Map<IConstellation, Float> activeDistributions = new HashMap<IConstellation, Float>();
    private Object clientConstellationPositionMapping;
    private Random seededRand = null;
    private final long savedSeed;
    public boolean solarEclipse = false;
    public boolean dayOfSolarEclipse = false;
    public int prevSolarEclipseTick = 0;
    public int solarEclipseTick = 0;
    public boolean lunarEclipse = false;
    public boolean dayOfLunarEclipse = false;
    public int prevLunarEclipseTick = 0;
    public int lunarEclipseTick = 0;

    public WorldSkyHandler(long seed) {
        this.savedSeed = seed;
    }

    private void refreshRandom() {
        this.seededRand = new Random(this.savedSeed);
    }

    public void tick(World w) {
        if (!w.func_82736_K().func_82766_b("doDaylightCycle")) {
            return;
        }
        if (this.initialValueMappings.isEmpty()) {
            this.setupInitialFunctions();
        }
        if (w.field_72995_K && this.clientConstellationPositionMapping == null) {
            this.clientConstellationPositionMapping = new ClientConstellationPositionMapping();
        }
        this.evaluateCelestialEventTimes(w);
        int currentDay = (int)(w.func_72820_D() / 24000L);
        int trackingDifference = currentDay - this.lastRecordedDay;
        this.lastRecordedDay = currentDay;
        if (trackingDifference > 0) {
            this.scheduleDayProgression(w, trackingDifference);
        } else if (trackingDifference < 0) {
            this.scheduleDayProgression(w, currentDay + 1);
        }
    }

    private void setupInitialFunctions() {
        this.initialValueMappings.clear();
        this.dayDistributionMap.clear();
        for (int i = 0; i < 8; ++i) {
            this.initialValueMappings.put(i, new LinkedList());
            this.dayDistributionMap.put(i, new HashMap());
        }
        this.refreshRandom();
        boolean[] occupied = new boolean[8];
        Arrays.fill(occupied, false);
        LinkedList<IMinorConstellation> constellations = new LinkedList<IMinorConstellation>(ConstellationRegistry.getMinorConstellations());
        Collections.shuffle(constellations, this.seededRand);
        LinkedList<IWeakConstellation> weakAndMajor = new LinkedList<IWeakConstellation>(ConstellationRegistry.getWeakConstellations());
        Collections.shuffle(weakAndMajor, this.seededRand);
        weakAndMajor.forEach(constellations::addFirst);
        for (IConstellation iConstellation : constellations) {
            int index;
            int i;
            int start;
            if (iConstellation instanceof IConstellationSpecialShowup) continue;
            if (iConstellation instanceof IMinorConstellation) {
                for (MoonPhase ph : ((IMinorConstellation)iConstellation).getShowupMoonPhases(this.savedSeed)) {
                    this.initialValueMappings.get(ph.ordinal()).add(iConstellation);
                }
                for (int i2 = 0; i2 < 8; ++i2) {
                    this.dayDistributionMap.get(i2).put(iConstellation, Float.valueOf(0.0f));
                }
                continue;
            }
            boolean foundFree = false;
            int tries = 5;
            do {
                --tries;
                start = this.seededRand.nextInt(8);
                int needed = Math.min(3, this.getFreeSlots(occupied));
                int count = this.collect(start, occupied);
                if (count < needed) continue;
                foundFree = true;
            } while (!foundFree && tries > 0);
            this.occupySlots(start, occupied);
            if (this.getFreeSlots(occupied) <= 0) {
                Arrays.fill(occupied, false);
            }
            for (i = 0; i < 5; ++i) {
                index = (start + i) % 8;
                this.initialValueMappings.get(index).addLast(iConstellation);
            }
            if (iConstellation instanceof IWeakConstellation) {
                for (i = 0; i < 8; ++i) {
                    index = (start + i) % 8;
                    float distr = this.spSine(start, index);
                    this.dayDistributionMap.get(index).put(iConstellation, Float.valueOf(distr));
                }
                continue;
            }
            for (i = 0; i < 8; ++i) {
                this.dayDistributionMap.get(i).put(iConstellation, Float.valueOf(0.0f));
            }
        }
    }

    private float spSine(int dayStart, int dayIn) {
        int v = dayStart > dayIn ? dayIn + 8 - dayStart : dayIn;
        float part = (float)v / 4.0f;
        return MathHelper.func_76126_a((float)((float)((double)part * Math.PI))) * 0.25f + 0.75f;
    }

    private void scheduleDayProgression(World w, int days) {
        for (int i = 0; i < days; ++i) {
            this.doConstellationIteration(w);
        }
        if (!w.field_72995_K) {
            DataActiveCelestials celestials = (DataActiveCelestials)SyncDataHolder.getDataServer("AstralConstellations");
            celestials.setNewConstellations(w.field_73011_w.getDimension(), this.activeConstellations);
        } else {
            ((ClientConstellationPositionMapping)this.clientConstellationPositionMapping).updatePositions(this.activeConstellations);
        }
    }

    private void doConstellationIteration(World w) {
        this.activeConstellations.clear();
        this.activeDistributions.clear();
        int activeDay = (this.lastRecordedDay % 8 + 8) % 8;
        LinkedList linkedConstellations = this.initialValueMappings.computeIfAbsent(activeDay, day -> new LinkedList());
        for (int i = 0; i < Math.min(10, linkedConstellations.size()); ++i) {
            this.activeConstellations.addLast((IConstellation)linkedConstellations.get(i));
        }
        Map<IConstellation, Float> iteration = this.dayDistributionMap.get(activeDay);
        while (iteration == null) {
            this.setupInitialFunctions();
            iteration = this.dayDistributionMap.get(activeDay);
        }
        this.activeDistributions = Maps.newHashMap(iteration);
        for (IConstellationSpecialShowup special : ConstellationRegistry.getSpecialShowupConstellations()) {
            if (special.doesShowUp(this, w, this.lastRecordedDay)) {
                this.activeConstellations.addLast(special);
                this.activeDistributions.put(special, Float.valueOf(MathHelper.func_76131_a((float)special.getDistribution(this, w, this.lastRecordedDay, true), (float)0.0f, (float)1.0f)));
                continue;
            }
            this.activeDistributions.put(special, Float.valueOf(MathHelper.func_76131_a((float)special.getDistribution(this, w, this.lastRecordedDay, false), (float)0.0f, (float)1.0f)));
        }
    }

    private void occupySlots(int start, boolean[] occupied) {
        for (int i = start; i < start + 8; ++i) {
            int index = start % 8;
            if (occupied[index]) continue;
            occupied[index] = true;
        }
    }

    private int collect(int start, boolean[] occupied) {
        int found = 0;
        for (int i = start; i < start + 8; ++i) {
            int index = start % 8;
            if (occupied[index]) continue;
            ++found;
        }
        return found;
    }

    private int getFreeSlots(boolean[] array) {
        int it = 0;
        for (boolean b : array) {
            if (b) continue;
            ++it;
        }
        return it;
    }

    public boolean isActive(IConstellation c) {
        return this.getActiveConstellations().contains(c);
    }

    public List<IConstellation> getActiveConstellations() {
        return Collections.unmodifiableList(this.activeConstellations);
    }

    public LinkedList<IConstellation> getSortedActiveConstellations() {
        LinkedList<IConstellation> out = new LinkedList<IConstellation>();
        LinkedList entries = new LinkedList();
        this.activeDistributions.entrySet().forEach(entries::add);
        entries.sort((e1, e2) -> MathHelper.func_76141_d((float)(((Float)e2.getValue()).floatValue() * 1000.0f)) - MathHelper.func_76141_d((float)(((Float)e1.getValue()).floatValue() * 1000.0f)));
        entries.forEach(e -> out.addLast((IConstellation)e.getKey()));
        return out;
    }

    @Nullable
    public IConstellation getHighestDistributionConstellation(Random random) {
        return this.getHighestDistributionConstellation(random, c -> true);
    }

    @Nullable
    public IConstellation getHighestDistributionConstellation(Random random, Predicate<IConstellation> acceptorFunc) {
        float highest = -1.0f;
        LinkedList<IConstellation> highestVal = new LinkedList<IConstellation>();
        for (Map.Entry<IConstellation, Float> entry : this.activeDistributions.entrySet()) {
            if (entry.getValue().floatValue() > highest) {
                if (!acceptorFunc.test(entry.getKey())) continue;
                highest = entry.getValue().floatValue();
                highestVal.clear();
                highestVal.add(entry.getKey());
                continue;
            }
            if (entry.getValue().floatValue() != highest || !acceptorFunc.test(entry.getKey())) continue;
            highestVal.add(entry.getKey());
        }
        if (highestVal.isEmpty()) {
            return null;
        }
        return (IConstellation)highestVal.get(random.nextInt(highestVal.size()));
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ClientConstellationPositionMapping getConstellationPositionMapping() {
        if (this.clientConstellationPositionMapping == null) {
            return null;
        }
        return (ClientConstellationPositionMapping)this.clientConstellationPositionMapping;
    }

    public MoonPhase getCurrentMoonPhase() {
        return MoonPhase.values()[(this.lastRecordedDay % 8 + 8) % 8];
    }

    public List<IConstellation> getConstellationsForMoonPhase(MoonPhase phase) {
        return this.initialValueMappings.get(phase.ordinal());
    }

    public List<CelestialEvent> getCurrentDayCelestialEvents() {
        LinkedList<CelestialEvent> list = new LinkedList<CelestialEvent>();
        if (this.dayOfSolarEclipse) {
            list.add(CelestialEvent.SOLAR_ECLIPSE);
        }
        if (this.dayOfLunarEclipse) {
            list.add(CelestialEvent.LUNAR_ECLIPSE);
        }
        return list;
    }

    public CelestialEvent getCurrentlyActiveEvent() {
        if (this.solarEclipse) {
            return CelestialEvent.SOLAR_ECLIPSE;
        }
        if (this.lunarEclipse) {
            return CelestialEvent.LUNAR_ECLIPSE;
        }
        return null;
    }

    private void evaluateCelestialEventTimes(World world) {
        long seed = new Random(world.func_72912_H().func_76063_b()).nextLong();
        if (world.field_72995_K) {
            Optional<Long> testSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent(world);
            if (!testSeed.isPresent()) {
                return;
            }
            seed = testSeed.get();
        }
        Random r = new Random(seed);
        for (int i = 0; i < 10 + r.nextInt(10); ++i) {
            r.nextLong();
        }
        int rand = r.nextInt(36);
        if (rand >= 18) {
            rand -= 36;
        }
        int offset = 36 - rand;
        int repeat = 36;
        long wTime = world.func_72820_D();
        int solarTime = (int)((wTime - (long)(offset * 24000)) % (long)(repeat * 24000));
        boolean bl = this.dayOfSolarEclipse = solarTime < 24000;
        if (wTime > 24000L && solarTime > 3600 && solarTime < 8400) {
            this.solarEclipse = true;
            this.prevSolarEclipseTick = this.solarEclipseTick;
            this.solarEclipseTick = solarTime - 3600;
        } else {
            this.solarEclipse = false;
            this.solarEclipseTick = 0;
            this.prevSolarEclipseTick = 0;
        }
        repeat = 68;
        int lunarTime = (int)(wTime % (long)(repeat * 24000));
        boolean bl2 = this.dayOfLunarEclipse = lunarTime < 24000;
        if (wTime > 24000L && lunarTime > 15600 && lunarTime < 20400) {
            this.lunarEclipse = true;
            this.prevLunarEclipseTick = this.lunarEclipseTick;
            this.lunarEclipseTick = lunarTime - 15600;
        } else {
            this.lunarEclipse = false;
            this.lunarEclipseTick = 0;
            this.prevLunarEclipseTick = 0;
        }
    }

    public Float getCurrentDistribution(IConstellation c, Function<Float, Float> func) {
        if (!this.activeDistributions.containsKey(c)) {
            return func.apply(Float.valueOf(0.0f));
        }
        return func.apply(this.activeDistributions.get(c));
    }
}

