/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.tile.TileTranslucent;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTranslucentBlock
extends BlockContainer {
    public BlockTranslucentBlock() {
        super(Material.field_175972_I);
        this.func_149722_s();
        this.func_149752_b(6000001.0f);
        this.func_149715_a(0.6f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState fst = this.getFakedStateTile(world, pos);
        if (fst != null) {
            RenderingUtils.playBlockBreakParticles(pos, fst);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(30) == 0) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + rand.nextFloat(), (float)pos.func_177952_p() + rand.nextFloat());
            p.motion(0.0, 0.0, 0.0);
            p.scale(0.45f).setColor(Color.WHITE).setMaxAge(65);
        }
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        IBlockState fst = this.getFakedStateTile(world, pos);
        if (fst != null) {
            return fst.func_177230_c().getSoundType(fst, world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState fst = this.getFakedStateTile(worldIn, pos);
        if (fst != null) {
            Block actual = fst.func_177230_c();
            try {
                return actual.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    private IBlockState getFakedStateTile(World world, BlockPos pos) {
        TileTranslucent tt = MiscUtils.getTileAt((IBlockAccess)world, pos, TileTranslucent.class, true);
        if (tt == null) {
            return null;
        }
        return tt.getFakedState();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState fst = this.getFakedStateTile(world, pos);
        try {
            if (fst != null) {
                return fst.func_177230_c().getPickBlock(fst, target, world, pos, player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ItemStack.field_190927_a;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileTranslucent();
    }
}

