/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockDynamicStateMapper;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;

public class BlockMarble
extends Block
implements BlockCustomName,
BlockVariants,
BlockDynamicStateMapper.Festive {
    public static PropertyEnum<MarbleBlockType> MARBLE_TYPE = PropertyEnum.func_177709_a((String)"marbletype", MarbleBlockType.class);

    public BlockMarble() {
        super(Material.field_151576_e, MapColor.field_151670_w);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149752_b(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MARBLE_TYPE, (Comparable)((Object)MarbleBlockType.RAW)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (MarbleBlockType t : MarbleBlockType.values()) {
            if (!t.obtainableInCreative()) continue;
            list.add((Object)new ItemStack((Block)this, 1, t.getMeta()));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE))).isPillar()) {
            IBlockState st = worldIn.func_180495_p(pos.func_177984_a());
            boolean top = false;
            if (st.func_177230_c() instanceof BlockMarble && ((MarbleBlockType)((Object)st.func_177229_b(MARBLE_TYPE))).isPillar()) {
                top = true;
            }
            st = worldIn.func_180495_p(pos.func_177977_b());
            boolean down = false;
            if (st.func_177230_c() instanceof BlockMarble && ((MarbleBlockType)((Object)st.func_177229_b(MARBLE_TYPE))).isPillar()) {
                down = true;
            }
            if (top && down) {
                return state.func_177226_a(MARBLE_TYPE, (Comparable)((Object)MarbleBlockType.PILLAR));
            }
            if (top) {
                return state.func_177226_a(MARBLE_TYPE, (Comparable)((Object)MarbleBlockType.PILLAR_BOTTOM));
            }
            if (down) {
                return state.func_177226_a(MARBLE_TYPE, (Comparable)((Object)MarbleBlockType.PILLAR_TOP));
            }
            return state.func_177226_a(MARBLE_TYPE, (Comparable)((Object)MarbleBlockType.PILLAR));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return ((MarbleBlockType)((Object)p_193383_2_.func_177229_b(MARBLE_TYPE))).isPillar() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        MarbleBlockType marbleType = (MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE));
        if (marbleType == MarbleBlockType.PILLAR_TOP || marbleType == MarbleBlockType.PILLAR || marbleType == MarbleBlockType.PILLAR_BOTTOM) {
            return 0;
        }
        return super.getLightOpacity(state, world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        MarbleBlockType marbleType = (MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE));
        return marbleType != MarbleBlockType.PILLAR && marbleType != MarbleBlockType.PILLAR_BOTTOM && marbleType != MarbleBlockType.PILLAR_TOP;
    }

    public boolean func_149686_d(IBlockState state) {
        MarbleBlockType marbleType = (MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE));
        return marbleType != MarbleBlockType.PILLAR && marbleType != MarbleBlockType.PILLAR_BOTTOM && marbleType != MarbleBlockType.PILLAR_TOP;
    }

    public boolean func_149730_j(IBlockState state) {
        MarbleBlockType marbleType = (MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE));
        return marbleType != MarbleBlockType.PILLAR && marbleType != MarbleBlockType.PILLAR_BOTTOM && marbleType != MarbleBlockType.PILLAR_TOP;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        MarbleBlockType marbleType = (MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE));
        IBlockState other = world.func_180495_p(pos.func_177972_a(face));
        if ((other.func_177230_c() instanceof BlockLiquid || other.func_177230_c() instanceof BlockFluidBase) && (marbleType == MarbleBlockType.PILLAR || marbleType == MarbleBlockType.PILLAR_BOTTOM || marbleType == MarbleBlockType.PILLAR_TOP)) {
            return false;
        }
        if (marbleType == MarbleBlockType.PILLAR_TOP) {
            return face == EnumFacing.UP;
        }
        if (marbleType == MarbleBlockType.PILLAR_BOTTOM) {
            return face == EnumFacing.DOWN;
        }
        return state.func_185914_p();
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        MarbleBlockType mt = (MarbleBlockType)((Object)this.func_176203_a(meta).func_177229_b(MARBLE_TYPE));
        return mt.func_176610_l();
    }

    public int func_176201_c(IBlockState state) {
        MarbleBlockType type = (MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE));
        return type.getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return meta < MarbleBlockType.values().length ? this.func_176223_P().func_177226_a(MARBLE_TYPE, (Comparable)((Object)MarbleBlockType.values()[meta])) : this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MARBLE_TYPE});
    }

    @Override
    public List<IBlockState> getValidStates() {
        LinkedList<IBlockState> ret = new LinkedList<IBlockState>();
        for (MarbleBlockType type : MarbleBlockType.values()) {
            ret.add(this.func_176223_P().func_177226_a(MARBLE_TYPE, (Comparable)((Object)type)));
        }
        return ret;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((MarbleBlockType)((Object)state.func_177229_b(MARBLE_TYPE))).func_176610_l() + (this.handleRegisterStateMapper() ? "_festive" : "");
    }

    @Override
    public Map<IBlockState, ModelResourceLocation> getModelLocations(Block blockIn) {
        ResourceLocation rl = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)blockIn);
        rl = new ResourceLocation(rl.func_110624_b(), rl.func_110623_a() + "_festive");
        HashMap out = Maps.newHashMap();
        for (IBlockState state : this.getValidStates()) {
            out.put(state, new ModelResourceLocation(rl, this.getPropertyString((Map)state.func_177228_b())));
        }
        return out;
    }

    public static enum MarbleBlockType implements IStringSerializable
    {
        RAW(0),
        BRICKS(1),
        PILLAR(2),
        ARCH(3),
        CHISELED(4),
        ENGRAVED(5),
        RUNED(6),
        PILLAR_TOP(2),
        PILLAR_BOTTOM(2);

        private final int meta;

        private MarbleBlockType(int meta) {
            this.meta = meta;
        }

        public ItemStack asStack() {
            return new ItemStack((Block)BlocksAS.blockMarble, 1, this.meta);
        }

        public IBlockState asBlock() {
            return BlocksAS.blockMarble.func_176203_a(this.meta);
        }

        public boolean isPillar() {
            return this == PILLAR_BOTTOM || this == PILLAR || this == PILLAR_TOP;
        }

        public boolean obtainableInCreative() {
            return this != PILLAR_TOP && this != PILLAR_BOTTOM;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

